/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.cql;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.AllNodesFailedException;
import com.datastax.oss.driver.api.core.NodeUnavailableException;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.PrepareRequest;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.retry.RetryPolicy;
import com.datastax.oss.driver.api.core.retry.RetryVerdict;
import com.datastax.oss.driver.api.core.servererrors.CoordinatorException;
import com.datastax.oss.driver.api.core.servererrors.OverloadedException;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.channel.ResponseCallback;
import com.datastax.oss.driver.internal.core.cql.CqlPrepareHandler;
import com.datastax.oss.driver.internal.core.cql.CqlRequestHandlerTestBase;
import com.datastax.oss.driver.internal.core.cql.DefaultPrepareRequest;
import com.datastax.oss.driver.internal.core.cql.PoolBehavior;
import com.datastax.oss.driver.internal.core.cql.RequestHandlerTestHarness;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.request.Prepare;
import com.datastax.oss.protocol.internal.response.Error;
import com.datastax.oss.protocol.internal.response.result.ColumnSpec;
import com.datastax.oss.protocol.internal.response.result.Prepared;
import com.datastax.oss.protocol.internal.response.result.RawType;
import com.datastax.oss.protocol.internal.response.result.RowsMetadata;
import com.datastax.oss.protocol.internal.util.Bytes;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class CqlPrepareHandlerTest {
    private static final DefaultPrepareRequest PREPARE_REQUEST = new DefaultPrepareRequest("mock query");
    @Mock
    private Node node1;
    @Mock
    private Node node2;
    @Mock
    private Node node3;
    private final Map<String, ByteBuffer> payload = ImmutableMap.of((Object)"key1", (Object)ByteBuffer.wrap(new byte[]{1, 2, 3, 4}));

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void should_prepare_on_first_node_and_reprepare_on_others() {
        RequestHandlerTestHarness.Builder harnessBuilder = RequestHandlerTestHarness.builder();
        PoolBehavior node1Behavior = harnessBuilder.customBehavior(this.node1);
        PoolBehavior node2Behavior = harnessBuilder.customBehavior(this.node2);
        PoolBehavior node3Behavior = harnessBuilder.customBehavior(this.node3);
        try (RequestHandlerTestHarness harness = harnessBuilder.build();){
            CompletableFuture prepareFuture = new CqlPrepareHandler((PrepareRequest)PREPARE_REQUEST, harness.getSession(), harness.getContext(), "test").handle();
            node1Behavior.verifyWrite();
            node1Behavior.setWriteSuccess();
            node1Behavior.setResponseSuccess(CqlRequestHandlerTestBase.defaultFrameOf(CqlPrepareHandlerTest.simplePrepared()));
            Assertions.assertThatStage(prepareFuture).isNotDone();
            node2Behavior.verifyWrite();
            node2Behavior.setWriteSuccess();
            node2Behavior.setResponseSuccess(CqlRequestHandlerTestBase.defaultFrameOf(CqlPrepareHandlerTest.simplePrepared()));
            node3Behavior.verifyWrite();
            node3Behavior.setWriteSuccess();
            node3Behavior.setResponseSuccess(CqlRequestHandlerTestBase.defaultFrameOf(CqlPrepareHandlerTest.simplePrepared()));
            Assertions.assertThatStage(prepareFuture).isSuccess(CqlPrepareHandlerTest::assertMatchesSimplePrepared);
        }
    }

    @Test
    public void should_not_reprepare_on_other_nodes_if_disabled_in_config() {
        RequestHandlerTestHarness.Builder harnessBuilder = RequestHandlerTestHarness.builder();
        PoolBehavior node1Behavior = harnessBuilder.customBehavior(this.node1);
        PoolBehavior node2Behavior = harnessBuilder.customBehavior(this.node2);
        PoolBehavior node3Behavior = harnessBuilder.customBehavior(this.node3);
        try (RequestHandlerTestHarness harness = harnessBuilder.build();){
            DriverExecutionProfile config = harness.getContext().getConfig().getDefaultProfile();
            Mockito.when((Object)config.getBoolean((DriverOption)DefaultDriverOption.PREPARE_ON_ALL_NODES)).thenReturn((Object)false);
            CompletableFuture prepareFuture = new CqlPrepareHandler((PrepareRequest)PREPARE_REQUEST, harness.getSession(), harness.getContext(), "test").handle();
            node1Behavior.verifyWrite();
            node1Behavior.setWriteSuccess();
            node1Behavior.setResponseSuccess(CqlRequestHandlerTestBase.defaultFrameOf(CqlPrepareHandlerTest.simplePrepared()));
            Assertions.assertThatStage(prepareFuture).isSuccess();
            node2Behavior.verifyNoWrite();
            node3Behavior.verifyNoWrite();
        }
    }

    @Test
    public void should_ignore_errors_while_repreparing_on_other_nodes() {
        RequestHandlerTestHarness.Builder harnessBuilder = RequestHandlerTestHarness.builder().withResponse(this.node1, CqlRequestHandlerTestBase.defaultFrameOf(CqlPrepareHandlerTest.simplePrepared()));
        PoolBehavior node2Behavior = harnessBuilder.customBehavior(this.node2);
        PoolBehavior node3Behavior = harnessBuilder.customBehavior(this.node3);
        try (RequestHandlerTestHarness harness = harnessBuilder.build();){
            CompletableFuture prepareFuture = new CqlPrepareHandler((PrepareRequest)PREPARE_REQUEST, harness.getSession(), harness.getContext(), "test").handle();
            Assertions.assertThatStage(prepareFuture).isNotDone();
            node2Behavior.verifyWrite();
            node2Behavior.setWriteSuccess();
            node2Behavior.setResponseSuccess(CqlRequestHandlerTestBase.defaultFrameOf((Message)new Error(0, "mock error")));
            node3Behavior.verifyWrite();
            node3Behavior.setWriteFailure(new RuntimeException("mock error"));
            Assertions.assertThatStage(prepareFuture).isSuccess(CqlPrepareHandlerTest::assertMatchesSimplePrepared);
        }
    }

    @Test
    public void should_retry_initial_prepare_if_recoverable_error() {
        RequestHandlerTestHarness.Builder harnessBuilder = RequestHandlerTestHarness.builder().withResponse(this.node1, CqlRequestHandlerTestBase.defaultFrameOf((Message)new Error(4097, "mock message"))).withResponse(this.node2, CqlRequestHandlerTestBase.defaultFrameOf(CqlPrepareHandlerTest.simplePrepared()));
        PoolBehavior node3Behavior = harnessBuilder.customBehavior(this.node3);
        try (RequestHandlerTestHarness harness = harnessBuilder.build();){
            Mockito.when((Object)harness.getContext().getRetryPolicy(ArgumentMatchers.anyString()).onErrorResponseVerdict((Request)ArgumentMatchers.eq((Object)PREPARE_REQUEST), (CoordinatorException)ArgumentMatchers.any(OverloadedException.class), ArgumentMatchers.eq((int)0))).thenReturn((Object)RetryVerdict.RETRY_NEXT);
            CompletableFuture prepareFuture = new CqlPrepareHandler((PrepareRequest)PREPARE_REQUEST, harness.getSession(), harness.getContext(), "test").handle();
            Assertions.assertThatStage(prepareFuture).isNotDone();
            node3Behavior.verifyWrite();
            node3Behavior.setWriteSuccess();
            node3Behavior.setResponseSuccess(CqlRequestHandlerTestBase.defaultFrameOf(CqlPrepareHandlerTest.simplePrepared()));
            Assertions.assertThatStage(prepareFuture).isSuccess(CqlPrepareHandlerTest::assertMatchesSimplePrepared);
        }
    }

    @Test
    public void should_not_retry_initial_prepare_if_unrecoverable_error() {
        RequestHandlerTestHarness.Builder harnessBuilder = RequestHandlerTestHarness.builder().withResponse(this.node1, CqlRequestHandlerTestBase.defaultFrameOf((Message)new Error(4097, "mock message")));
        PoolBehavior node2Behavior = harnessBuilder.customBehavior(this.node2);
        PoolBehavior node3Behavior = harnessBuilder.customBehavior(this.node3);
        try (RequestHandlerTestHarness harness = harnessBuilder.build();){
            Mockito.when((Object)harness.getContext().getRetryPolicy(ArgumentMatchers.anyString()).onErrorResponseVerdict((Request)ArgumentMatchers.eq((Object)PREPARE_REQUEST), (CoordinatorException)ArgumentMatchers.any(OverloadedException.class), ArgumentMatchers.eq((int)0))).thenReturn((Object)RetryVerdict.RETHROW);
            CompletableFuture prepareFuture = new CqlPrepareHandler((PrepareRequest)PREPARE_REQUEST, harness.getSession(), harness.getContext(), "test").handle();
            Assertions.assertThatStage(prepareFuture).isFailed(error -> {
                Assertions.assertThat((Throwable)error).isInstanceOf(OverloadedException.class);
                node2Behavior.verifyNoWrite();
                node3Behavior.verifyNoWrite();
            });
        }
    }

    @Test
    public void should_fail_if_nodes_unavailable() {
        RequestHandlerTestHarness.Builder harnessBuilder = RequestHandlerTestHarness.builder();
        try (RequestHandlerTestHarness harness = harnessBuilder.withEmptyPool(this.node1).withEmptyPool(this.node2).build();){
            CompletableFuture prepareFuture = new CqlPrepareHandler((PrepareRequest)PREPARE_REQUEST, harness.getSession(), harness.getContext(), "test").handle();
            Assertions.assertThatStage(prepareFuture).isFailed(error -> {
                Assertions.assertThat((Throwable)error).isInstanceOf(AllNodesFailedException.class);
                Map allErrors = ((AllNodesFailedException)error).getAllErrors();
                Assertions.assertThat((Map)allErrors).hasSize(2);
                Assertions.assertThat((Map)allErrors).hasEntrySatisfying((Object)this.node1, nodeErrors -> {
                    ObjectAssert cfr_ignored_0 = (ObjectAssert)((ObjectAssert)Assertions.assertThat((List)nodeErrors).singleElement()).isInstanceOf(NodeUnavailableException.class);
                });
                Assertions.assertThat((Map)allErrors).hasEntrySatisfying((Object)this.node2, nodeErrors -> {
                    ObjectAssert cfr_ignored_0 = (ObjectAssert)((ObjectAssert)Assertions.assertThat((List)nodeErrors).singleElement()).isInstanceOf(NodeUnavailableException.class);
                });
            });
        }
    }

    @Test
    public void should_fail_if_retry_policy_ignores_error() {
        RequestHandlerTestHarness.Builder harnessBuilder = RequestHandlerTestHarness.builder().withResponse(this.node1, CqlRequestHandlerTestBase.defaultFrameOf((Message)new Error(4097, "mock message")));
        PoolBehavior node2Behavior = harnessBuilder.customBehavior(this.node2);
        PoolBehavior node3Behavior = harnessBuilder.customBehavior(this.node3);
        try (RequestHandlerTestHarness harness = harnessBuilder.build();){
            RetryPolicy mockRetryPolicy = harness.getContext().getRetryPolicy("default");
            Mockito.when((Object)mockRetryPolicy.onErrorResponseVerdict((Request)ArgumentMatchers.eq((Object)PREPARE_REQUEST), (CoordinatorException)ArgumentMatchers.any(OverloadedException.class), ArgumentMatchers.eq((int)0))).thenReturn((Object)RetryVerdict.IGNORE);
            CompletableFuture prepareFuture = new CqlPrepareHandler((PrepareRequest)PREPARE_REQUEST, harness.getSession(), harness.getContext(), "test").handle();
            Assertions.assertThatStage(prepareFuture).isFailed(error -> {
                ((AbstractThrowableAssert)Assertions.assertThat((Throwable)error).isInstanceOf(IllegalArgumentException.class)).hasMessage("IGNORE decisions are not allowed for prepare requests, please fix your retry policy.");
                node2Behavior.verifyNoWrite();
                node3Behavior.verifyNoWrite();
            });
        }
    }

    @Test
    public void should_propagate_custom_payload_on_single_node() {
        RequestHandlerTestHarness.Builder harnessBuilder = RequestHandlerTestHarness.builder();
        DefaultPrepareRequest prepareRequest = new DefaultPrepareRequest((SimpleStatement)SimpleStatement.newInstance((String)"irrelevant").setCustomPayload(this.payload));
        PoolBehavior node1Behavior = harnessBuilder.customBehavior(this.node1);
        PoolBehavior node2Behavior = harnessBuilder.customBehavior(this.node2);
        PoolBehavior node3Behavior = harnessBuilder.customBehavior(this.node3);
        node1Behavior.setResponseSuccess(CqlRequestHandlerTestBase.defaultFrameOf(CqlPrepareHandlerTest.simplePrepared()));
        try (RequestHandlerTestHarness harness = harnessBuilder.build();){
            DriverExecutionProfile config = harness.getContext().getConfig().getDefaultProfile();
            Mockito.when((Object)config.getBoolean((DriverOption)DefaultDriverOption.PREPARE_ON_ALL_NODES)).thenReturn((Object)false);
            CompletableFuture prepareFuture = new CqlPrepareHandler((PrepareRequest)prepareRequest, harness.getSession(), harness.getContext(), "test").handle();
            ((DriverChannel)Mockito.verify((Object)node1Behavior.channel)).write((Message)ArgumentMatchers.any(Prepare.class), ArgumentMatchers.anyBoolean(), (Map)ArgumentMatchers.eq(this.payload), (ResponseCallback)ArgumentMatchers.any(ResponseCallback.class));
            node2Behavior.verifyNoWrite();
            node3Behavior.verifyNoWrite();
            Assertions.assertThatStage(prepareFuture).isSuccess(CqlPrepareHandlerTest::assertMatchesSimplePrepared);
        }
    }

    @Test
    public void should_propagate_custom_payload_on_all_nodes() {
        RequestHandlerTestHarness.Builder harnessBuilder = RequestHandlerTestHarness.builder();
        DefaultPrepareRequest prepareRequest = new DefaultPrepareRequest((SimpleStatement)SimpleStatement.newInstance((String)"irrelevant").setCustomPayload(this.payload));
        PoolBehavior node1Behavior = harnessBuilder.customBehavior(this.node1);
        PoolBehavior node2Behavior = harnessBuilder.customBehavior(this.node2);
        PoolBehavior node3Behavior = harnessBuilder.customBehavior(this.node3);
        node1Behavior.setResponseSuccess(CqlRequestHandlerTestBase.defaultFrameOf(CqlPrepareHandlerTest.simplePrepared()));
        node2Behavior.setResponseSuccess(CqlRequestHandlerTestBase.defaultFrameOf(CqlPrepareHandlerTest.simplePrepared()));
        node3Behavior.setResponseSuccess(CqlRequestHandlerTestBase.defaultFrameOf(CqlPrepareHandlerTest.simplePrepared()));
        try (RequestHandlerTestHarness harness = harnessBuilder.build();){
            DriverExecutionProfile config = harness.getContext().getConfig().getDefaultProfile();
            Mockito.when((Object)config.getBoolean((DriverOption)DefaultDriverOption.PREPARE_ON_ALL_NODES)).thenReturn((Object)true);
            CompletableFuture prepareFuture = new CqlPrepareHandler((PrepareRequest)prepareRequest, harness.getSession(), harness.getContext(), "test").handle();
            ((DriverChannel)Mockito.verify((Object)node1Behavior.channel)).write((Message)ArgumentMatchers.any(Prepare.class), ArgumentMatchers.anyBoolean(), (Map)ArgumentMatchers.eq(this.payload), (ResponseCallback)ArgumentMatchers.any(ResponseCallback.class));
            ((DriverChannel)Mockito.verify((Object)node2Behavior.channel)).write((Message)ArgumentMatchers.any(Prepare.class), ArgumentMatchers.anyBoolean(), (Map)ArgumentMatchers.eq(this.payload), (ResponseCallback)ArgumentMatchers.any(ResponseCallback.class));
            ((DriverChannel)Mockito.verify((Object)node3Behavior.channel)).write((Message)ArgumentMatchers.any(Prepare.class), ArgumentMatchers.anyBoolean(), (Map)ArgumentMatchers.eq(this.payload), (ResponseCallback)ArgumentMatchers.any(ResponseCallback.class));
            Assertions.assertThatStage(prepareFuture).isSuccess(CqlPrepareHandlerTest::assertMatchesSimplePrepared);
        }
    }

    private static Message simplePrepared() {
        RowsMetadata variablesMetadata = new RowsMetadata((List)ImmutableList.of((Object)new ColumnSpec("ks", "table", "key", 0, (RawType)RawType.PRIMITIVES.get(13))), null, new int[]{0}, null);
        RowsMetadata resultMetadata = new RowsMetadata((List)ImmutableList.of((Object)new ColumnSpec("ks", "table", "message", 0, (RawType)RawType.PRIMITIVES.get(13))), null, new int[0], null);
        return new Prepared(Bytes.fromHexString((String)"0xffff").array(), null, variablesMetadata, resultMetadata);
    }

    private static void assertMatchesSimplePrepared(PreparedStatement statement) {
        Assertions.assertThat((String)Bytes.toHexString((ByteBuffer)statement.getId())).isEqualTo("0xffff");
        ColumnDefinitions variableDefinitions = statement.getVariableDefinitions();
        Assertions.assertThat((Iterable)variableDefinitions).hasSize(1);
        Assertions.assertThat((String)variableDefinitions.get(0).getName().asInternal()).isEqualTo("key");
        ColumnDefinitions resultSetDefinitions = statement.getResultSetDefinitions();
        Assertions.assertThat((Iterable)resultSetDefinitions).hasSize(1);
        Assertions.assertThat((String)resultSetDefinitions.get(0).getName().asInternal()).isEqualTo("message");
    }
}

