/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.context;

import com.datastax.oss.driver.api.core.Version;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.internal.core.context.DefaultDriverContext;
import com.datastax.oss.driver.internal.core.context.MockedDriverContextFactory;
import com.datastax.oss.protocol.internal.request.Startup;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=DataProviderRunner.class)
public class StartupOptionsBuilderTest {
    private DefaultDriverContext buildMockedContext(String compression) {
        DriverExecutionProfile defaultProfile = (DriverExecutionProfile)Mockito.mock(DriverExecutionProfile.class);
        Mockito.when((Object)defaultProfile.getString((DriverOption)DefaultDriverOption.PROTOCOL_COMPRESSION, "none")).thenReturn((Object)compression);
        return MockedDriverContextFactory.defaultDriverContext(Optional.of(defaultProfile));
    }

    private void assertDefaultStartupOptions(Startup startup) {
        Assertions.assertThat((Map)startup.options).containsEntry((Object)"CQL_VERSION", (Object)"3.0.0");
        Assertions.assertThat((Map)startup.options).containsEntry((Object)"DRIVER_NAME", (Object)Session.OSS_DRIVER_COORDINATES.getName());
        Assertions.assertThat((Map)startup.options).containsKey((Object)"DRIVER_VERSION");
        Version version = Version.parse((String)((String)startup.options.get("DRIVER_VERSION")));
        Assertions.assertThat((Comparable)version).isEqualByComparingTo((Comparable)Session.OSS_DRIVER_COORDINATES.getVersion());
    }

    @Test
    public void should_build_startup_options_with_no_compression_if_undefined() {
        DefaultDriverContext ctx = MockedDriverContextFactory.defaultDriverContext();
        Startup startup = new Startup(ctx.getStartupOptions());
        Assertions.assertThat((Map)startup.options).doesNotContainKey((Object)"COMPRESSION");
        this.assertDefaultStartupOptions(startup);
    }

    @Test
    public void should_build_startup_options_with_no_compression_if_defined_as_none() {
        DefaultDriverContext ctx = this.buildMockedContext("none");
        Startup startup = new Startup(ctx.getStartupOptions());
        Assertions.assertThat((Map)startup.options).doesNotContainKey((Object)"COMPRESSION");
        this.assertDefaultStartupOptions(startup);
    }

    @Test
    @DataProvider(value={"lz4", "snappy"})
    public void should_build_startup_options(String compression) {
        DefaultDriverContext ctx = this.buildMockedContext(compression);
        Startup startup = new Startup(ctx.getStartupOptions());
        Assertions.assertThat((Map)startup.options).containsEntry((Object)"COMPRESSION", (Object)compression);
        this.assertDefaultStartupOptions(startup);
    }

    @Test
    public void should_fail_to_build_startup_options_with_invalid_compression() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> {
            DefaultDriverContext ctx = this.buildMockedContext("foobar");
            new Startup(ctx.getStartupOptions());
        });
    }
}

