/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.context;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.metadata.NodeStateListener;
import com.datastax.oss.driver.api.core.metadata.schema.SchemaChangeListener;
import com.datastax.oss.driver.api.core.session.ProgrammaticArguments;
import com.datastax.oss.driver.api.core.tracker.RequestTracker;
import com.datastax.oss.driver.internal.core.context.DefaultDriverContext;
import com.datastax.oss.driver.shaded.guava.common.collect.Maps;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import org.mockito.Mockito;

public class MockedDriverContextFactory {
    public static DefaultDriverContext defaultDriverContext() {
        return MockedDriverContextFactory.defaultDriverContext(Optional.empty());
    }

    public static DefaultDriverContext defaultDriverContext(Optional<DriverExecutionProfile> profileOption) {
        DriverExecutionProfile profile = profileOption.orElseGet(() -> {
            DriverExecutionProfile blankProfile = (DriverExecutionProfile)Mockito.mock(DriverExecutionProfile.class);
            Mockito.when((Object)blankProfile.getString((DriverOption)DefaultDriverOption.PROTOCOL_COMPRESSION, "none")).thenReturn((Object)"none");
            Mockito.when((Object)blankProfile.getDuration((DriverOption)DefaultDriverOption.METRICS_NODE_EXPIRE_AFTER)).thenReturn((Object)Duration.ofMinutes(5L));
            Mockito.when((Object)blankProfile.isDefined((DriverOption)DefaultDriverOption.METRICS_FACTORY_CLASS)).thenReturn((Object)true);
            Mockito.when((Object)blankProfile.getString((DriverOption)DefaultDriverOption.METRICS_FACTORY_CLASS)).thenReturn((Object)"DefaultMetricsFactory");
            return blankProfile;
        });
        DriverConfig driverConfig = (DriverConfig)Mockito.mock(DriverConfig.class);
        DriverConfigLoader configLoader = (DriverConfigLoader)Mockito.mock(DriverConfigLoader.class);
        Mockito.when((Object)configLoader.getInitialConfig()).thenReturn((Object)driverConfig);
        Mockito.when((Object)driverConfig.getDefaultProfile()).thenReturn((Object)profile);
        ProgrammaticArguments args = ProgrammaticArguments.builder().withNodeStateListener((NodeStateListener)Mockito.mock(NodeStateListener.class)).withSchemaChangeListener((SchemaChangeListener)Mockito.mock(SchemaChangeListener.class)).withRequestTracker((RequestTracker)Mockito.mock(RequestTracker.class)).withLocalDatacenters((Map)Maps.newHashMap()).withNodeDistanceEvaluators((Map)Maps.newHashMap()).build();
        return new DefaultDriverContext(configLoader, args);
    }
}

