/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.connection;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.connection.ReconnectionPolicy;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.internal.core.connection.ExponentialReconnectionPolicy;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class ExponentialReconnectionPolicyTest {
    @Mock
    private DriverContext driverContext;
    @Mock
    private DriverConfig driverConfig;
    @Mock
    private DriverExecutionProfile profile;
    private final long baseDelay = 1000L;
    private final long maxDelay = 60000L;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.driverConfig.getDefaultProfile()).thenReturn((Object)this.profile);
        Mockito.when((Object)this.driverContext.getConfig()).thenReturn((Object)this.driverConfig);
        Mockito.when((Object)this.profile.getDuration((DriverOption)DefaultDriverOption.RECONNECTION_BASE_DELAY)).thenReturn((Object)Duration.of(1000L, ChronoUnit.MILLIS));
        Mockito.when((Object)this.profile.getDuration((DriverOption)DefaultDriverOption.RECONNECTION_MAX_DELAY)).thenReturn((Object)Duration.of(60000L, ChronoUnit.MILLIS));
    }

    @Test
    public void should_generate_exponential_delay_with_jitter() throws Exception {
        ExponentialReconnectionPolicy policy = new ExponentialReconnectionPolicy(this.driverContext);
        ReconnectionPolicy.ReconnectionSchedule schedule = policy.newControlConnectionSchedule(false);
        for (int i = 0; i < 54; ++i) {
            long exponentialDelay = Math.min(1000L * (1L << i), 60000L);
            long minJitterDelay = Math.max(1000L, exponentialDelay * 85L / 100L);
            long maxJitterDelay = Math.min(60000L, exponentialDelay * 115L / 100L);
            long delay = schedule.nextDelay().toMillis();
            Assertions.assertThat((long)delay).isBetween(Long.valueOf(minJitterDelay), Long.valueOf(maxJitterDelay));
        }
    }
}

