/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.channel;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.DefaultProtocolVersion;
import com.datastax.oss.driver.api.core.InvalidKeyspaceException;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.auth.AuthProvider;
import com.datastax.oss.driver.api.core.auth.AuthenticationException;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.internal.core.DefaultProtocolVersionRegistry;
import com.datastax.oss.driver.internal.core.ProtocolVersionRegistry;
import com.datastax.oss.driver.internal.core.TestResponses;
import com.datastax.oss.driver.internal.core.channel.ChannelHandlerTestBase;
import com.datastax.oss.driver.internal.core.channel.ClusterNameMismatchException;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.channel.DriverChannelOptions;
import com.datastax.oss.driver.internal.core.channel.EventCallback;
import com.datastax.oss.driver.internal.core.channel.HeartbeatHandler;
import com.datastax.oss.driver.internal.core.channel.InFlightHandler;
import com.datastax.oss.driver.internal.core.channel.MockAuthenticator;
import com.datastax.oss.driver.internal.core.channel.ProtocolInitHandler;
import com.datastax.oss.driver.internal.core.channel.StreamIdGenerator;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.TestNodeFactory;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.protocol.internal.Frame;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.request.AuthResponse;
import com.datastax.oss.protocol.internal.request.Options;
import com.datastax.oss.protocol.internal.request.Query;
import com.datastax.oss.protocol.internal.request.Register;
import com.datastax.oss.protocol.internal.request.Startup;
import com.datastax.oss.protocol.internal.response.AuthChallenge;
import com.datastax.oss.protocol.internal.response.AuthSuccess;
import com.datastax.oss.protocol.internal.response.Authenticate;
import com.datastax.oss.protocol.internal.response.Error;
import com.datastax.oss.protocol.internal.response.Ready;
import com.datastax.oss.protocol.internal.response.result.SetKeyspace;
import com.datastax.oss.protocol.internal.util.Bytes;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractThrowableAssert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.slf4j.LoggerFactory;

public class ProtocolInitHandlerTest
extends ChannelHandlerTestBase {
    private static final long QUERY_TIMEOUT_MILLIS = 100L;
    private static final EndPoint END_POINT = TestNodeFactory.newEndPoint(1);
    @Mock
    private InternalDriverContext internalDriverContext;
    @Mock
    private DriverConfig driverConfig;
    @Mock
    private DriverExecutionProfile defaultProfile;
    @Mock
    private Appender<ILoggingEvent> appender;
    private ProtocolVersionRegistry protocolVersionRegistry = new DefaultProtocolVersionRegistry("test");
    private HeartbeatHandler heartbeatHandler;

    @Override
    @Before
    public void setup() {
        super.setup();
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.internalDriverContext.getConfig()).thenReturn((Object)this.driverConfig);
        Mockito.when((Object)this.driverConfig.getDefaultProfile()).thenReturn((Object)this.defaultProfile);
        Mockito.when((Object)this.defaultProfile.getDuration((DriverOption)DefaultDriverOption.CONNECTION_INIT_QUERY_TIMEOUT)).thenReturn((Object)Duration.ofMillis(100L));
        Mockito.when((Object)this.defaultProfile.getDuration((DriverOption)DefaultDriverOption.HEARTBEAT_INTERVAL)).thenReturn((Object)Duration.ofSeconds(30L));
        Mockito.when((Object)this.internalDriverContext.getProtocolVersionRegistry()).thenReturn((Object)this.protocolVersionRegistry);
        this.channel.pipeline().addLast("inflight", (ChannelHandler)new InFlightHandler((ProtocolVersion)DefaultProtocolVersion.V4, new StreamIdGenerator(100), Integer.MAX_VALUE, 100L, this.channel.newPromise(), null, "test"));
        this.heartbeatHandler = new HeartbeatHandler(this.defaultProfile);
    }

    @Test
    public void should_initialize() {
        this.channel.pipeline().addLast("init", (ChannelHandler)new ProtocolInitHandler(this.internalDriverContext, (ProtocolVersion)DefaultProtocolVersion.V4, null, END_POINT, DriverChannelOptions.DEFAULT, this.heartbeatHandler, false));
        ChannelFuture connectFuture = this.channel.connect((SocketAddress)new InetSocketAddress("localhost", 9042));
        Frame requestFrame = this.readOutboundFrame();
        Assertions.assertThat((Object)requestFrame.message).isInstanceOf(Startup.class);
        Assertions.assertThat(connectFuture).isNotDone();
        this.writeInboundFrame(this.buildInboundFrame(requestFrame, (Message)new Ready()));
        requestFrame = this.readOutboundFrame();
        Assertions.assertThat((Object)requestFrame.message).isInstanceOf(Query.class);
        this.writeInboundFrame(requestFrame, (Message)TestResponses.clusterNameResponse("someClusterName"));
        Assertions.assertThat(connectFuture).isSuccess();
    }

    @Test
    public void should_query_supported_options() {
        this.channel.pipeline().addLast("init", (ChannelHandler)new ProtocolInitHandler(this.internalDriverContext, (ProtocolVersion)DefaultProtocolVersion.V4, null, END_POINT, DriverChannelOptions.DEFAULT, this.heartbeatHandler, true));
        ChannelFuture connectFuture = this.channel.connect((SocketAddress)new InetSocketAddress("localhost", 9042));
        Frame requestFrame = this.readOutboundFrame();
        Assertions.assertThat((Object)requestFrame.message).isInstanceOf(Options.class);
        Assertions.assertThat(connectFuture).isNotDone();
        this.writeInboundFrame(requestFrame, (Message)TestResponses.supportedResponse("mock_key", "mock_value"));
        Map supportedOptions = (Map)this.channel.attr(DriverChannel.OPTIONS_KEY).get();
        Assertions.assertThat((Map)supportedOptions).containsKey((Object)"mock_key");
        Assertions.assertThat((List)((List)supportedOptions.get("mock_key"))).containsOnly((Object[])new String[]{"mock_value"});
        requestFrame = this.readOutboundFrame();
        Assertions.assertThat((Object)requestFrame.message).isInstanceOf(Startup.class);
        Assertions.assertThat(connectFuture).isNotDone();
        this.writeInboundFrame(this.buildInboundFrame(requestFrame, (Message)new Ready()));
        requestFrame = this.readOutboundFrame();
        Assertions.assertThat((Object)requestFrame.message).isInstanceOf(Query.class);
        this.writeInboundFrame(requestFrame, (Message)TestResponses.clusterNameResponse("someClusterName"));
        Assertions.assertThat(connectFuture).isSuccess();
    }

    @Test
    public void should_add_heartbeat_handler_to_pipeline_on_success() {
        ProtocolInitHandler protocolInitHandler = new ProtocolInitHandler(this.internalDriverContext, (ProtocolVersion)DefaultProtocolVersion.V4, null, END_POINT, DriverChannelOptions.DEFAULT, this.heartbeatHandler, false);
        this.channel.pipeline().addLast("init", (ChannelHandler)protocolInitHandler);
        ChannelFuture connectFuture = this.channel.connect((SocketAddress)new InetSocketAddress("localhost", 9042));
        Assertions.assertThat((Object)this.channel.pipeline().get("heartbeat")).isNull();
        Frame requestFrame = this.readOutboundFrame();
        Assertions.assertThat((Object)requestFrame.message).isInstanceOf(Startup.class);
        Assertions.assertThat(connectFuture).isNotDone();
        this.writeInboundFrame(this.buildInboundFrame(requestFrame, (Message)new Ready()));
        requestFrame = this.readOutboundFrame();
        Assertions.assertThat((Object)requestFrame.message).isInstanceOf(Query.class);
        this.writeInboundFrame(requestFrame, (Message)TestResponses.clusterNameResponse("someClusterName"));
        Assertions.assertThat(connectFuture).isSuccess();
        Assertions.assertThat((Object)this.channel.pipeline().get("heartbeat")).isEqualTo((Object)this.heartbeatHandler);
        Assertions.assertThat((Object)this.channel.pipeline().last()).isNotEqualTo((Object)protocolInitHandler);
    }

    @Test
    public void should_fail_to_initialize_if_init_query_times_out() throws InterruptedException {
        this.channel.pipeline().addLast("init", (ChannelHandler)new ProtocolInitHandler(this.internalDriverContext, (ProtocolVersion)DefaultProtocolVersion.V4, null, END_POINT, DriverChannelOptions.DEFAULT, this.heartbeatHandler, false));
        ChannelFuture connectFuture = this.channel.connect((SocketAddress)new InetSocketAddress("localhost", 9042));
        this.readOutboundFrame();
        TimeUnit.MILLISECONDS.sleep(200L);
        this.channel.runPendingTasks();
        Assertions.assertThat(connectFuture).isFailed();
    }

    @Test
    public void should_initialize_with_authentication() {
        this.channel.pipeline().addLast("init", (ChannelHandler)new ProtocolInitHandler(this.internalDriverContext, (ProtocolVersion)DefaultProtocolVersion.V4, null, END_POINT, DriverChannelOptions.DEFAULT, this.heartbeatHandler, false));
        String serverAuthenticator = "mockServerAuthenticator";
        AuthProvider authProvider = (AuthProvider)Mockito.mock(AuthProvider.class);
        MockAuthenticator authenticator = new MockAuthenticator();
        Mockito.when((Object)authProvider.newAuthenticator(END_POINT, serverAuthenticator)).thenReturn((Object)authenticator);
        Mockito.when((Object)this.internalDriverContext.getAuthProvider()).thenReturn(Optional.of(authProvider));
        ChannelFuture connectFuture = this.channel.connect((SocketAddress)new InetSocketAddress("localhost", 9042));
        Frame requestFrame = this.readOutboundFrame();
        Assertions.assertThat((Object)requestFrame.message).isInstanceOf(Startup.class);
        Assertions.assertThat(connectFuture).isNotDone();
        this.writeInboundFrame(requestFrame, (Message)new Authenticate(serverAuthenticator));
        ((AuthProvider)Mockito.verify((Object)authProvider)).newAuthenticator(END_POINT, serverAuthenticator);
        requestFrame = this.readOutboundFrame();
        Assertions.assertThat((Object)requestFrame.message).isInstanceOf(AuthResponse.class);
        AuthResponse authResponse = (AuthResponse)requestFrame.message;
        Assertions.assertThat((String)Bytes.toHexString((ByteBuffer)authResponse.token)).isEqualTo("0xcafebabe");
        Assertions.assertThat(connectFuture).isNotDone();
        String mockToken = "0xabcd";
        for (int i = 0; i < 5; ++i) {
            this.writeInboundFrame(requestFrame, (Message)new AuthChallenge(Bytes.fromHexString((String)mockToken)));
            requestFrame = this.readOutboundFrame();
            Assertions.assertThat((Object)requestFrame.message).isInstanceOf(AuthResponse.class);
            authResponse = (AuthResponse)requestFrame.message;
            Assertions.assertThat((String)Bytes.toHexString((ByteBuffer)authResponse.token)).isEqualTo(mockToken);
            Assertions.assertThat(connectFuture).isNotDone();
        }
        this.writeInboundFrame(requestFrame, (Message)new AuthSuccess(Bytes.fromHexString((String)mockToken)));
        Assertions.assertThat((String)authenticator.successToken).isEqualTo(mockToken);
        requestFrame = this.readOutboundFrame();
        this.writeInboundFrame(requestFrame, (Message)TestResponses.clusterNameResponse("someClusterName"));
        Assertions.assertThat(connectFuture).isSuccess();
    }

    @Test
    public void should_invoke_auth_provider_when_server_does_not_send_challenge() {
        this.channel.pipeline().addLast("init", (ChannelHandler)new ProtocolInitHandler(this.internalDriverContext, (ProtocolVersion)DefaultProtocolVersion.V4, null, END_POINT, DriverChannelOptions.DEFAULT, this.heartbeatHandler, false));
        AuthProvider authProvider = (AuthProvider)Mockito.mock(AuthProvider.class);
        Mockito.when((Object)this.internalDriverContext.getAuthProvider()).thenReturn(Optional.of(authProvider));
        ChannelFuture connectFuture = this.channel.connect((SocketAddress)new InetSocketAddress("localhost", 9042));
        Frame requestFrame = this.readOutboundFrame();
        Assertions.assertThat((Object)requestFrame.message).isInstanceOf(Startup.class);
        this.writeInboundFrame(this.buildInboundFrame(requestFrame, (Message)new Ready()));
        ((AuthProvider)Mockito.verify((Object)authProvider)).onMissingChallenge(END_POINT);
        requestFrame = this.readOutboundFrame();
        Assertions.assertThat((Object)requestFrame.message).isInstanceOf(Query.class);
        this.writeInboundFrame(requestFrame, (Message)TestResponses.clusterNameResponse("someClusterName"));
        Assertions.assertThat(connectFuture).isSuccess();
    }

    @Test
    public void should_fail_to_initialize_if_server_sends_auth_error() throws Throwable {
        this.channel.pipeline().addLast("init", (ChannelHandler)new ProtocolInitHandler(this.internalDriverContext, (ProtocolVersion)DefaultProtocolVersion.V4, null, END_POINT, DriverChannelOptions.DEFAULT, this.heartbeatHandler, false));
        String serverAuthenticator = "mockServerAuthenticator";
        AuthProvider authProvider = (AuthProvider)Mockito.mock(AuthProvider.class);
        MockAuthenticator authenticator = new MockAuthenticator();
        Mockito.when((Object)authProvider.newAuthenticator(END_POINT, serverAuthenticator)).thenReturn((Object)authenticator);
        Mockito.when((Object)this.internalDriverContext.getAuthProvider()).thenReturn(Optional.of(authProvider));
        ChannelFuture connectFuture = this.channel.connect((SocketAddress)new InetSocketAddress("localhost", 9042));
        Frame requestFrame = this.readOutboundFrame();
        Assertions.assertThat((Object)requestFrame.message).isInstanceOf(Startup.class);
        Assertions.assertThat(connectFuture).isNotDone();
        this.writeInboundFrame(requestFrame, (Message)new Authenticate("mockServerAuthenticator"));
        requestFrame = this.readOutboundFrame();
        Assertions.assertThat((Object)requestFrame.message).isInstanceOf(AuthResponse.class);
        Assertions.assertThat(connectFuture).isNotDone();
        this.writeInboundFrame(requestFrame, (Message)new Error(256, "mock error"));
        Assertions.assertThat(connectFuture).isFailed(e -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(AuthenticationException.class)).hasMessage(String.format("Authentication error on node %s: server replied with 'mock error' to AuthResponse request", END_POINT)));
    }

    @Test
    public void should_check_cluster_name_if_provided() {
        this.channel.pipeline().addLast("init", (ChannelHandler)new ProtocolInitHandler(this.internalDriverContext, (ProtocolVersion)DefaultProtocolVersion.V4, "expectedClusterName", END_POINT, DriverChannelOptions.DEFAULT, this.heartbeatHandler, false));
        ChannelFuture connectFuture = this.channel.connect((SocketAddress)new InetSocketAddress("localhost", 9042));
        Frame requestFrame = this.readOutboundFrame();
        this.writeInboundFrame(requestFrame, (Message)new Ready());
        requestFrame = this.readOutboundFrame();
        Assertions.assertThat((Object)requestFrame.message).isInstanceOf(Query.class);
        Query query = (Query)requestFrame.message;
        Assertions.assertThat((String)query.query).isEqualTo("SELECT cluster_name FROM system.local");
        Assertions.assertThat(connectFuture).isNotDone();
        this.writeInboundFrame(requestFrame, (Message)TestResponses.clusterNameResponse("expectedClusterName"));
        Assertions.assertThat(connectFuture).isSuccess();
    }

    @Test
    public void should_fail_to_initialize_if_cluster_name_does_not_match() throws Throwable {
        this.channel.pipeline().addLast("init", (ChannelHandler)new ProtocolInitHandler(this.internalDriverContext, (ProtocolVersion)DefaultProtocolVersion.V4, "expectedClusterName", END_POINT, DriverChannelOptions.DEFAULT, this.heartbeatHandler, false));
        ChannelFuture connectFuture = this.channel.connect((SocketAddress)new InetSocketAddress("localhost", 9042));
        this.writeInboundFrame(this.readOutboundFrame(), (Message)new Ready());
        this.writeInboundFrame(this.readOutboundFrame(), (Message)TestResponses.clusterNameResponse("differentClusterName"));
        Assertions.assertThat(connectFuture).isFailed(e -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(ClusterNameMismatchException.class)).hasMessageContaining(String.format("Node %s reports cluster name 'differentClusterName' that doesn't match our cluster name 'expectedClusterName'.", END_POINT)));
    }

    @Test
    public void should_initialize_with_keyspace() {
        DriverChannelOptions options = DriverChannelOptions.builder().withKeyspace(CqlIdentifier.fromCql((String)"ks")).build();
        this.channel.pipeline().addLast("init", (ChannelHandler)new ProtocolInitHandler(this.internalDriverContext, (ProtocolVersion)DefaultProtocolVersion.V4, null, END_POINT, options, this.heartbeatHandler, false));
        ChannelFuture connectFuture = this.channel.connect((SocketAddress)new InetSocketAddress("localhost", 9042));
        this.writeInboundFrame(this.readOutboundFrame(), (Message)new Ready());
        this.writeInboundFrame(this.readOutboundFrame(), (Message)TestResponses.clusterNameResponse("someClusterName"));
        Frame requestFrame = this.readOutboundFrame();
        Assertions.assertThat((Object)requestFrame.message).isInstanceOf(Query.class);
        Assertions.assertThat((String)((Query)requestFrame.message).query).isEqualTo("USE \"ks\"");
        this.writeInboundFrame(requestFrame, (Message)new SetKeyspace("ks"));
        Assertions.assertThat(connectFuture).isSuccess();
    }

    @Test
    public void should_initialize_with_events() {
        ImmutableList eventTypes = ImmutableList.of((Object)"foo", (Object)"bar");
        EventCallback eventCallback = (EventCallback)Mockito.mock(EventCallback.class);
        DriverChannelOptions driverChannelOptions = DriverChannelOptions.builder().withEvents((List)eventTypes, eventCallback).build();
        this.channel.pipeline().addLast("init", (ChannelHandler)new ProtocolInitHandler(this.internalDriverContext, (ProtocolVersion)DefaultProtocolVersion.V4, null, END_POINT, driverChannelOptions, this.heartbeatHandler, false));
        ChannelFuture connectFuture = this.channel.connect((SocketAddress)new InetSocketAddress("localhost", 9042));
        this.writeInboundFrame(this.readOutboundFrame(), (Message)new Ready());
        this.writeInboundFrame(this.readOutboundFrame(), (Message)TestResponses.clusterNameResponse("someClusterName"));
        Frame requestFrame = this.readOutboundFrame();
        Assertions.assertThat((Object)requestFrame.message).isInstanceOf(Register.class);
        Assertions.assertThat((List)((Register)requestFrame.message).eventTypes).containsExactly((Object[])new String[]{"foo", "bar"});
        this.writeInboundFrame(requestFrame, (Message)new Ready());
        Assertions.assertThat(connectFuture).isSuccess();
    }

    @Test
    public void should_initialize_with_keyspace_and_events() {
        ImmutableList eventTypes = ImmutableList.of((Object)"foo", (Object)"bar");
        EventCallback eventCallback = (EventCallback)Mockito.mock(EventCallback.class);
        DriverChannelOptions driverChannelOptions = DriverChannelOptions.builder().withKeyspace(CqlIdentifier.fromCql((String)"ks")).withEvents((List)eventTypes, eventCallback).build();
        this.channel.pipeline().addLast("init", (ChannelHandler)new ProtocolInitHandler(this.internalDriverContext, (ProtocolVersion)DefaultProtocolVersion.V4, null, END_POINT, driverChannelOptions, this.heartbeatHandler, false));
        ChannelFuture connectFuture = this.channel.connect((SocketAddress)new InetSocketAddress("localhost", 9042));
        this.writeInboundFrame(this.readOutboundFrame(), (Message)new Ready());
        this.writeInboundFrame(this.readOutboundFrame(), (Message)TestResponses.clusterNameResponse("someClusterName"));
        Frame requestFrame = this.readOutboundFrame();
        Assertions.assertThat((Object)requestFrame.message).isInstanceOf(Query.class);
        Assertions.assertThat((String)((Query)requestFrame.message).query).isEqualTo("USE \"ks\"");
        this.writeInboundFrame(requestFrame, (Message)new SetKeyspace("ks"));
        requestFrame = this.readOutboundFrame();
        Assertions.assertThat((Object)requestFrame.message).isInstanceOf(Register.class);
        Assertions.assertThat((List)((Register)requestFrame.message).eventTypes).containsExactly((Object[])new String[]{"foo", "bar"});
        this.writeInboundFrame(requestFrame, (Message)new Ready());
        Assertions.assertThat(connectFuture).isSuccess();
    }

    @Test
    public void should_fail_to_initialize_if_keyspace_is_invalid() {
        DriverChannelOptions driverChannelOptions = DriverChannelOptions.builder().withKeyspace(CqlIdentifier.fromCql((String)"ks")).build();
        this.channel.pipeline().addLast("init", (ChannelHandler)new ProtocolInitHandler(this.internalDriverContext, (ProtocolVersion)DefaultProtocolVersion.V4, null, END_POINT, driverChannelOptions, this.heartbeatHandler, false));
        ChannelFuture connectFuture = this.channel.connect((SocketAddress)new InetSocketAddress("localhost", 9042));
        this.writeInboundFrame(this.readOutboundFrame(), (Message)new Ready());
        this.writeInboundFrame(this.readOutboundFrame(), (Message)TestResponses.clusterNameResponse("someClusterName"));
        Frame requestFrame = this.readOutboundFrame();
        Assertions.assertThat((Object)requestFrame.message).isInstanceOf(Query.class);
        Assertions.assertThat((String)((Query)requestFrame.message).query).isEqualTo("USE \"ks\"");
        this.writeInboundFrame(requestFrame, (Message)new Error(8704, "invalid keyspace"));
        Assertions.assertThat(connectFuture).isFailed(error -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)error).isInstanceOf(InvalidKeyspaceException.class)).hasMessage("invalid keyspace"));
    }

    @Test
    public void should_fail_pending_requests_only_once_if_init_fails() {
        Logger logger = (Logger)LoggerFactory.getLogger((String)"io.netty.channel.AbstractChannelHandlerContext");
        Level levelBefore = logger.getLevel();
        logger.setLevel(Level.WARN);
        logger.addAppender(this.appender);
        this.channel.pipeline().addLast("init", (ChannelHandler)new ProtocolInitHandler(this.internalDriverContext, (ProtocolVersion)DefaultProtocolVersion.V4, null, END_POINT, DriverChannelOptions.DEFAULT, this.heartbeatHandler, false));
        ChannelFuture connectFuture = this.channel.connect((SocketAddress)new InetSocketAddress("localhost", 9042));
        this.channel.pipeline().fireExceptionCaught((Throwable)new IOException("Mock I/O exception"));
        Assertions.assertThat(connectFuture).isFailed();
        ((Appender)Mockito.verify(this.appender, (VerificationMode)Mockito.never())).doAppend((Object)((ILoggingEvent)ArgumentMatchers.any(ILoggingEvent.class)));
        logger.detachAppender(this.appender);
        logger.setLevel(levelBefore);
    }
}

