/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.addresstranslation;

import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.internal.core.addresstranslation.FixedHostNameAddressTranslator;
import com.datastax.oss.driver.internal.core.context.DefaultDriverContext;
import com.datastax.oss.driver.internal.core.context.MockedDriverContextFactory;
import java.net.InetSocketAddress;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;

public class FixedHostNameAddressTranslatorTest {
    @Test
    public void should_translate_address() {
        DriverExecutionProfile defaultProfile = (DriverExecutionProfile)Mockito.mock(DriverExecutionProfile.class);
        Mockito.when((Object)defaultProfile.getString(FixedHostNameAddressTranslator.ADDRESS_TRANSLATOR_ADVERTISED_HOSTNAME_OPTION)).thenReturn((Object)"myaddress");
        DefaultDriverContext defaultDriverContext = MockedDriverContextFactory.defaultDriverContext(Optional.of(defaultProfile));
        FixedHostNameAddressTranslator translator = new FixedHostNameAddressTranslator((DriverContext)defaultDriverContext);
        InetSocketAddress address = new InetSocketAddress("192.0.2.5", 6061);
        Assertions.assertThat((Object)translator.translate(address)).isEqualTo((Object)new InetSocketAddress("myaddress", 6061));
    }
}

