/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core;

import com.datastax.oss.driver.api.core.PagingIterable;
import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.internal.core.cql.ResultSetTestBase;
import com.datastax.oss.driver.internal.core.cql.ResultSets;
import java.util.Iterator;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class PagingIterableWrapperTest
extends ResultSetTestBase {
    @Test
    public void should_wrap_result_set() {
        AsyncResultSet page1 = this.mockPage(true, 0, 1, 2);
        AsyncResultSet page2 = this.mockPage(true, 3, 4, 5);
        AsyncResultSet page3 = this.mockPage(false, 6, 7, 8);
        PagingIterableWrapperTest.complete(page1.fetchNextPage(), page2);
        PagingIterableWrapperTest.complete(page2.fetchNextPage(), page3);
        PagingIterable iterable = ResultSets.newInstance((AsyncResultSet)page1).map(row -> row.getInt(0));
        Assertions.assertThat((Object)iterable.getExecutionInfo()).isSameAs((Object)page1.getExecutionInfo());
        Assertions.assertThat((List)iterable.getExecutionInfos()).containsExactly((Object[])new ExecutionInfo[]{page1.getExecutionInfo()});
        Iterator iterator = iterable.iterator();
        Assertions.assertThat((Integer)((Integer)iterator.next())).isEqualTo(0);
        Assertions.assertThat((Integer)((Integer)iterator.next())).isEqualTo(1);
        Assertions.assertThat((Integer)((Integer)iterator.next())).isEqualTo(2);
        Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
        Assertions.assertThat((Object)iterable.getExecutionInfo()).isEqualTo((Object)page2.getExecutionInfo());
        Assertions.assertThat((List)iterable.getExecutionInfos()).containsExactly((Object[])new ExecutionInfo[]{page1.getExecutionInfo(), page2.getExecutionInfo()});
        Assertions.assertThat((Integer)((Integer)iterator.next())).isEqualTo(3);
        Assertions.assertThat((Integer)((Integer)iterator.next())).isEqualTo(4);
        Assertions.assertThat((Integer)((Integer)iterator.next())).isEqualTo(5);
        Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
        Assertions.assertThat((Object)iterable.getExecutionInfo()).isEqualTo((Object)page3.getExecutionInfo());
        Assertions.assertThat((List)iterable.getExecutionInfos()).containsExactly((Object[])new ExecutionInfo[]{page1.getExecutionInfo(), page2.getExecutionInfo(), page3.getExecutionInfo()});
        Assertions.assertThat((Integer)((Integer)iterator.next())).isEqualTo(6);
        Assertions.assertThat((Integer)((Integer)iterator.next())).isEqualTo(7);
        Assertions.assertThat((Integer)((Integer)iterator.next())).isEqualTo(8);
    }

    @Test
    public void should_share_iteration_progress_with_wrapped_result_set() {
        AsyncResultSet page1 = this.mockPage(true, 0, 1, 2);
        AsyncResultSet page2 = this.mockPage(true, 3, 4, 5);
        AsyncResultSet page3 = this.mockPage(false, 6, 7, 8);
        PagingIterableWrapperTest.complete(page1.fetchNextPage(), page2);
        PagingIterableWrapperTest.complete(page2.fetchNextPage(), page3);
        ResultSet resultSet = ResultSets.newInstance((AsyncResultSet)page1);
        PagingIterable iterable = resultSet.map(row -> row.getInt(0));
        Iterator sourceIterator = resultSet.iterator();
        Iterator mappedIterator = iterable.iterator();
        Assertions.assertThat((Integer)((Integer)mappedIterator.next())).isEqualTo(0);
        this.assertNextRow(sourceIterator, 1);
        Assertions.assertThat((Integer)((Integer)mappedIterator.next())).isEqualTo(2);
        this.assertNextRow(sourceIterator, 3);
        Assertions.assertThat((Integer)((Integer)mappedIterator.next())).isEqualTo(4);
        this.assertNextRow(sourceIterator, 5);
        Assertions.assertThat((Integer)((Integer)mappedIterator.next())).isEqualTo(6);
        this.assertNextRow(sourceIterator, 7);
        Assertions.assertThat((Integer)((Integer)mappedIterator.next())).isEqualTo(8);
    }
}

