/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core;

import com.datastax.oss.driver.api.core.AsyncPagingIterable;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class MockAsyncPagingIterable<ElementT>
implements AsyncPagingIterable<ElementT, MockAsyncPagingIterable<ElementT>> {
    private final Queue<ElementT> currentPage;
    private final MockAsyncPagingIterable<ElementT> nextPage;

    public MockAsyncPagingIterable(List<ElementT> elements, int fetchSize, boolean addEmptyLastPage) {
        if (elements.size() <= fetchSize) {
            this.currentPage = new ArrayDeque<ElementT>(elements);
            this.nextPage = addEmptyLastPage ? new MockAsyncPagingIterable(Collections.emptyList(), fetchSize, false) : null;
        } else {
            this.currentPage = new ArrayDeque<ElementT>(elements.subList(0, fetchSize));
            this.nextPage = new MockAsyncPagingIterable<ElementT>(elements.subList(fetchSize, elements.size()), fetchSize, addEmptyLastPage);
        }
    }

    @NonNull
    public Iterable<ElementT> currentPage() {
        return this.currentPage;
    }

    public int remaining() {
        return this.currentPage.size();
    }

    public boolean hasMorePages() {
        return this.nextPage != null;
    }

    @NonNull
    public CompletionStage<MockAsyncPagingIterable<ElementT>> fetchNextPage() throws IllegalStateException {
        Preconditions.checkState((this.nextPage != null ? 1 : 0) != 0);
        return CompletableFuture.completedFuture(this.nextPage);
    }

    @NonNull
    public ColumnDefinitions getColumnDefinitions() {
        throw new UnsupportedOperationException("irrelevant");
    }

    @NonNull
    public ExecutionInfo getExecutionInfo() {
        throw new UnsupportedOperationException("irrelevant");
    }

    public boolean wasApplied() {
        throw new UnsupportedOperationException("irrelevant");
    }
}

