/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core;

import com.datastax.dse.driver.api.core.DseProtocolVersion;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.UnsupportedProtocolVersionException;
import com.datastax.oss.driver.api.core.Version;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.DefaultProtocolFeature;
import com.datastax.oss.driver.internal.core.DefaultProtocolVersionRegistry;
import com.datastax.oss.driver.internal.core.ProtocolFeature;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Test;
import org.mockito.Mockito;

public class DefaultProtocolVersionRegistryTest {
    private DefaultProtocolVersionRegistry registry = new DefaultProtocolVersionRegistry("test");

    @Test
    public void should_find_version_by_name() {
        Assertions.assertThat((Object)this.registry.fromName("V4")).isEqualTo((Object)ProtocolVersion.V4);
        Assertions.assertThat((Object)this.registry.fromName("DSE_V1")).isEqualTo((Object)DseProtocolVersion.DSE_V1);
    }

    @Test
    public void should_fail_to_find_version_by_name_different_case() {
        Assertions.assertThatThrownBy(() -> this.registry.fromName("v4")).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> this.registry.fromName("dse_v1")).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> this.registry.fromName("dDSE_v1")).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> this.registry.fromName("dse_v1")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void should_downgrade_if_lower_version_available() {
        Optional downgraded = this.registry.downgrade(ProtocolVersion.V4);
        downgraded.map(version -> (ObjectAssert)Assertions.assertThat((Object)version).isEqualTo((Object)ProtocolVersion.V3)).orElseThrow(AssertionError::new);
    }

    @Test
    public void should_not_downgrade_if_no_lower_version() {
        Optional downgraded = this.registry.downgrade(ProtocolVersion.V3);
        Assertions.assertThat((boolean)downgraded.isPresent()).isFalse();
    }

    @Test
    public void should_downgrade_from_dse_to_oss() {
        Assertions.assertThat((Object)((ProtocolVersion)this.registry.downgrade((ProtocolVersion)DseProtocolVersion.DSE_V1).get())).isEqualTo((Object)ProtocolVersion.V5);
    }

    @Test
    public void should_pick_dse_v2_as_highest_common_when_all_nodes_are_dse_7() {
        Assertions.assertThat((Object)this.registry.highestCommon((Collection)ImmutableList.of((Object)this.mockDseNode("7.0"), (Object)this.mockDseNode("7.1")))).isEqualTo((Object)DseProtocolVersion.DSE_V2);
    }

    @Test
    public void should_pick_dse_v2_as_highest_common_when_all_nodes_are_dse_6() {
        Assertions.assertThat((Object)this.registry.highestCommon((Collection)ImmutableList.of((Object)this.mockDseNode("6.0"), (Object)this.mockDseNode("6.1")))).isEqualTo((Object)DseProtocolVersion.DSE_V2);
    }

    @Test
    public void should_pick_dse_v1_as_highest_common_when_all_nodes_are_dse_5_1_or_more() {
        Assertions.assertThat((Object)this.registry.highestCommon((Collection)ImmutableList.of((Object)this.mockDseNode("5.1"), (Object)this.mockDseNode("6.1")))).isEqualTo((Object)DseProtocolVersion.DSE_V1);
    }

    @Test
    public void should_pick_oss_v4_as_highest_common_when_all_nodes_are_dse_5_or_more() {
        Assertions.assertThat((Object)this.registry.highestCommon((Collection)ImmutableList.of((Object)this.mockDseNode("5.0"), (Object)this.mockDseNode("5.1"), (Object)this.mockDseNode("6.1")))).isEqualTo((Object)ProtocolVersion.V4);
    }

    @Test
    public void should_pick_oss_v3_as_highest_common_when_all_nodes_are_dse_4_7_or_more() {
        Assertions.assertThat((Object)this.registry.highestCommon((Collection)ImmutableList.of((Object)this.mockDseNode("4.7"), (Object)this.mockDseNode("5.1"), (Object)this.mockDseNode("6.1")))).isEqualTo((Object)ProtocolVersion.V3);
    }

    @Test(expected=UnsupportedProtocolVersionException.class)
    public void should_fail_to_pick_highest_common_when_one_node_is_dse_4_6() {
        this.registry.highestCommon((Collection)ImmutableList.of((Object)this.mockDseNode("4.6"), (Object)this.mockDseNode("5.1"), (Object)this.mockDseNode("6.1")));
    }

    @Test(expected=UnsupportedProtocolVersionException.class)
    public void should_fail_to_pick_highest_common_when_one_node_is_2_0() {
        this.registry.highestCommon((Collection)ImmutableList.of((Object)this.mockCassandraNode("3.0.0"), (Object)this.mockCassandraNode("2.0.9")));
    }

    @Test
    public void should_pick_oss_v3_as_highest_common_when_one_node_is_cassandra_2_1() {
        Assertions.assertThat((Object)this.registry.highestCommon((Collection)ImmutableList.of((Object)this.mockDseNode("5.1"), (Object)this.mockDseNode("6.1"), (Object)this.mockCassandraNode("2.1")))).isEqualTo((Object)ProtocolVersion.V3);
    }

    @Test
    public void should_support_date_type_on_oss_v4_and_later() {
        Assertions.assertThat((boolean)this.registry.supports(ProtocolVersion.V3, (ProtocolFeature)DefaultProtocolFeature.DATE_TYPE)).isFalse();
        Assertions.assertThat((boolean)this.registry.supports(ProtocolVersion.V4, (ProtocolFeature)DefaultProtocolFeature.DATE_TYPE)).isTrue();
        Assertions.assertThat((boolean)this.registry.supports(ProtocolVersion.V5, (ProtocolFeature)DefaultProtocolFeature.DATE_TYPE)).isTrue();
        Assertions.assertThat((boolean)this.registry.supports(ProtocolVersion.V6, (ProtocolFeature)DefaultProtocolFeature.DATE_TYPE)).isTrue();
        Assertions.assertThat((boolean)this.registry.supports((ProtocolVersion)DseProtocolVersion.DSE_V1, (ProtocolFeature)DefaultProtocolFeature.DATE_TYPE)).isTrue();
        Assertions.assertThat((boolean)this.registry.supports((ProtocolVersion)DseProtocolVersion.DSE_V2, (ProtocolFeature)DefaultProtocolFeature.DATE_TYPE)).isTrue();
    }

    @Test
    public void should_support_smallint_and_tinyint_types_on_oss_v4_and_later() {
        Assertions.assertThat((boolean)this.registry.supports(ProtocolVersion.V3, (ProtocolFeature)DefaultProtocolFeature.SMALLINT_AND_TINYINT_TYPES)).isFalse();
        Assertions.assertThat((boolean)this.registry.supports(ProtocolVersion.V4, (ProtocolFeature)DefaultProtocolFeature.SMALLINT_AND_TINYINT_TYPES)).isTrue();
        Assertions.assertThat((boolean)this.registry.supports(ProtocolVersion.V5, (ProtocolFeature)DefaultProtocolFeature.SMALLINT_AND_TINYINT_TYPES)).isTrue();
        Assertions.assertThat((boolean)this.registry.supports(ProtocolVersion.V6, (ProtocolFeature)DefaultProtocolFeature.SMALLINT_AND_TINYINT_TYPES)).isTrue();
        Assertions.assertThat((boolean)this.registry.supports((ProtocolVersion)DseProtocolVersion.DSE_V1, (ProtocolFeature)DefaultProtocolFeature.SMALLINT_AND_TINYINT_TYPES)).isTrue();
        Assertions.assertThat((boolean)this.registry.supports((ProtocolVersion)DseProtocolVersion.DSE_V2, (ProtocolFeature)DefaultProtocolFeature.SMALLINT_AND_TINYINT_TYPES)).isTrue();
    }

    private Node mockCassandraNode(String rawVersion) {
        Node node = (Node)Mockito.mock(Node.class);
        if (rawVersion != null) {
            Mockito.when((Object)node.getCassandraVersion()).thenReturn((Object)Version.parse((String)rawVersion));
        }
        return node;
    }

    private Node mockDseNode(String rawDseVersion) {
        Node node = (Node)Mockito.mock(Node.class);
        Version dseVersion = Version.parse((String)rawDseVersion);
        Mockito.when((Object)node.getExtras()).thenReturn((Object)ImmutableMap.of((Object)"DSE_VERSION", (Object)dseVersion));
        Version cassandraVersion = dseVersion.compareTo(DefaultProtocolVersionRegistry.DSE_7_0_0) >= 0 ? Version.parse((String)"5.0") : (dseVersion.compareTo(DefaultProtocolVersionRegistry.DSE_6_0_0) >= 0 ? Version.parse((String)"4.0") : (dseVersion.compareTo(DefaultProtocolVersionRegistry.DSE_5_1_0) >= 0 ? Version.parse((String)"3.11") : (dseVersion.compareTo(DefaultProtocolVersionRegistry.DSE_5_0_0) >= 0 ? Version.parse((String)"3.0") : (dseVersion.compareTo(DefaultProtocolVersionRegistry.DSE_4_7_0) >= 0 ? Version.parse((String)"2.1") : Version.parse((String)"2.0")))));
        Mockito.when((Object)node.getCassandraVersion()).thenReturn((Object)cassandraVersion);
        return node;
    }
}

