/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.paging;

import com.datastax.oss.driver.api.core.PagingIterable;
import com.datastax.oss.driver.api.core.paging.OffsetPager;
import com.datastax.oss.driver.internal.core.MockAsyncPagingIterable;
import com.datastax.oss.driver.internal.core.MockPagingIterable;
import com.datastax.oss.driver.shaded.guava.common.base.Splitter;
import java.util.List;
import org.assertj.core.api.Assertions;

public class OffsetPagerTestFixture {
    private static final Splitter SPEC_SPLITTER = Splitter.on((char)'|').trimResults();
    private static final Splitter LIST_SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private final List<String> inputElements;
    private final int requestedPage;
    private final int pageSize;
    private final int expectedPageNumber;
    private final List<String> expectedElements;
    private final boolean expectedIsLast;

    public OffsetPagerTestFixture(String spec) {
        List components = SPEC_SPLITTER.splitToList((CharSequence)spec);
        int size = components.size();
        if (size != 3 && size != 6) {
            Assertions.fail((String)"Invalid fixture spec, expected 3 or 5 components");
        }
        this.inputElements = LIST_SPLITTER.splitToList((CharSequence)components.get(0));
        this.requestedPage = Integer.parseInt((String)components.get(1));
        this.pageSize = Integer.parseInt((String)components.get(2));
        if (size == 3) {
            this.expectedPageNumber = -1;
            this.expectedElements = null;
            this.expectedIsLast = false;
        } else {
            this.expectedPageNumber = Integer.parseInt((String)components.get(3));
            this.expectedElements = LIST_SPLITTER.splitToList((CharSequence)components.get(4));
            this.expectedIsLast = Boolean.parseBoolean((String)components.get(5));
        }
    }

    public PagingIterable<String> getSyncIterable() {
        return new MockPagingIterable<String>(this.inputElements.iterator());
    }

    public MockAsyncPagingIterable<String> getAsyncIterable(int fetchSize) {
        return new MockAsyncPagingIterable<String>(this.inputElements, fetchSize, false);
    }

    public int getRequestedPage() {
        return this.requestedPage;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void assertMatches(OffsetPager.Page<String> actualPage) {
        Assertions.assertThat((int)actualPage.getPageNumber()).isEqualTo(this.expectedPageNumber);
        Assertions.assertThat((List)actualPage.getElements()).isEqualTo(this.expectedElements);
        Assertions.assertThat((boolean)actualPage.isLast()).isEqualTo(this.expectedIsLast);
    }
}

