/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.data;

import com.datastax.oss.driver.api.core.data.CqlVector;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.internal.SerializationHelper;
import com.datastax.oss.driver.shaded.guava.common.collect.Iterators;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Lists;
import org.junit.Test;

public class CqlVectorTest {
    private static final Float[] VECTOR_ARGS = new Float[]{Float.valueOf(1.0f), Float.valueOf(2.5f)};

    private void validate_built_vector(CqlVector<Float> vec) {
        Assertions.assertThat((int)vec.size()).isEqualTo(2);
        Assertions.assertThat((boolean)vec.isEmpty()).isFalse();
        Assertions.assertThat((Float)((Float)vec.get(0))).isEqualTo(VECTOR_ARGS[0]);
        Assertions.assertThat((Float)((Float)vec.get(1))).isEqualTo(VECTOR_ARGS[1]);
    }

    @Test
    public void should_build_vector_from_elements() {
        this.validate_built_vector((CqlVector<Float>)CqlVector.newInstance((Number[])VECTOR_ARGS));
    }

    @Test
    public void should_build_vector_from_list() {
        this.validate_built_vector((CqlVector<Float>)CqlVector.newInstance((List)Lists.newArrayList((Object[])VECTOR_ARGS)));
    }

    @Test
    public void should_build_vector_from_tostring_output() {
        CqlVector vector1 = CqlVector.newInstance((Number[])VECTOR_ARGS);
        CqlVector vector2 = CqlVector.from((String)vector1.toString(), (TypeCodec)TypeCodecs.FLOAT);
        Assertions.assertThat((Iterable)vector2).isEqualTo((Object)vector1);
    }

    @Test
    public void should_throw_from_null_string() {
        Assertions.assertThatThrownBy(() -> CqlVector.from(null, (TypeCodec)TypeCodecs.FLOAT)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void should_throw_from_empty_string() {
        Assertions.assertThatThrownBy(() -> CqlVector.from((String)"", (TypeCodec)TypeCodecs.FLOAT)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void should_throw_when_building_with_nulls() {
        Assertions.assertThatThrownBy(() -> CqlVector.newInstance((Number[])new Float[]{Float.valueOf(1.1f), null, Float.valueOf(2.2f)})).isInstanceOf(IllegalArgumentException.class);
        Float[] theArray = new Float[]{Float.valueOf(1.1f), null, Float.valueOf(2.2f)};
        Assertions.assertThatThrownBy(() -> CqlVector.newInstance((Number[])theArray)).isInstanceOf(IllegalArgumentException.class);
        ArrayList theList = Lists.newArrayList((Object[])new Float[]{Float.valueOf(1.1f), null, Float.valueOf(2.2f)});
        Assertions.assertThatThrownBy(() -> CqlVector.newInstance((List)theList)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void should_build_empty_vector() {
        CqlVector vector = CqlVector.newInstance((Number[])new Float[0]);
        Assertions.assertThat((boolean)vector.isEmpty()).isTrue();
        Assertions.assertThat((int)vector.size()).isEqualTo(0);
    }

    @Test
    public void should_behave_mostly_like_a_list() {
        CqlVector vector = CqlVector.newInstance((Number[])VECTOR_ARGS);
        Assertions.assertThat((Float)((Float)vector.get(0))).isEqualTo(VECTOR_ARGS[0]);
        Float newVal = Float.valueOf(VECTOR_ARGS[0].floatValue() * 2.0f);
        vector.set(0, (Number)newVal);
        Assertions.assertThat((Float)((Float)vector.get(0))).isEqualTo(newVal);
        Assertions.assertThat((boolean)vector.isEmpty()).isFalse();
        Assertions.assertThat((int)vector.size()).isEqualTo(2);
        Assertions.assertThat((Object[])((Float[])Iterators.toArray((Iterator)vector.iterator(), Float.class))).isEqualTo((Object)VECTOR_ARGS);
    }

    @Test
    public void should_play_nicely_with_streams() {
        CqlVector vector = CqlVector.newInstance((Number[])VECTOR_ARGS);
        List results = vector.stream().map(f -> Float.valueOf(f.floatValue() * 2.0f)).collect(Collectors.toCollection(() -> new ArrayList()));
        for (int i = 0; i < vector.size(); ++i) {
            Assertions.assertThat((Float)((Float)results.get(i))).isEqualTo(((Float)vector.get(i)).floatValue() * 2.0f);
        }
    }

    @Test
    public void should_reflect_changes_to_mutable_list() {
        ArrayList theList = Lists.newArrayList((Object[])new Float[]{Float.valueOf(1.1f), Float.valueOf(2.2f), Float.valueOf(3.3f)});
        CqlVector vector = CqlVector.newInstance((List)theList);
        Assertions.assertThat((int)vector.size()).isEqualTo(3);
        Assertions.assertThat((Float)((Float)vector.get(2))).isEqualTo(3.3f);
        float newVal1 = 4.4f;
        theList.set(2, Float.valueOf(newVal1));
        Assertions.assertThat((int)vector.size()).isEqualTo(3);
        Assertions.assertThat((Float)((Float)vector.get(2))).isEqualTo(newVal1);
        float newVal2 = 5.5f;
        theList.add(Float.valueOf(newVal2));
        Assertions.assertThat((int)vector.size()).isEqualTo(4);
        Assertions.assertThat((Float)((Float)vector.get(3))).isEqualTo(newVal2);
    }

    @Test
    public void should_reflect_changes_to_array() {
        Number[] theArray = new Float[]{Float.valueOf(1.1f), Float.valueOf(2.2f), Float.valueOf(3.3f)};
        CqlVector vector = CqlVector.newInstance((Number[])theArray);
        Assertions.assertThat((int)vector.size()).isEqualTo(3);
        Assertions.assertThat((Float)((Float)vector.get(2))).isEqualTo(3.3f);
        float newVal1 = 4.4f;
        theArray[2] = Float.valueOf(newVal1);
        Assertions.assertThat((int)vector.size()).isEqualTo(3);
        Assertions.assertThat((Float)((Float)vector.get(2))).isEqualTo(newVal1);
    }

    @Test
    public void should_correctly_compare_vectors() {
        Object[] args = (Float[])VECTOR_ARGS.clone();
        CqlVector vector1 = CqlVector.newInstance((Number[])args);
        CqlVector vector2 = CqlVector.newInstance((Number[])args);
        CqlVector vector3 = CqlVector.newInstance((List)Lists.newArrayList((Object[])args));
        Assertions.assertThat((Iterable)vector1).isNotSameAs((Object)vector2);
        Assertions.assertThat((Iterable)vector1).isEqualTo((Object)vector2);
        Assertions.assertThat((Iterable)vector1).isNotSameAs((Object)vector3);
        Assertions.assertThat((Iterable)vector1).isEqualTo((Object)vector3);
        Number[] differentArgs = (Float[])args.clone();
        float newVal = differentArgs[0].floatValue() * 2.0f;
        differentArgs[0] = Float.valueOf(newVal);
        CqlVector vector4 = CqlVector.newInstance((Number[])differentArgs);
        Assertions.assertThat((Iterable)vector1).isNotSameAs((Object)vector4);
        Assertions.assertThat((Iterable)vector1).isNotEqualTo((Object)vector4);
        Number[] biggerArgs = (Float[])Arrays.copyOf(args, args.length + 1);
        biggerArgs[biggerArgs.length - 1] = Float.valueOf(newVal);
        CqlVector vector5 = CqlVector.newInstance((Number[])biggerArgs);
        Assertions.assertThat((Iterable)vector1).isNotSameAs((Object)vector5);
        Assertions.assertThat((Iterable)vector1).isNotEqualTo((Object)vector5);
    }

    @Test
    public void should_serialize_and_deserialize() throws Exception {
        CqlVector initial = CqlVector.newInstance((Number[])VECTOR_ARGS);
        CqlVector deserialized = SerializationHelper.serializeAndDeserialize(initial);
        Assertions.assertThat((Iterable)deserialized).isEqualTo((Object)initial);
    }

    @Test
    public void should_serialize_and_deserialize_empty_vector() throws Exception {
        CqlVector initial = CqlVector.newInstance(Collections.emptyList());
        CqlVector deserialized = SerializationHelper.serializeAndDeserialize(initial);
        Assertions.assertThat((Iterable)deserialized).isEqualTo((Object)initial);
    }

    @Test
    public void should_serialize_and_deserialize_unserializable_list() throws Exception {
        CqlVector initial = CqlVector.newInstance((List)new AbstractList<Float>(){

            @Override
            public Float get(int index) {
                return VECTOR_ARGS[index];
            }

            @Override
            public int size() {
                return VECTOR_ARGS.length;
            }
        });
        CqlVector deserialized = SerializationHelper.serializeAndDeserialize(initial);
        Assertions.assertThat((Iterable)deserialized).isEqualTo((Object)initial);
    }

    @Test
    public void should_not_use_preallocate_serialized_size() throws DecoderException {
        byte[] suspiciousBytes = Hex.decodeHex((char[])"aced000573720042636f6d2e64617461737461782e6f73732e6472697665722e6170692e636f72652e646174612e43716c566563746f722453657269616c697a6174696f6e50726f78790000000000000001030000787077047fffffff7372000f6a6176612e6c616e672e466c6f6174daedc9a2db3cf0ec02000146000576616c7565787200106a6176612e6c616e672e4e756d62657286ac951d0b94e08b02000078703f8000007371007e0002402000007371007e00024040000078".toCharArray());
        try {
            new ObjectInputStream(new ByteArrayInputStream(suspiciousBytes)).readObject();
            Assertions.fail((String)"Should not be able to deserialize bytes with incorrect size field");
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).isInstanceOf(ObjectStreamException.class);
        }
    }
}

