/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.cql;

import com.datastax.oss.driver.TestDataProviders;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.BatchType;
import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatementBuilder;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.cql.StatementBuilder;
import com.datastax.oss.driver.internal.core.cql.DefaultBoundStatement;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=DataProviderRunner.class)
public class StatementProfileTest {
    private static final DriverExecutionProfile PROFILE = (DriverExecutionProfile)Mockito.mock(DriverExecutionProfile.class);
    private static final String NAME = "mockProfileName";

    @Test
    @UseDataProvider(value="statements")
    public void should_set_profile_and_name_on_statement(Statement<?> statement, Operation operation1, Operation operation2, String expectedName, DriverExecutionProfile expectedProfile) {
        statement = operation1.applyTo(statement);
        statement = operation2.applyTo(statement);
        Assertions.assertThat((String)statement.getExecutionProfileName()).isEqualTo(expectedName);
        Assertions.assertThat((Object)statement.getExecutionProfile()).isEqualTo((Object)expectedProfile);
    }

    @Test
    @UseDataProvider(value="builders")
    public void should_set_profile_and_name_on_builder(StatementBuilder<?, ?> builder, Operation operation1, Operation operation2, String expectedName, DriverExecutionProfile expectedProfile) {
        builder = operation1.applyTo(builder);
        builder = operation2.applyTo(builder);
        Statement statement = builder.build();
        Assertions.assertThat((String)statement.getExecutionProfileName()).isEqualTo(expectedName);
        Assertions.assertThat((Object)statement.getExecutionProfile()).isEqualTo((Object)expectedProfile);
    }

    private static Object[][] scenarios() {
        return new Object[][]{{StatementProfileTest.setProfile(PROFILE), StatementProfileTest.noop(), null, PROFILE}, {StatementProfileTest.setName(NAME), StatementProfileTest.noop(), NAME, null}, {StatementProfileTest.setProfile(PROFILE), StatementProfileTest.setName(NAME), NAME, null}, {StatementProfileTest.setName(NAME), StatementProfileTest.setProfile(PROFILE), null, PROFILE}, {StatementProfileTest.setProfile(PROFILE), StatementProfileTest.setName(null), null, PROFILE}, {StatementProfileTest.setName(NAME), StatementProfileTest.setProfile(null), NAME, null}};
    }

    @DataProvider
    public static Object[][] statements() {
        SimpleStatement simpleStatement = SimpleStatement.newInstance((String)"mock query");
        Object[][] statements = TestDataProviders.fromList(simpleStatement, StatementProfileTest.newBoundStatement(), BatchStatement.newInstance((BatchType)BatchType.LOGGED, (BatchableStatement[])new BatchableStatement[]{simpleStatement}));
        return TestDataProviders.combine(statements, StatementProfileTest.scenarios());
    }

    @DataProvider
    public static Object[][] builders() {
        SimpleStatement simpleStatement = SimpleStatement.newInstance((String)"mock query");
        Object[][] builders = TestDataProviders.fromList(SimpleStatement.builder((SimpleStatement)simpleStatement), new BoundStatementBuilder(StatementProfileTest.newBoundStatement()), BatchStatement.builder((BatchType)BatchType.LOGGED).addStatement((BatchableStatement)simpleStatement));
        return TestDataProviders.combine(builders, StatementProfileTest.scenarios());
    }

    private static Operation setProfile(final DriverExecutionProfile profile) {
        return new Operation(){

            @Override
            public Statement<?> applyTo(Statement<?> statement) {
                return statement.setExecutionProfile(profile);
            }

            @Override
            public StatementBuilder<?, ?> applyTo(StatementBuilder<?, ?> builder) {
                return builder.setExecutionProfile(profile);
            }
        };
    }

    private static Operation setName(final String name) {
        return new Operation(){

            @Override
            public Statement<?> applyTo(Statement<?> statement) {
                return statement.setExecutionProfileName(name);
            }

            @Override
            public StatementBuilder<?, ?> applyTo(StatementBuilder<?, ?> builder) {
                return builder.setExecutionProfileName(name);
            }
        };
    }

    private static Operation noop() {
        return new Operation(){

            @Override
            public Statement<?> applyTo(Statement<?> statement) {
                return statement;
            }

            @Override
            public StatementBuilder<?, ?> applyTo(StatementBuilder<?, ?> builder) {
                return builder;
            }
        };
    }

    private static BoundStatement newBoundStatement() {
        PreparedStatement preparedStatement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        ColumnDefinitions variableDefinitions = (ColumnDefinitions)Mockito.mock(ColumnDefinitions.class);
        Mockito.when((Object)preparedStatement.getVariableDefinitions()).thenReturn((Object)variableDefinitions);
        return new DefaultBoundStatement(preparedStatement, variableDefinitions, new ByteBuffer[0], null, null, null, null, null, Collections.emptyMap(), null, false, Long.MIN_VALUE, null, 5000, null, null, Duration.ZERO, null, null, null, Integer.MIN_VALUE);
    }

    private static interface Operation {
        public Statement<?> applyTo(Statement<?> var1);

        public StatementBuilder<?, ?> applyTo(StatementBuilder<?, ?> var1);
    }
}

