/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.cql;

import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatementBuilder;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.cql.StatementBuilder;
import com.datastax.oss.driver.shaded.guava.common.base.Charsets;
import java.nio.ByteBuffer;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;

public class StatementBuilderTest {
    @Test
    public void should_handle_set_tracing_without_args() {
        MockSimpleStatementBuilder builder = new MockSimpleStatementBuilder();
        Assertions.assertThat((boolean)builder.build().isTracing()).isFalse();
        builder.setTracing();
        Assertions.assertThat((boolean)builder.build().isTracing()).isTrue();
    }

    @Test
    public void should_handle_set_tracing_with_args() {
        MockSimpleStatementBuilder builder = new MockSimpleStatementBuilder();
        Assertions.assertThat((boolean)builder.build().isTracing()).isFalse();
        builder.setTracing(true);
        Assertions.assertThat((boolean)builder.build().isTracing()).isTrue();
        builder.setTracing(false);
        Assertions.assertThat((boolean)builder.build().isTracing()).isFalse();
    }

    @Test
    public void should_override_set_tracing_in_template() {
        SimpleStatement template = SimpleStatement.builder((String)"select * from system.peers").build();
        MockSimpleStatementBuilder builder = new MockSimpleStatementBuilder(template);
        Assertions.assertThat((boolean)builder.build().isTracing()).isFalse();
        builder.setTracing(true);
        Assertions.assertThat((boolean)builder.build().isTracing()).isTrue();
        template = ((SimpleStatementBuilder)SimpleStatement.builder((String)"select * from system.peers").setTracing()).build();
        builder = new MockSimpleStatementBuilder(template);
        Assertions.assertThat((boolean)builder.build().isTracing()).isTrue();
        builder.setTracing(false);
        Assertions.assertThat((boolean)builder.build().isTracing()).isFalse();
    }

    @Test
    public void should_match_set_routing_key_vararg() {
        ByteBuffer buff1 = ByteBuffer.wrap("the quick brown fox".getBytes(Charsets.UTF_8));
        ByteBuffer buff2 = ByteBuffer.wrap("jumped over the lazy dog".getBytes(Charsets.UTF_8));
        Statement expectedStmt = SimpleStatement.builder((String)"select * from system.peers").build().setRoutingKey(new ByteBuffer[]{buff1, buff2});
        MockSimpleStatementBuilder builder = new MockSimpleStatementBuilder();
        SimpleStatement builderStmt = ((MockSimpleStatementBuilder)builder.setRoutingKey(new ByteBuffer[]{buff1, buff2})).build();
        Assertions.assertThat((Comparable)expectedStmt.getRoutingKey()).isEqualTo((Object)builderStmt.getRoutingKey());
        builderStmt = ((MockSimpleStatementBuilder)builder.setRoutingKey(new ByteBuffer[]{buff2, buff1})).build();
        Assertions.assertThat((Comparable)expectedStmt.getRoutingKey()).isNotEqualTo((Object)builderStmt.getRoutingKey());
    }

    private static class MockSimpleStatementBuilder
    extends StatementBuilder<MockSimpleStatementBuilder, SimpleStatement> {
        public MockSimpleStatementBuilder() {
        }

        public MockSimpleStatementBuilder(SimpleStatement template) {
            super((Statement)template);
        }

        public SimpleStatement build() {
            SimpleStatement rv = (SimpleStatement)Mockito.mock(SimpleStatement.class);
            Mockito.when((Object)rv.isTracing()).thenReturn((Object)this.tracing);
            Mockito.when((Object)rv.getRoutingKey()).thenReturn((Object)this.routingKey);
            return rv;
        }
    }
}

