/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.Version;
import org.junit.Test;

public class VersionTest {
    @Test
    public void should_parse_release_version() {
        Assertions.assertThat(Version.parse((String)"1.2.19")).hasMajorMinorPatch(1, 2, 19).hasDsePatch(-1).hasNoPreReleaseLabels().hasBuildLabel(null).hasNextStable("1.2.19").hasToString("1.2.19");
    }

    @Test
    public void should_parse_release_without_patch() {
        Assertions.assertThat(Version.parse((String)"1.2")).hasMajorMinorPatch(1, 2, 0);
    }

    @Test
    public void should_parse_pre_release_version() {
        Assertions.assertThat(Version.parse((String)"1.2.0-beta1-SNAPSHOT")).hasMajorMinorPatch(1, 2, 0).hasDsePatch(-1).hasPreReleaseLabels("beta1", "SNAPSHOT").hasBuildLabel(null).hasToString("1.2.0-beta1-SNAPSHOT").hasNextStable("1.2.0");
    }

    @Test
    public void should_allow_tilde_as_first_pre_release_delimiter() {
        Assertions.assertThat(Version.parse((String)"1.2.0~beta1-SNAPSHOT")).hasMajorMinorPatch(1, 2, 0).hasDsePatch(-1).hasPreReleaseLabels("beta1", "SNAPSHOT").hasBuildLabel(null).hasToString("1.2.0-beta1-SNAPSHOT").hasNextStable("1.2.0");
    }

    @Test
    public void should_parse_dse_patch() {
        Assertions.assertThat(Version.parse((String)"1.2.19.2-SNAPSHOT")).hasMajorMinorPatch(1, 2, 19).hasDsePatch(2).hasToString("1.2.19.2-SNAPSHOT").hasNextStable("1.2.19.2");
    }

    @Test
    public void should_order_versions() {
        this.assertOrder("1.2.0", "2.0.0", -1);
        this.assertOrder("2.0.0", "2.1.0", -1);
        this.assertOrder("2.0.1", "2.0.2", -1);
        this.assertOrder("2.0.1.1", "2.0.1.2", -1);
        this.assertOrder("2.0", "2.0.0", 0);
        this.assertOrder("2.0", "2.0.1", -1);
        this.assertOrder("2.0.0", "2.0.0.0", -1);
        this.assertOrder("2.0.0", "2.0.0.1", -1);
        this.assertOrder("2.0.0-beta1", "2.0.0", -1);
        this.assertOrder("2.0.0-SNAPSHOT", "2.0.0", -1);
        this.assertOrder("2.0.0-beta1-SNAPSHOT", "2.0.0", -1);
        this.assertOrder("2.0.0-a-b-c", "2.0.0-a-b-d", -1);
        this.assertOrder("2.0.0-a-b-c", "2.0.0-a-b-c-d", -1);
        this.assertOrder("2.0.0+build01", "2.0.0+build02", 0);
    }

    private void assertOrder(String version1, String version2, int expected) {
        Assertions.assertThat((int)Version.parse((String)version1).compareTo(Version.parse((String)version2))).isEqualTo(expected);
    }
}

