/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver;

import com.tngtech.java.junit.dataprovider.DataProvider;
import java.util.Arrays;
import java.util.Locale;

public class TestDataProviders {
    public static Object[][] fromList(Object ... l) {
        Object[][] result = new Object[l.length][];
        for (int i = 0; i < l.length; ++i) {
            result[i] = new Object[1];
            result[i][0] = l[i];
        }
        return result;
    }

    public static Object[][] concat(Object[][] left, Object[][] right) {
        Object[][] result = (Object[][])Arrays.copyOf(left, left.length + right.length);
        System.arraycopy(right, 0, result, left.length, right.length);
        return result;
    }

    public static Object[][] combine(Object[][] ... providers) {
        int numberOfProviders = providers.length;
        int numberOfCombinations = 1;
        for (Object[][] provider : providers) {
            numberOfCombinations *= provider.length;
        }
        Object[][] result = new Object[numberOfCombinations][];
        int[] indices = new int[numberOfProviders];
        block1: for (int c = 0; c < numberOfCombinations; ++c) {
            int p;
            int combinationLength = 0;
            for (int p2 = 0; p2 < numberOfProviders; ++p2) {
                combinationLength += providers[p2][indices[p2]].length;
            }
            Object[] combination = new Object[combinationLength];
            int destPos = 0;
            for (p = 0; p < numberOfProviders; ++p) {
                Object[] src = providers[p][indices[p]];
                System.arraycopy(src, 0, combination, destPos, src.length);
                destPos += src.length;
            }
            result[c] = combination;
            for (p = providers.length - 1; p >= 0; --p) {
                if (indices[p] < providers[p].length - 1) {
                    int n = p;
                    indices[n] = indices[n] + 1;
                    continue block1;
                }
                indices[p] = 0;
            }
        }
        return result;
    }

    @DataProvider
    public static Object[][] booleans() {
        return TestDataProviders.fromList(true, false);
    }

    @DataProvider
    public static Object[][] locales() {
        return new Object[][]{{Locale.US}, {Locale.CHINA}, {Locale.JAPAN}, {Locale.KOREA}, {new Locale("gr")}, {new Locale("ar")}, {new Locale("vi")}, {new Locale("tr")}};
    }
}

