/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.insights;

import com.datastax.dse.driver.api.core.config.DseDriverOption;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import java.time.Duration;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class ExecutionProfileMockUtil {
    static final String DEFAULT_LOCAL_DC = "local-dc";
    static final int SPECEX_MAX_DEFAULT = 100;
    static final int SPECEX_DELAY_DEFAULT = 20;

    ExecutionProfileMockUtil() {
    }

    static DriverExecutionProfile mockDefaultExecutionProfile() {
        DriverExecutionProfile profile = (DriverExecutionProfile)Mockito.mock(DriverExecutionProfile.class);
        Mockito.when((Object)profile.getDuration((DriverOption)DefaultDriverOption.REQUEST_TIMEOUT)).thenReturn((Object)Duration.ofMillis(100L));
        Mockito.when((Object)profile.getString((DriverOption)DefaultDriverOption.LOAD_BALANCING_POLICY_CLASS)).thenReturn((Object)"LoadBalancingPolicyImpl");
        Mockito.when((Object)profile.isDefined((DriverOption)DefaultDriverOption.LOAD_BALANCING_DISTANCE_EVALUATOR_CLASS)).thenReturn((Object)true);
        Mockito.when((Object)profile.isDefined((DriverOption)DefaultDriverOption.LOAD_BALANCING_LOCAL_DATACENTER)).thenReturn((Object)true);
        Mockito.when((Object)profile.getString((DriverOption)DefaultDriverOption.LOAD_BALANCING_LOCAL_DATACENTER)).thenReturn((Object)DEFAULT_LOCAL_DC);
        Mockito.when((Object)profile.isDefined((DriverOption)DefaultDriverOption.SPECULATIVE_EXECUTION_MAX)).thenReturn((Object)true);
        Mockito.when((Object)profile.getInt((DriverOption)DefaultDriverOption.SPECULATIVE_EXECUTION_MAX)).thenReturn((Object)100);
        Mockito.when((Object)profile.isDefined((DriverOption)DefaultDriverOption.SPECULATIVE_EXECUTION_DELAY)).thenReturn((Object)true);
        Mockito.when((Object)profile.getInt((DriverOption)DefaultDriverOption.SPECULATIVE_EXECUTION_DELAY)).thenReturn((Object)20);
        Mockito.when((Object)profile.getString((DriverOption)DefaultDriverOption.SPECULATIVE_EXECUTION_POLICY_CLASS)).thenReturn((Object)"SpeculativeExecutionImpl");
        Mockito.when((Object)profile.getString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY)).thenReturn((Object)"LOCAL_ONE");
        Mockito.when((Object)profile.getString((DriverOption)DefaultDriverOption.REQUEST_SERIAL_CONSISTENCY)).thenReturn((Object)"SERIAL");
        Mockito.when((Object)profile.getInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE)).thenReturn((Object)2);
        Mockito.when((Object)profile.getInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_REMOTE_SIZE)).thenReturn((Object)1);
        Mockito.when((Object)profile.getString((DriverOption)ArgumentMatchers.eq((Object)DefaultDriverOption.PROTOCOL_COMPRESSION), (String)ArgumentMatchers.any())).thenReturn((Object)"none");
        Mockito.when((Object)profile.getDuration((DriverOption)DefaultDriverOption.HEARTBEAT_INTERVAL)).thenReturn((Object)Duration.ofMillis(100L));
        Mockito.when((Object)profile.getDuration((DriverOption)DefaultDriverOption.RECONNECTION_BASE_DELAY)).thenReturn((Object)Duration.ofMillis(100L));
        Mockito.when((Object)profile.isDefined((DriverOption)DefaultDriverOption.SSL_ENGINE_FACTORY_CLASS)).thenReturn((Object)true);
        Mockito.when((Object)profile.getString((DriverOption)ArgumentMatchers.eq((Object)DefaultDriverOption.AUTH_PROVIDER_CLASS), (String)ArgumentMatchers.any())).thenReturn((Object)"AuthProviderImpl");
        Mockito.when((Object)profile.getString((DriverOption)DseDriverOption.GRAPH_TRAVERSAL_SOURCE, null)).thenReturn((Object)"src-graph");
        return profile;
    }

    static DriverExecutionProfile mockNonDefaultRequestTimeoutExecutionProfile() {
        DriverExecutionProfile profile = ExecutionProfileMockUtil.mockDefaultExecutionProfile();
        Mockito.when((Object)profile.getDuration((DriverOption)DefaultDriverOption.REQUEST_TIMEOUT)).thenReturn((Object)Duration.ofMillis(50L));
        return profile;
    }

    static DriverExecutionProfile mockNonDefaultLoadBalancingExecutionProfile() {
        DriverExecutionProfile profile = ExecutionProfileMockUtil.mockDefaultExecutionProfile();
        Mockito.when((Object)profile.getString((DriverOption)DefaultDriverOption.LOAD_BALANCING_POLICY_CLASS)).thenReturn((Object)"NonDefaultLoadBalancing");
        return profile;
    }

    static DriverExecutionProfile mockUndefinedLocalDcExecutionProfile() {
        DriverExecutionProfile profile = ExecutionProfileMockUtil.mockNonDefaultLoadBalancingExecutionProfile();
        Mockito.when((Object)profile.isDefined((DriverOption)DefaultDriverOption.LOAD_BALANCING_LOCAL_DATACENTER)).thenReturn((Object)false);
        return profile;
    }

    static DriverExecutionProfile mockNonDefaultSpeculativeExecutionInfo() {
        DriverExecutionProfile profile = ExecutionProfileMockUtil.mockDefaultExecutionProfile();
        Mockito.when((Object)profile.getString((DriverOption)DefaultDriverOption.SPECULATIVE_EXECUTION_POLICY_CLASS)).thenReturn((Object)"NonDefaultSpecexPolicy");
        return profile;
    }

    static DriverExecutionProfile mockNonDefaultConsistency() {
        DriverExecutionProfile profile = ExecutionProfileMockUtil.mockDefaultExecutionProfile();
        Mockito.when((Object)profile.getString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY)).thenReturn((Object)"ALL");
        return profile;
    }

    static DriverExecutionProfile mockNonDefaultSerialConsistency() {
        DriverExecutionProfile profile = ExecutionProfileMockUtil.mockDefaultExecutionProfile();
        Mockito.when((Object)profile.getString((DriverOption)DefaultDriverOption.REQUEST_SERIAL_CONSISTENCY)).thenReturn((Object)"ONE");
        return profile;
    }

    static DriverExecutionProfile mockNonDefaultGraphOptions() {
        DriverExecutionProfile profile = ExecutionProfileMockUtil.mockDefaultExecutionProfile();
        Mockito.when((Object)profile.getString((DriverOption)DseDriverOption.GRAPH_TRAVERSAL_SOURCE, null)).thenReturn((Object)"non-default-graph");
        return profile;
    }
}

