/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.insights;

import com.datastax.dse.driver.internal.core.insights.ConfigAntiPatternsFinder;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import java.util.Collections;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=DataProviderRunner.class)
public class ConfigAntiPatternsFinderTest {
    private static final ImmutableMap<String, String> SSL_ANTI_PATTERN = ImmutableMap.of((Object)"sslWithoutCertValidation", (Object)"Client-to-node encryption is enabled but server certificate validation is disabled");

    @Test
    @UseDataProvider(value="sslConfigProvider")
    public void should_find_ssl_anti_pattern(boolean sslEngineFactoryClassDefined, boolean hostnameValidation, Map<String, String> expected) {
        InternalDriverContext context = this.mockDefaultProfile(sslEngineFactoryClassDefined, hostnameValidation);
        Map antiPatterns = new ConfigAntiPatternsFinder().findAntiPatterns(context);
        Assertions.assertThat((Map)antiPatterns).isEqualTo(expected);
    }

    private InternalDriverContext mockDefaultProfile(boolean sslEngineFactoryClassDefined, boolean hostnameValidation) {
        InternalDriverContext context = (InternalDriverContext)Mockito.mock(InternalDriverContext.class);
        DriverConfig driverConfig = (DriverConfig)Mockito.mock(DriverConfig.class);
        Mockito.when((Object)context.getConfig()).thenReturn((Object)driverConfig);
        DriverExecutionProfile profile = (DriverExecutionProfile)Mockito.mock(DriverExecutionProfile.class);
        Mockito.when((Object)profile.isDefined((DriverOption)DefaultDriverOption.SSL_ENGINE_FACTORY_CLASS)).thenReturn((Object)sslEngineFactoryClassDefined);
        Mockito.when((Object)profile.getBoolean((DriverOption)DefaultDriverOption.SSL_HOSTNAME_VALIDATION, false)).thenReturn((Object)hostnameValidation);
        Mockito.when((Object)driverConfig.getDefaultProfile()).thenReturn((Object)profile);
        return context;
    }

    @DataProvider
    public static Object[][] sslConfigProvider() {
        return new Object[][]{{true, true, Collections.emptyMap()}, {true, false, SSL_ANTI_PATTERN}, {false, false, Collections.emptyMap()}, {false, true, Collections.emptyMap()}};
    }
}

