/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph.schema.refresh;

import com.datastax.dse.driver.api.core.metadata.schema.DseEdgeMetadata;
import com.datastax.dse.driver.api.core.metadata.schema.DseGraphTableMetadata;
import com.datastax.dse.driver.api.core.metadata.schema.DseVertexMetadata;
import com.datastax.dse.driver.internal.core.metadata.schema.DefaultDseEdgeMetadata;
import com.datastax.dse.driver.internal.core.metadata.schema.DefaultDseKeyspaceMetadata;
import com.datastax.dse.driver.internal.core.metadata.schema.DefaultDseTableMetadata;
import com.datastax.dse.driver.internal.core.metadata.schema.DefaultDseVertexMetadata;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.internal.core.channel.ChannelFactory;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.DefaultMetadata;
import com.datastax.oss.driver.internal.core.metadata.MetadataRefresh;
import com.datastax.oss.driver.internal.core.metadata.schema.DefaultColumnMetadata;
import com.datastax.oss.driver.internal.core.metadata.schema.events.KeyspaceChangeEvent;
import com.datastax.oss.driver.internal.core.metadata.schema.events.TableChangeEvent;
import com.datastax.oss.driver.internal.core.metadata.schema.refresh.SchemaRefresh;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class GraphSchemaRefreshTest {
    private static final DefaultDseTableMetadata OLD_TABLE = GraphSchemaRefreshTest.newTable(CqlIdentifier.fromInternal((String)"ks_with_engine"), CqlIdentifier.fromInternal((String)"tbl"), null, null);
    private static final DefaultDseKeyspaceMetadata OLD_KS1 = GraphSchemaRefreshTest.newKeyspace("ks1", null);
    private static final DefaultDseKeyspaceMetadata KS_WITH_ENGINE = GraphSchemaRefreshTest.newKeyspace(CqlIdentifier.fromInternal((String)"ks_with_engine"), "Core", (Map<CqlIdentifier, TableMetadata>)ImmutableMap.of((Object)CqlIdentifier.fromInternal((String)"tbl"), (Object)OLD_TABLE));
    @Mock
    private InternalDriverContext context;
    @Mock
    private ChannelFactory channelFactory;
    private DefaultMetadata oldMetadata;

    @Before
    public void setup() {
        Mockito.when((Object)this.context.getChannelFactory()).thenReturn((Object)this.channelFactory);
        this.oldMetadata = DefaultMetadata.EMPTY.withSchema((Map)ImmutableMap.of((Object)OLD_KS1.getName(), (Object)OLD_KS1, (Object)KS_WITH_ENGINE.getName(), (Object)KS_WITH_ENGINE), false, this.context);
    }

    @Test
    public void should_detect_created_keyspace_without_graph_engine() {
        DefaultDseKeyspaceMetadata ks2 = GraphSchemaRefreshTest.newKeyspace("ks2", null);
        SchemaRefresh refresh = new SchemaRefresh((Map)ImmutableMap.of((Object)OLD_KS1.getName(), (Object)OLD_KS1, (Object)KS_WITH_ENGINE.getName(), (Object)KS_WITH_ENGINE, (Object)ks2.getName(), (Object)ks2));
        MetadataRefresh.Result result = refresh.compute(this.oldMetadata, false, this.context);
        Assertions.assertThat((Map)result.newMetadata.getKeyspaces()).hasSize(3);
        Assertions.assertThat((List)result.events).containsExactly(new Object[]{KeyspaceChangeEvent.created((KeyspaceMetadata)ks2)});
    }

    @Test
    public void should_detect_created_keyspace_with_graph_engine() {
        DefaultDseKeyspaceMetadata ks2 = GraphSchemaRefreshTest.newKeyspace("ks2", "Core");
        SchemaRefresh refresh = new SchemaRefresh((Map)ImmutableMap.of((Object)OLD_KS1.getName(), (Object)OLD_KS1, (Object)KS_WITH_ENGINE.getName(), (Object)KS_WITH_ENGINE, (Object)ks2.getName(), (Object)ks2));
        MetadataRefresh.Result result = refresh.compute(this.oldMetadata, false, this.context);
        Assertions.assertThat((Map)result.newMetadata.getKeyspaces()).hasSize(3);
        Assertions.assertThat((List)result.events).containsExactly(new Object[]{KeyspaceChangeEvent.created((KeyspaceMetadata)ks2)});
    }

    @Test
    public void should_detect_top_level_graph_engine_update_in_keyspace() {
        DefaultDseKeyspaceMetadata newKs1 = GraphSchemaRefreshTest.newKeyspace("ks1", "Core");
        SchemaRefresh refresh = new SchemaRefresh((Map)ImmutableMap.of((Object)KS_WITH_ENGINE.getName(), (Object)KS_WITH_ENGINE, (Object)OLD_KS1.getName(), (Object)newKs1));
        MetadataRefresh.Result result = refresh.compute(this.oldMetadata, false, this.context);
        Assertions.assertThat((Map)result.newMetadata.getKeyspaces()).hasSize(2);
        Assertions.assertThat((List)result.events).containsExactly(new Object[]{KeyspaceChangeEvent.updated((KeyspaceMetadata)OLD_KS1, (KeyspaceMetadata)newKs1)});
    }

    @Test
    public void should_detect_adding_and_renaming_and_removing_vertex_label() {
        DefaultDseTableMetadata newTable = GraphSchemaRefreshTest.newTable(KS_WITH_ENGINE.getName(), CqlIdentifier.fromInternal((String)"tbl"), (DseVertexMetadata)new DefaultDseVertexMetadata(CqlIdentifier.fromInternal((String)"someLabel")), null);
        DefaultDseKeyspaceMetadata ks = GraphSchemaRefreshTest.newKeyspace(KS_WITH_ENGINE.getName(), "Core", (Map<CqlIdentifier, TableMetadata>)ImmutableMap.of((Object)CqlIdentifier.fromInternal((String)"tbl"), (Object)newTable));
        SchemaRefresh refresh = new SchemaRefresh((Map)ImmutableMap.of((Object)KS_WITH_ENGINE.getName(), (Object)ks, (Object)OLD_KS1.getName(), (Object)OLD_KS1));
        MetadataRefresh.Result result = refresh.compute(this.oldMetadata, false, this.context);
        Assertions.assertThat((Map)result.newMetadata.getKeyspaces()).hasSize(2);
        Assertions.assertThat((List)result.events).containsExactly(new Object[]{TableChangeEvent.updated((TableMetadata)OLD_TABLE, (TableMetadata)newTable)});
        Assertions.assertThat((Object)((KeyspaceMetadata)result.newMetadata.getKeyspaces().get(KS_WITH_ENGINE.getName()))).isNotNull();
        Assertions.assertThat((Optional)((DseGraphTableMetadata)((KeyspaceMetadata)result.newMetadata.getKeyspaces().get(KS_WITH_ENGINE.getName())).getTable("tbl").get()).getVertex()).isNotNull();
        Assertions.assertThat((String)((DseVertexMetadata)((DseGraphTableMetadata)((KeyspaceMetadata)result.newMetadata.getKeyspaces().get(KS_WITH_ENGINE.getName())).getTable("tbl").get()).getVertex().get()).getLabelName().asInternal()).isEqualTo("someLabel");
        newTable = GraphSchemaRefreshTest.newTable(KS_WITH_ENGINE.getName(), CqlIdentifier.fromInternal((String)"tbl"), (DseVertexMetadata)new DefaultDseVertexMetadata(CqlIdentifier.fromInternal((String)"someNewLabel")), null);
        ks = GraphSchemaRefreshTest.newKeyspace(KS_WITH_ENGINE.getName(), "Core", (Map<CqlIdentifier, TableMetadata>)ImmutableMap.of((Object)CqlIdentifier.fromInternal((String)"tbl"), (Object)newTable));
        refresh = new SchemaRefresh((Map)ImmutableMap.of((Object)KS_WITH_ENGINE.getName(), (Object)ks, (Object)OLD_KS1.getName(), (Object)OLD_KS1));
        result = refresh.compute(this.oldMetadata, false, this.context);
        Assertions.assertThat((Map)result.newMetadata.getKeyspaces()).hasSize(2);
        Assertions.assertThat((List)result.events).containsExactly(new Object[]{TableChangeEvent.updated((TableMetadata)OLD_TABLE, (TableMetadata)newTable)});
        Assertions.assertThat((String)((DseVertexMetadata)((DseGraphTableMetadata)((KeyspaceMetadata)result.newMetadata.getKeyspaces().get(KS_WITH_ENGINE.getName())).getTable("tbl").get()).getVertex().get()).getLabelName().asInternal()).isEqualTo("someNewLabel");
        DefaultMetadata metadataWithVertexLabel = result.newMetadata;
        DefaultDseTableMetadata tableWithRemovedLabel = GraphSchemaRefreshTest.newTable(KS_WITH_ENGINE.getName(), CqlIdentifier.fromInternal((String)"tbl"), null, null);
        ks = GraphSchemaRefreshTest.newKeyspace(KS_WITH_ENGINE.getName(), "Core", (Map<CqlIdentifier, TableMetadata>)ImmutableMap.of((Object)CqlIdentifier.fromInternal((String)"tbl"), (Object)tableWithRemovedLabel));
        refresh = new SchemaRefresh((Map)ImmutableMap.of((Object)KS_WITH_ENGINE.getName(), (Object)ks, (Object)OLD_KS1.getName(), (Object)OLD_KS1));
        result = refresh.compute(metadataWithVertexLabel, false, this.context);
        Assertions.assertThat((Map)result.newMetadata.getKeyspaces()).hasSize(2);
        Assertions.assertThat((List)result.events).containsExactly(new Object[]{TableChangeEvent.updated((TableMetadata)newTable, (TableMetadata)tableWithRemovedLabel)});
        Assertions.assertThat((boolean)((DseGraphTableMetadata)((KeyspaceMetadata)result.newMetadata.getKeyspaces().get(KS_WITH_ENGINE.getName())).getTable("tbl").get()).getVertex().isPresent()).isFalse();
    }

    @Test
    public void should_detect_adding_and_renaming_and_removing_edge_label() {
        DefaultDseTableMetadata newTable = GraphSchemaRefreshTest.newTable(KS_WITH_ENGINE.getName(), CqlIdentifier.fromInternal((String)"tbl"), null, (DseEdgeMetadata)GraphSchemaRefreshTest.newEdgeMetadata(CqlIdentifier.fromInternal((String)"created"), CqlIdentifier.fromInternal((String)"person"), CqlIdentifier.fromInternal((String)"software")));
        DefaultDseKeyspaceMetadata ks = GraphSchemaRefreshTest.newKeyspace(KS_WITH_ENGINE.getName(), "Core", (Map<CqlIdentifier, TableMetadata>)ImmutableMap.of((Object)CqlIdentifier.fromInternal((String)"tbl"), (Object)newTable));
        SchemaRefresh refresh = new SchemaRefresh((Map)ImmutableMap.of((Object)KS_WITH_ENGINE.getName(), (Object)ks, (Object)OLD_KS1.getName(), (Object)OLD_KS1));
        MetadataRefresh.Result result = refresh.compute(this.oldMetadata, false, this.context);
        Assertions.assertThat((Map)result.newMetadata.getKeyspaces()).hasSize(2);
        Assertions.assertThat((List)result.events).containsExactly(new Object[]{TableChangeEvent.updated((TableMetadata)OLD_TABLE, (TableMetadata)newTable)});
        Assertions.assertThat((Object)((KeyspaceMetadata)result.newMetadata.getKeyspaces().get(KS_WITH_ENGINE.getName()))).isNotNull();
        Assertions.assertThat((Optional)((DseGraphTableMetadata)((KeyspaceMetadata)result.newMetadata.getKeyspaces().get(KS_WITH_ENGINE.getName())).getTable("tbl").get()).getVertex()).isNotNull();
        Assertions.assertThat((String)((DseEdgeMetadata)((DseGraphTableMetadata)((KeyspaceMetadata)result.newMetadata.getKeyspaces().get(KS_WITH_ENGINE.getName())).getTable("tbl").get()).getEdge().get()).getLabelName().asInternal()).isEqualTo("created");
        newTable = GraphSchemaRefreshTest.newTable(KS_WITH_ENGINE.getName(), CqlIdentifier.fromInternal((String)"tbl"), null, (DseEdgeMetadata)GraphSchemaRefreshTest.newEdgeMetadata(CqlIdentifier.fromInternal((String)"CHANGED"), CqlIdentifier.fromInternal((String)"person"), CqlIdentifier.fromInternal((String)"software")));
        ks = GraphSchemaRefreshTest.newKeyspace(KS_WITH_ENGINE.getName(), "Core", (Map<CqlIdentifier, TableMetadata>)ImmutableMap.of((Object)CqlIdentifier.fromInternal((String)"tbl"), (Object)newTable));
        refresh = new SchemaRefresh((Map)ImmutableMap.of((Object)KS_WITH_ENGINE.getName(), (Object)ks, (Object)OLD_KS1.getName(), (Object)OLD_KS1));
        result = refresh.compute(this.oldMetadata, false, this.context);
        Assertions.assertThat((Map)result.newMetadata.getKeyspaces()).hasSize(2);
        Assertions.assertThat((List)result.events).containsExactly(new Object[]{TableChangeEvent.updated((TableMetadata)OLD_TABLE, (TableMetadata)newTable)});
        Assertions.assertThat((String)((DseEdgeMetadata)((DseGraphTableMetadata)((KeyspaceMetadata)result.newMetadata.getKeyspaces().get(KS_WITH_ENGINE.getName())).getTable("tbl").get()).getEdge().get()).getLabelName().asInternal()).isEqualTo("CHANGED");
        DefaultMetadata metadataWithEdgeLabel = result.newMetadata;
        DefaultDseTableMetadata tableWithRemovedLabel = GraphSchemaRefreshTest.newTable(KS_WITH_ENGINE.getName(), CqlIdentifier.fromInternal((String)"tbl"), null, null);
        ks = GraphSchemaRefreshTest.newKeyspace(KS_WITH_ENGINE.getName(), "Core", (Map<CqlIdentifier, TableMetadata>)ImmutableMap.of((Object)CqlIdentifier.fromInternal((String)"tbl"), (Object)tableWithRemovedLabel));
        refresh = new SchemaRefresh((Map)ImmutableMap.of((Object)KS_WITH_ENGINE.getName(), (Object)ks, (Object)OLD_KS1.getName(), (Object)OLD_KS1));
        result = refresh.compute(metadataWithEdgeLabel, false, this.context);
        Assertions.assertThat((Map)result.newMetadata.getKeyspaces()).hasSize(2);
        Assertions.assertThat((List)result.events).containsExactly(new Object[]{TableChangeEvent.updated((TableMetadata)newTable, (TableMetadata)tableWithRemovedLabel)});
        Assertions.assertThat((boolean)((DseGraphTableMetadata)((KeyspaceMetadata)result.newMetadata.getKeyspaces().get(KS_WITH_ENGINE.getName())).getTable("tbl").get()).getEdge().isPresent()).isFalse();
    }

    private static DefaultDseKeyspaceMetadata newKeyspace(String name, String graphEngine) {
        return new DefaultDseKeyspaceMetadata(CqlIdentifier.fromInternal((String)name), false, false, graphEngine, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
    }

    private static DefaultDseKeyspaceMetadata newKeyspace(CqlIdentifier name, String graphEngine, @NonNull Map<CqlIdentifier, TableMetadata> tables) {
        return new DefaultDseKeyspaceMetadata(name, false, false, graphEngine, Collections.emptyMap(), Collections.emptyMap(), tables, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
    }

    private static DefaultDseTableMetadata newTable(@NonNull CqlIdentifier keyspace, @NonNull CqlIdentifier name, @Nullable DseVertexMetadata vertex, @Nullable DseEdgeMetadata edge) {
        ImmutableList cols = ImmutableList.of((Object)new DefaultColumnMetadata(keyspace, CqlIdentifier.fromInternal((String)"parent"), CqlIdentifier.fromInternal((String)"id"), DataTypes.INT, false));
        return new DefaultDseTableMetadata(keyspace, name, null, false, false, (List)cols, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), vertex, edge);
    }

    private static DefaultDseEdgeMetadata newEdgeMetadata(@NonNull CqlIdentifier labelName, @NonNull CqlIdentifier fromTable, @NonNull CqlIdentifier toTable) {
        return new DefaultDseEdgeMetadata(labelName, fromTable, fromTable, Collections.emptyList(), Collections.emptyList(), toTable, toTable, Collections.emptyList(), Collections.emptyList());
    }
}

