/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

import com.datastax.dse.driver.api.core.DseProtocolVersion;
import com.datastax.dse.driver.internal.core.graph.GraphProtocol;
import com.datastax.dse.driver.internal.core.graph.GraphSONUtils;
import com.datastax.dse.driver.internal.core.graph.binary.GraphBinaryModule;
import com.datastax.dse.protocol.internal.response.result.DseRowsMetadata;
import com.datastax.oss.driver.internal.core.context.DefaultDriverContext;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.protocol.internal.Frame;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.response.result.ColumnSpec;
import com.datastax.oss.protocol.internal.response.result.DefaultRows;
import com.datastax.oss.protocol.internal.response.result.RawType;
import com.datastax.oss.protocol.internal.response.result.Rows;
import com.datastax.oss.protocol.internal.response.result.RowsMetadata;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.process.remote.traversal.DefaultRemoteTraverser;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.TypeSerializerRegistry;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertex;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertexProperty;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.MapAssert;

public class GraphTestUtils {
    public static ByteBuffer serialize(Object value, GraphProtocol graphProtocol, GraphBinaryModule graphBinaryModule) throws IOException {
        Buffer tinkerBuf = graphBinaryModule.serialize(value);
        ByteBuffer nioBuffer = tinkerBuf.nioBuffer();
        tinkerBuf.release();
        return graphProtocol.isGraphBinary() ? nioBuffer : GraphSONUtils.serializeToByteBuffer((Object)value, (GraphProtocol)graphProtocol);
    }

    public static Frame defaultDseFrameOf(Message responseMessage) {
        return Frame.forResponse((int)DseProtocolVersion.DSE_V2.getCode(), (int)0, null, (Map)Frame.NO_PAYLOAD, Collections.emptyList(), (Message)responseMessage);
    }

    public static Message singleGraphRow(GraphProtocol graphProtocol, GraphBinaryModule module) throws IOException {
        DetachedVertex value = DetachedVertex.build().setId((Object)1).setLabel("person").addProperty(DetachedVertexProperty.build().setId((Object)11).setLabel("name").setValue((Object)"marko").create()).create();
        DseRowsMetadata metadata = new DseRowsMetadata((List)ImmutableList.of((Object)new ColumnSpec("ks", "table", "gremlin", 0, graphProtocol.isGraphBinary() ? (RawType)RawType.PRIMITIVES.get(3) : (RawType)RawType.PRIMITIVES.get(13))), null, new int[0], null, 1, true);
        ArrayDeque<ImmutableList> data = new ArrayDeque<ImmutableList>();
        data.add(ImmutableList.of((Object)GraphTestUtils.serialize(graphProtocol.isGraphBinary() ? new DefaultRemoteTraverser((Object)value, 1L) : ImmutableMap.of((Object)"result", (Object)value), graphProtocol, module)));
        return new DefaultRows((RowsMetadata)metadata, data);
    }

    public static Rows tenGraphRows(GraphProtocol graphProtocol, GraphBinaryModule module, int page, boolean last) throws IOException {
        int start;
        DseRowsMetadata metadata = new DseRowsMetadata((List)ImmutableList.of((Object)new ColumnSpec("ks", "table", "gremlin", 0, graphProtocol.isGraphBinary() ? (RawType)RawType.PRIMITIVES.get(3) : (RawType)RawType.PRIMITIVES.get(13))), null, new int[0], null, page, last);
        ArrayDeque<ImmutableList> data = new ArrayDeque<ImmutableList>();
        for (int i = start = (page - 1) * 10; i < start + 10; ++i) {
            DetachedVertex v = DetachedVertex.build().setId((Object)("vertex" + i)).setLabel("person").addProperty(DetachedVertexProperty.build().setId((Object)("property" + i)).setLabel("name").setValue((Object)("user" + i)).create()).create();
            data.add(ImmutableList.of((Object)GraphTestUtils.serialize(graphProtocol.isGraphBinary() ? new DefaultRemoteTraverser((Object)v, 1L) : ImmutableMap.of((Object)"result", (Object)v), graphProtocol, module)));
        }
        return new DefaultRows((RowsMetadata)metadata, data);
    }

    public static GraphBinaryModule createGraphBinaryModule(DefaultDriverContext context) {
        TypeSerializerRegistry registry = GraphBinaryModule.createDseTypeSerializerRegistry((DefaultDriverContext)context);
        return new GraphBinaryModule(new GraphBinaryReader(registry), new GraphBinaryWriter(registry));
    }

    public static void assertThatContainsProperties(Map<Object, Object> properties, Object ... propsToMatch) {
        for (int i = 0; i < propsToMatch.length; i += 2) {
            Assertions.assertThat(properties).containsEntry(propsToMatch[i], propsToMatch[i + 1]);
        }
    }

    public static void assertThatContainsLabel(Map<Object, Object> properties, Direction direction, String label) {
        Assertions.assertThat(properties).hasEntrySatisfying((Object)direction, value -> {
            MapAssert cfr_ignored_0 = (MapAssert)((MapAssert)Assertions.assertThat((Object)value).asInstanceOf(InstanceOfAssertFactories.MAP)).containsEntry((Object)T.label, (Object)label);
        });
    }
}

