/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

import com.datastax.dse.driver.api.core.DseProtocolVersion;
import com.datastax.dse.driver.api.core.graph.GraphNode;
import com.datastax.dse.driver.internal.core.graph.GraphConversions;
import com.datastax.dse.driver.internal.core.graph.GraphProtocol;
import com.datastax.dse.driver.internal.core.graph.GraphSONUtils;
import com.datastax.dse.driver.internal.core.graph.ObjectGraphNode;
import com.datastax.dse.driver.internal.core.graph.binary.GraphBinaryModule;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.internal.core.context.DefaultDriverContext;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.process.remote.traversal.DefaultRemoteTraverser;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyPath;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.TypeSerializerRegistry;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedEdge;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedProperty;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertex;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertexProperty;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=DataProviderRunner.class)
public class GraphNodeTest {
    private GraphBinaryModule graphBinaryModule;

    @Before
    public void setup() {
        DefaultDriverContext dseDriverContext = (DefaultDriverContext)Mockito.mock(DefaultDriverContext.class);
        Mockito.when((Object)dseDriverContext.getCodecRegistry()).thenReturn((Object)CodecRegistry.DEFAULT);
        Mockito.when((Object)dseDriverContext.getProtocolVersion()).thenReturn((Object)DseProtocolVersion.DSE_V2);
        TypeSerializerRegistry registry = GraphBinaryModule.createDseTypeSerializerRegistry((DefaultDriverContext)dseDriverContext);
        this.graphBinaryModule = new GraphBinaryModule(new GraphBinaryReader(registry), new GraphBinaryWriter(registry));
    }

    @Test
    public void should_not_support_set_for_graphson_2_0() throws IOException {
        GraphNode graphNode = this.serdeAndCreateGraphNode(ImmutableSet.of((Object)"value"), GraphProtocol.GRAPHSON_2_0);
        Assertions.assertThat((boolean)graphNode.isSet()).isFalse();
    }

    @Test
    public void should_throw_for_set_for_graphson_1_0() throws IOException {
        GraphNode graphNode = this.serdeAndCreateGraphNode(ImmutableSet.of((Object)"value"), GraphProtocol.GRAPHSON_1_0);
        Assertions.assertThat((boolean)graphNode.isSet()).isFalse();
        Assertions.assertThatThrownBy(() -> ((GraphNode)graphNode).asSet()).isExactlyInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    @UseDataProvider(value="allGraphProtocols")
    public void should_create_graph_node_for_list(GraphProtocol graphVersion) throws IOException {
        GraphNode graphNode = this.serdeAndCreateGraphNode(ImmutableList.of((Object)"value"), graphVersion);
        Assertions.assertThat((boolean)graphNode.isList()).isTrue();
        List result = graphNode.asList();
        Assertions.assertThat((List)result).isEqualTo((Object)ImmutableList.of((Object)"value"));
    }

    @Test
    @UseDataProvider(value="allGraphProtocols")
    public void should_create_graph_node_for_map(GraphProtocol graphProtocol) throws IOException {
        GraphNode graphNode = this.serdeAndCreateGraphNode(ImmutableMap.of((Object)"value", (Object)1234), graphProtocol);
        Assertions.assertThat((boolean)graphNode.isMap()).isTrue();
        Map result = graphNode.asMap();
        Assertions.assertThat((Map)result).isEqualTo((Object)ImmutableMap.of((Object)"value", (Object)1234));
    }

    @Test
    @UseDataProvider(value="graphson1_0and2_0")
    public void should_create_graph_node_for_map_for_non_string_key(GraphProtocol graphProtocol) throws IOException {
        GraphNode graphNode = this.serdeAndCreateGraphNode(ImmutableMap.of((Object)12, (Object)1234), graphProtocol);
        Assertions.assertThat((boolean)graphNode.isMap()).isTrue();
        Map result = graphNode.asMap();
        Assertions.assertThat((Map)result).isEqualTo((Object)ImmutableMap.of((Object)"12", (Object)1234));
    }

    @Test
    @UseDataProvider(value="allGraphProtocols")
    public void should_calculate_size_of_collection_types(GraphProtocol graphProtocol) throws IOException {
        GraphNode mapNode = this.serdeAndCreateGraphNode(ImmutableMap.of((Object)12, (Object)1234), graphProtocol);
        GraphNode setNode = this.serdeAndCreateGraphNode(ImmutableSet.of((Object)12, (Object)1234), graphProtocol);
        GraphNode listNode = this.serdeAndCreateGraphNode(ImmutableList.of((Object)12, (Object)1234, (Object)99999), graphProtocol);
        Assertions.assertThat((int)mapNode.size()).isEqualTo(1);
        Assertions.assertThat((int)setNode.size()).isEqualTo(2);
        Assertions.assertThat((int)listNode.size()).isEqualTo(3);
    }

    @Test
    @UseDataProvider(value="allGraphProtocols")
    public void should_return_is_value_only_for_scalar_value(GraphProtocol graphProtocol) throws IOException {
        GraphNode mapNode = this.serdeAndCreateGraphNode(ImmutableMap.of((Object)12, (Object)1234), graphProtocol);
        GraphNode setNode = this.serdeAndCreateGraphNode(ImmutableMap.of((Object)12, (Object)1234), graphProtocol);
        GraphNode listNode = this.serdeAndCreateGraphNode(ImmutableMap.of((Object)12, (Object)1234), graphProtocol);
        GraphNode vertexNode = this.serdeAndCreateGraphNode(new DetachedVertex((Object)"a", "l", null), graphProtocol);
        GraphNode edgeNode = this.serdeAndCreateGraphNode(new DetachedEdge((Object)"a", "l", Collections.emptyMap(), (Object)"v1", "l1", (Object)"v2", "l2"), graphProtocol);
        GraphNode pathNode = this.serdeAndCreateGraphNode(EmptyPath.instance(), graphProtocol);
        GraphNode propertyNode = this.serdeAndCreateGraphNode(new DetachedProperty("a", (Object)1), graphProtocol);
        GraphNode vertexPropertyNode = this.serdeAndCreateGraphNode(new DetachedVertexProperty((Object)"id", "l", (Object)"v", null, (Vertex)new DetachedVertex((Object)"a", "l", null)), graphProtocol);
        GraphNode scalarValueNode = this.serdeAndCreateGraphNode(true, graphProtocol);
        Assertions.assertThat((boolean)mapNode.isValue()).isFalse();
        Assertions.assertThat((boolean)setNode.isValue()).isFalse();
        Assertions.assertThat((boolean)listNode.isValue()).isFalse();
        Assertions.assertThat((boolean)vertexNode.isValue()).isFalse();
        Assertions.assertThat((boolean)edgeNode.isValue()).isFalse();
        Assertions.assertThat((boolean)pathNode.isValue()).isFalse();
        Assertions.assertThat((boolean)propertyNode.isValue()).isFalse();
        Assertions.assertThat((boolean)vertexPropertyNode.isValue()).isFalse();
        Assertions.assertThat((boolean)scalarValueNode.isValue()).isTrue();
    }

    @Test
    @UseDataProvider(value="objectGraphNodeProtocols")
    public void should_check_if_node_is_property_not_map(GraphProtocol graphProtocol) throws IOException {
        GraphNode propertyNode = this.serdeAndCreateGraphNode(new DetachedProperty("a", (Object)1), graphProtocol);
        Assertions.assertThat((boolean)propertyNode.isProperty()).isTrue();
        Assertions.assertThat((boolean)propertyNode.isMap()).isFalse();
        Assertions.assertThat((Object)propertyNode.asProperty()).isNotNull();
    }

    @Test
    public void should_check_if_node_is_property_or_map_for_1_0() throws IOException {
        GraphNode propertyNode = this.serdeAndCreateGraphNode(new DetachedProperty("a", (Object)1), GraphProtocol.GRAPHSON_1_0);
        Assertions.assertThat((boolean)propertyNode.isProperty()).isTrue();
        Assertions.assertThat((boolean)propertyNode.isMap()).isTrue();
        Assertions.assertThat((Object)propertyNode.asProperty()).isNotNull();
    }

    @Test
    @UseDataProvider(value="allGraphProtocols")
    public void should_check_if_node_is_vertex_property(GraphProtocol graphProtocol) throws IOException {
        GraphNode vertexPropertyNode = this.serdeAndCreateGraphNode(new DetachedVertexProperty((Object)"id", "l", (Object)"v", null, (Vertex)new DetachedVertex((Object)"a", "l", null)), graphProtocol);
        Assertions.assertThat((boolean)vertexPropertyNode.isVertexProperty()).isTrue();
        Assertions.assertThat((boolean)vertexPropertyNode.isVertexProperty()).isNotNull();
    }

    @Test
    public void should_check_if_node_is_path_for_graphson_1_0() throws IOException {
        GraphNode pathNode = this.serdeAndCreateGraphNode(EmptyPath.instance(), GraphProtocol.GRAPHSON_1_0);
        Assertions.assertThat((boolean)pathNode.isPath()).isFalse();
        Assertions.assertThatThrownBy(() -> ((GraphNode)pathNode).asPath()).isExactlyInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    @UseDataProvider(value="objectGraphNodeProtocols")
    public void should_check_if_node_is_path(GraphProtocol graphProtocol) throws IOException {
        GraphNode pathNode = this.serdeAndCreateGraphNode(EmptyPath.instance(), graphProtocol);
        Assertions.assertThat((boolean)pathNode.isPath()).isTrue();
        Assertions.assertThat((Iterable)pathNode.asPath()).isNotNull();
    }

    @Test
    @UseDataProvider(value="allGraphProtocols")
    public void should_check_if_node_is_vertex(GraphProtocol graphProtocol) throws IOException {
        GraphNode vertexNode = this.serdeAndCreateGraphNode(new DetachedVertex((Object)"a", "l", null), graphProtocol);
        Assertions.assertThat((boolean)vertexNode.isVertex()).isTrue();
        Assertions.assertThat((Object)vertexNode.asVertex()).isNotNull();
    }

    @Test
    @UseDataProvider(value="allGraphProtocols")
    public void should_check_if_node_is_edge(GraphProtocol graphProtocol) throws IOException {
        GraphNode edgeNode = this.serdeAndCreateGraphNode(new DetachedEdge((Object)"a", "l", Collections.emptyMap(), (Object)"v1", "l1", (Object)"v2", "l2"), graphProtocol);
        Assertions.assertThat((boolean)edgeNode.isEdge()).isTrue();
        Assertions.assertThat((Object)edgeNode.asEdge()).isNotNull();
    }

    private GraphNode serdeAndCreateGraphNode(Object inputValue, GraphProtocol graphProtocol) throws IOException {
        if (graphProtocol.isGraphBinary()) {
            Buffer tinkerBuf = this.graphBinaryModule.serialize((Object)new DefaultRemoteTraverser(inputValue, 0L));
            ByteBuffer nioBuffer = tinkerBuf.nioBuffer();
            tinkerBuf.release();
            return new ObjectGraphNode(((Traverser)GraphConversions.createGraphBinaryGraphNode((List)ImmutableList.of((Object)nioBuffer), (GraphBinaryModule)this.graphBinaryModule).as(Traverser.class)).get());
        }
        return GraphSONUtils.createGraphNode((List)ImmutableList.of((Object)GraphSONUtils.serializeToByteBuffer((Object)inputValue, (GraphProtocol)graphProtocol)), (GraphProtocol)graphProtocol);
    }

    @DataProvider
    public static Object[][] allGraphProtocols() {
        return new Object[][]{{GraphProtocol.GRAPHSON_1_0}, {GraphProtocol.GRAPHSON_2_0}, {GraphProtocol.GRAPH_BINARY_1_0}};
    }

    @DataProvider
    public static Object[][] graphson1_0and2_0() {
        return new Object[][]{{GraphProtocol.GRAPHSON_1_0}, {GraphProtocol.GRAPHSON_2_0}};
    }

    @DataProvider
    public static Object[][] objectGraphNodeProtocols() {
        return new Object[][]{{GraphProtocol.GRAPHSON_2_0}, {GraphProtocol.GRAPH_BINARY_1_0}};
    }
}

