/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.data.geometry;

import com.datastax.dse.driver.api.core.data.geometry.Geometry;
import com.datastax.dse.driver.api.core.data.geometry.LineString;
import com.datastax.dse.driver.api.core.data.geometry.Point;
import com.datastax.dse.driver.api.core.data.geometry.Polygon;
import com.datastax.dse.driver.internal.core.data.geometry.Distance;
import com.datastax.dse.driver.internal.core.data.geometry.SerializationUtils;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class DistanceTest {
    private final Point point = Point.fromCoordinates((double)1.1, (double)2.2);
    private final Distance distance = new Distance(this.point, 7.0);
    private final String wkt = "DISTANCE((1.1 2.2) 7.0)";

    @Test
    public void should_parse_valid_well_known_text() {
        Distance fromWkt = Distance.fromWellKnownText((String)"DISTANCE((1.1 2.2) 7.0)");
        Assertions.assertThat((double)fromWkt.getRadius()).isEqualTo(7.0);
        Assertions.assertThat((Object)fromWkt.getCenter()).isEqualTo((Object)this.point);
        Assertions.assertThat((Object)Distance.fromWellKnownText((String)"DISTANCE((1.1 2.2) 7.0)")).isEqualTo((Object)this.distance);
        Assertions.assertThat((Object)Distance.fromWellKnownText((String)"DISTANCE ((1.1 2.2) 7.0)")).isEqualTo((Object)this.distance);
        Assertions.assertThat((Object)Distance.fromWellKnownText((String)"distance((1.1 2.2) 7.0)")).isEqualTo((Object)this.distance);
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_parse_invalid_well_known_text() {
        Distance.fromWellKnownText((String)"dist((1.1 2.2) 3.3)");
    }

    @Test
    public void should_convert_to_well_known_text() {
        Assertions.assertThat((String)this.distance.asWellKnownText()).isEqualTo("DISTANCE((1.1 2.2) 7.0)");
    }

    @Test
    public void should_contain_point() {
        Assertions.assertThat((boolean)this.distance.contains((Geometry)Point.fromCoordinates((double)2.0, (double)3.0))).isTrue();
    }

    @Test
    public void should_not_contain_point() {
        Assertions.assertThat((boolean)this.distance.contains((Geometry)Point.fromCoordinates((double)2.0, (double)9.3))).isFalse();
    }

    @Test
    public void should_contain_linestring() {
        Assertions.assertThat((boolean)this.distance.contains((Geometry)LineString.fromPoints((Point)Point.fromCoordinates((double)2.0, (double)3.0), (Point)Point.fromCoordinates((double)3.1, (double)6.2), (Point[])new Point[]{Point.fromCoordinates((double)-1.0, (double)-2.0)}))).isTrue();
    }

    @Test
    public void should_not_contain_linestring() {
        Assertions.assertThat((boolean)this.distance.contains((Geometry)LineString.fromPoints((Point)Point.fromCoordinates((double)2.0, (double)3.0), (Point)Point.fromCoordinates((double)3.1, (double)9.2), (Point[])new Point[]{Point.fromCoordinates((double)-1.0, (double)-2.0)}))).isFalse();
    }

    @Test
    public void should_contain_polygon() {
        Polygon polygon = Polygon.fromPoints((Point)Point.fromCoordinates((double)3.0, (double)1.0), (Point)Point.fromCoordinates((double)1.0, (double)2.0), (Point)Point.fromCoordinates((double)2.0, (double)4.0), (Point[])new Point[]{Point.fromCoordinates((double)4.0, (double)4.0)});
        Assertions.assertThat((boolean)this.distance.contains((Geometry)polygon)).isTrue();
    }

    @Test
    public void should_not_contain_polygon() {
        Polygon polygon = Polygon.fromPoints((Point)Point.fromCoordinates((double)3.0, (double)1.0), (Point)Point.fromCoordinates((double)1.0, (double)2.0), (Point)Point.fromCoordinates((double)2.0, (double)4.0), (Point[])new Point[]{Point.fromCoordinates((double)10.0, (double)4.0)});
        Assertions.assertThat((boolean)this.distance.contains((Geometry)polygon)).isFalse();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void should_fail_to_convert_to_ogc() {
        this.distance.getOgcGeometry();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void should_fail_to_convert_to_wkb() {
        this.distance.asWellKnownBinary();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void should_fail_to_convert_to_geo_json() {
        this.distance.asGeoJson();
    }

    @Test
    public void should_serialize_and_deserialize() throws Exception {
        Assertions.assertThat((Object)SerializationUtils.serializeAndDeserialize((Geometry)this.distance)).isEqualTo((Object)this.distance);
    }
}

