/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.cql.reactive;

import com.datastax.oss.driver.shaded.guava.common.util.concurrent.Uninterruptibles;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Fail;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class TestSubscriber<T>
implements Subscriber<T> {
    private final List<T> elements = new ArrayList<T>();
    private final CountDownLatch latch = new CountDownLatch(1);
    private final long demand;
    private Subscription subscription;
    private Throwable error;

    public TestSubscriber() {
        this.demand = Long.MAX_VALUE;
    }

    public TestSubscriber(long demand) {
        this.demand = demand;
    }

    public void onSubscribe(Subscription s) {
        if (this.subscription != null) {
            Fail.fail((String)"already subscribed");
        }
        this.subscription = s;
        this.subscription.request(this.demand);
    }

    public void onNext(T t) {
        this.elements.add(t);
    }

    public void onError(Throwable t) {
        this.error = t;
        this.latch.countDown();
    }

    public void onComplete() {
        this.latch.countDown();
    }

    @Nullable
    public Throwable getError() {
        return this.error;
    }

    @NonNull
    public List<T> getElements() {
        return this.elements;
    }

    public void awaitTermination() {
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)this.latch, (long)1L, (TimeUnit)TimeUnit.MINUTES);
        if (this.latch.getCount() > 0L) {
            Fail.fail((String)"subscriber not terminated");
        }
    }
}

