/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.cql.reactive;

import com.datastax.dse.driver.internal.core.cql.reactive.SimpleUnicastProcessor;
import com.datastax.dse.driver.internal.core.cql.reactive.TestSubscriber;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Test;

public class SimpleUnicastProcessorTest {
    @Test
    public void should_propagate_upstream_signals_when_downstream_already_subscribed() {
        SimpleUnicastProcessor processor = new SimpleUnicastProcessor();
        TestSubscriber subscriber = new TestSubscriber();
        processor.subscribe(subscriber);
        processor.onNext((Object)1);
        processor.onComplete();
        subscriber.awaitTermination();
        ((ListAssert)Assertions.assertThat(subscriber.getElements()).hasSize(1)).containsExactly((Object[])new Integer[]{1});
        Assertions.assertThat((Throwable)subscriber.getError()).isNull();
    }

    @Test
    public void should_delay_upstream_signals_until_downstream_is_subscribed() {
        SimpleUnicastProcessor processor = new SimpleUnicastProcessor();
        TestSubscriber subscriber = new TestSubscriber();
        processor.onNext((Object)1);
        processor.onComplete();
        processor.subscribe(subscriber);
        subscriber.awaitTermination();
        ((ListAssert)Assertions.assertThat(subscriber.getElements()).hasSize(1)).containsExactly((Object[])new Integer[]{1});
        Assertions.assertThat((Throwable)subscriber.getError()).isNull();
    }
}

