/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.cql.reactive;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.DefaultProtocolVersion;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.detach.AttachmentPoint;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.internal.core.cql.EmptyColumnDefinitions;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.mockito.Mockito;

class MockRow
implements Row {
    private int index;

    MockRow(int index) {
        this.index = index;
    }

    public int size() {
        return 0;
    }

    @NonNull
    public CodecRegistry codecRegistry() {
        return (CodecRegistry)Mockito.mock(CodecRegistry.class);
    }

    @NonNull
    public ProtocolVersion protocolVersion() {
        return DefaultProtocolVersion.V4;
    }

    @NonNull
    public ColumnDefinitions getColumnDefinitions() {
        return EmptyColumnDefinitions.INSTANCE;
    }

    @NonNull
    public List<Integer> allIndicesOf(@NonNull String name) {
        return Collections.singletonList(0);
    }

    public int firstIndexOf(@NonNull String name) {
        return 0;
    }

    @NonNull
    public List<Integer> allIndicesOf(@NonNull CqlIdentifier id) {
        return Collections.singletonList(0);
    }

    public int firstIndexOf(@NonNull CqlIdentifier id) {
        return 0;
    }

    @NonNull
    public DataType getType(int i) {
        return DataTypes.INT;
    }

    @NonNull
    public DataType getType(@NonNull String name) {
        return DataTypes.INT;
    }

    @NonNull
    public DataType getType(@NonNull CqlIdentifier id) {
        return DataTypes.INT;
    }

    public ByteBuffer getBytesUnsafe(int i) {
        return null;
    }

    public boolean isDetached() {
        return false;
    }

    public void attach(@NonNull AttachmentPoint attachmentPoint) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MockRow)) {
            return false;
        }
        MockRow mockRow = (MockRow)o;
        return this.index == mockRow.index;
    }

    public int hashCode() {
        return this.index;
    }
}

