/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.cql.reactive;

import com.datastax.dse.driver.api.core.cql.reactive.ReactiveRow;
import com.datastax.dse.driver.internal.core.cql.reactive.DefaultReactiveResultSet;
import com.datastax.dse.driver.internal.core.cql.reactive.MockAsyncResultSet;
import com.datastax.dse.driver.internal.core.cql.reactive.TestSubscriber;
import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import io.reactivex.Flowable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Publisher;
import org.reactivestreams.tck.PublisherVerification;
import org.reactivestreams.tck.TestEnvironment;

public class DefaultReactiveResultSetTckTest
extends PublisherVerification<ReactiveRow> {
    public DefaultReactiveResultSetTckTest() {
        super(new TestEnvironment());
    }

    public Publisher<ReactiveRow> createPublisher(long elements) {
        int effective = (int)Math.min(elements, 20L);
        return new DefaultReactiveResultSet(() -> DefaultReactiveResultSetTckTest.createResults(effective));
    }

    public Publisher<ReactiveRow> createFailedPublisher() {
        DefaultReactiveResultSet publisher = new DefaultReactiveResultSet(() -> DefaultReactiveResultSetTckTest.createResults(1));
        publisher.subscribe(new TestSubscriber());
        return publisher;
    }

    private static CompletableFuture<AsyncResultSet> createResults(int elements) {
        CompletableFuture<Object> previous = null;
        if (elements > 0) {
            List pages = (List)Flowable.range((int)0, (int)elements).buffer(5).map(List::size).toList().blockingGet();
            Collections.reverse(pages);
            for (Integer size : pages) {
                CompletableFuture<MockAsyncResultSet> future = new CompletableFuture<MockAsyncResultSet>();
                future.complete(new MockAsyncResultSet(size, previous));
                previous = future;
            }
        } else {
            previous = new CompletableFuture<AsyncResultSet>();
            previous.complete(new MockAsyncResultSet(0, null));
        }
        return previous;
    }
}

