/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.cql.continuous;

import com.datastax.dse.driver.api.core.cql.continuous.ContinuousAsyncResultSet;
import com.datastax.dse.driver.internal.core.cql.continuous.DefaultContinuousResultSet;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.internal.core.util.CountingIterator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;

public class DefaultContinuousResultSetTest {
    @Test
    public void should_create_result_set_from_single_page() {
        ContinuousAsyncResultSet page1 = DefaultContinuousResultSetTest.mockPage(false, 0, 1, 2);
        DefaultContinuousResultSet resultSet = new DefaultContinuousResultSet(page1);
        Assertions.assertThat((Iterable)resultSet.getColumnDefinitions()).isSameAs((Object)page1.getColumnDefinitions());
        Assertions.assertThat((Object)resultSet.getExecutionInfo()).isSameAs((Object)page1.getExecutionInfo());
        Assertions.assertThat((List)resultSet.getExecutionInfos()).containsExactly((Object[])new ExecutionInfo[]{page1.getExecutionInfo()});
        Iterator iterator = resultSet.iterator();
        DefaultContinuousResultSetTest.assertNextRow(iterator, 0);
        DefaultContinuousResultSetTest.assertNextRow(iterator, 1);
        DefaultContinuousResultSetTest.assertNextRow(iterator, 2);
        Assertions.assertThat((boolean)iterator.hasNext()).isFalse();
    }

    @Test
    public void should_create_result_set_from_multiple_pages() {
        ContinuousAsyncResultSet page1 = DefaultContinuousResultSetTest.mockPage(true, 0, 1, 2);
        ContinuousAsyncResultSet page2 = DefaultContinuousResultSetTest.mockPage(true, 3, 4, 5);
        ContinuousAsyncResultSet page3 = DefaultContinuousResultSetTest.mockPage(false, 6, 7, 8);
        DefaultContinuousResultSetTest.complete(page1.fetchNextPage(), page2);
        DefaultContinuousResultSetTest.complete(page2.fetchNextPage(), page3);
        DefaultContinuousResultSet resultSet = new DefaultContinuousResultSet(page1);
        Assertions.assertThat((boolean)resultSet.iterator().hasNext()).isTrue();
        Assertions.assertThat((Iterable)resultSet.getColumnDefinitions()).isSameAs((Object)page1.getColumnDefinitions());
        Assertions.assertThat((Object)resultSet.getExecutionInfo()).isSameAs((Object)page1.getExecutionInfo());
        Assertions.assertThat((List)resultSet.getExecutionInfos()).containsExactly((Object[])new ExecutionInfo[]{page1.getExecutionInfo()});
        Iterator iterator = resultSet.iterator();
        DefaultContinuousResultSetTest.assertNextRow(iterator, 0);
        DefaultContinuousResultSetTest.assertNextRow(iterator, 1);
        DefaultContinuousResultSetTest.assertNextRow(iterator, 2);
        Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
        Assertions.assertThat((Object)resultSet.getExecutionInfo()).isEqualTo((Object)page2.getExecutionInfo());
        Assertions.assertThat((List)resultSet.getExecutionInfos()).containsExactly((Object[])new ExecutionInfo[]{page1.getExecutionInfo(), page2.getExecutionInfo()});
        DefaultContinuousResultSetTest.assertNextRow(iterator, 3);
        DefaultContinuousResultSetTest.assertNextRow(iterator, 4);
        DefaultContinuousResultSetTest.assertNextRow(iterator, 5);
        Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
        Assertions.assertThat((Object)resultSet.getExecutionInfo()).isEqualTo((Object)page3.getExecutionInfo());
        Assertions.assertThat((List)resultSet.getExecutionInfos()).containsExactly((Object[])new ExecutionInfo[]{page1.getExecutionInfo(), page2.getExecutionInfo(), page3.getExecutionInfo()});
        DefaultContinuousResultSetTest.assertNextRow(iterator, 6);
        DefaultContinuousResultSetTest.assertNextRow(iterator, 7);
        DefaultContinuousResultSetTest.assertNextRow(iterator, 8);
    }

    private static ContinuousAsyncResultSet mockPage(boolean nextPage, Integer ... data) {
        ContinuousAsyncResultSet page = (ContinuousAsyncResultSet)Mockito.mock(ContinuousAsyncResultSet.class);
        ColumnDefinitions columnDefinitions = (ColumnDefinitions)Mockito.mock(ColumnDefinitions.class);
        Mockito.when((Object)page.getColumnDefinitions()).thenReturn((Object)columnDefinitions);
        ExecutionInfo executionInfo = (ExecutionInfo)Mockito.mock(ExecutionInfo.class);
        Mockito.when((Object)page.getExecutionInfo()).thenReturn((Object)executionInfo);
        if (nextPage) {
            Mockito.when((Object)page.hasMorePages()).thenReturn((Object)true);
            Mockito.when((Object)page.fetchNextPage()).thenReturn((Object)((CompletionStage)Mockito.spy(new CompletableFuture())));
        } else {
            Mockito.when((Object)page.hasMorePages()).thenReturn((Object)false);
            Mockito.when((Object)page.fetchNextPage()).thenThrow(new Throwable[]{new IllegalStateException()});
        }
        final Iterator<Integer> rows = Arrays.asList(data).iterator();
        CountingIterator<Row> iterator = new CountingIterator<Row>(data.length){

            protected Row computeNext() {
                return rows.hasNext() ? DefaultContinuousResultSetTest.mockRow((Integer)rows.next()) : (Row)this.endOfData();
            }
        };
        Mockito.when((Object)page.currentPage()).thenReturn(() -> DefaultContinuousResultSetTest.lambda$mockPage$0((CountingIterator)iterator));
        Mockito.when((Object)page.remaining()).thenAnswer(arg_0 -> DefaultContinuousResultSetTest.lambda$mockPage$1((CountingIterator)iterator, arg_0));
        return page;
    }

    private static Row mockRow(int index) {
        Row row = (Row)Mockito.mock(Row.class);
        Mockito.when((Object)row.getInt(0)).thenReturn((Object)index);
        return row;
    }

    private static void complete(CompletionStage<ContinuousAsyncResultSet> stage, ContinuousAsyncResultSet result) {
        stage.toCompletableFuture().complete(result);
    }

    private static void assertNextRow(Iterator<Row> iterator, int expectedValue) {
        Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
        Row row0 = iterator.next();
        Assertions.assertThat((int)row0.getInt(0)).isEqualTo(expectedValue);
    }

    private static /* synthetic */ Object lambda$mockPage$1(CountingIterator iterator, InvocationOnMock invocation) throws Throwable {
        return iterator.remaining();
    }

    private static /* synthetic */ Iterator lambda$mockPage$0(CountingIterator iterator) {
        return iterator;
    }
}

