/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.cql.continuous;

import com.datastax.dse.driver.DseTestDataProviders;
import com.datastax.dse.driver.DseTestFixtures;
import com.datastax.dse.driver.api.core.DseProtocolVersion;
import com.datastax.dse.driver.api.core.cql.continuous.ContinuousAsyncResultSet;
import com.datastax.dse.driver.internal.core.cql.continuous.ContinuousCqlRequestHandler;
import com.datastax.dse.driver.internal.core.cql.continuous.ContinuousCqlRequestHandlerTestBase;
import com.datastax.dse.protocol.internal.request.Revise;
import com.datastax.oss.driver.api.core.DefaultProtocolVersion;
import com.datastax.oss.driver.api.core.DriverTimeoutException;
import com.datastax.oss.driver.api.core.NoNodeAvailableException;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.servererrors.BootstrappingException;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.tracker.RequestTracker;
import com.datastax.oss.driver.internal.core.ProtocolFeature;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.channel.ResponseCallback;
import com.datastax.oss.driver.internal.core.cql.PoolBehavior;
import com.datastax.oss.driver.internal.core.cql.RequestHandlerTestHarness;
import com.datastax.oss.driver.internal.core.util.concurrent.CapturingTimer;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.response.Error;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import io.netty.channel.ChannelConfig;
import io.netty.util.Timeout;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ContinuousCqlRequestHandlerTest
extends ContinuousCqlRequestHandlerTestBase {
    private static final Pattern LOG_PREFIX_PER_REQUEST = Pattern.compile("test\\|\\d*\\|\\d");

    @Test
    @UseDataProvider(value="allDseProtocolVersions", location={DseTestDataProviders.class})
    public void should_complete_single_page_result(DseProtocolVersion version) {
        try (RequestHandlerTestHarness harness = this.continuousHarnessBuilder().withProtocolVersion((ProtocolVersion)version).withResponse((Node)this.node1, ContinuousCqlRequestHandlerTest.defaultFrameOf((Message)DseTestFixtures.singleDseRow())).build();){
            CompletionStage resultSetFuture = new ContinuousCqlRequestHandler((Statement)UNDEFINED_IDEMPOTENCE_STATEMENT, harness.getSession(), harness.getContext(), "test").handle();
            com.datastax.oss.driver.Assertions.assertThatStage(resultSetFuture).isSuccess(resultSet -> {
                Iterator rows = resultSet.currentPage().iterator();
                com.datastax.oss.driver.Assertions.assertThat((boolean)rows.hasNext()).isTrue();
                com.datastax.oss.driver.Assertions.assertThat((String)((Row)rows.next()).getString("message")).isEqualTo("hello, world");
                ExecutionInfo executionInfo = resultSet.getExecutionInfo();
                com.datastax.oss.driver.Assertions.assertThat((Object)executionInfo.getCoordinator()).isEqualTo((Object)this.node1);
                com.datastax.oss.driver.Assertions.assertThat((List)executionInfo.getErrors()).isEmpty();
                com.datastax.oss.driver.Assertions.assertThat((Map)executionInfo.getIncomingPayload()).isEmpty();
                com.datastax.oss.driver.Assertions.assertThat((Comparable)executionInfo.getPagingState()).isNull();
                com.datastax.oss.driver.Assertions.assertThat((int)executionInfo.getSpeculativeExecutionCount()).isEqualTo(0);
                com.datastax.oss.driver.Assertions.assertThat((int)executionInfo.getSuccessfulExecutionIndex()).isEqualTo(0);
                com.datastax.oss.driver.Assertions.assertThat((List)executionInfo.getWarnings()).isEmpty();
            });
        }
    }

    @Test
    @UseDataProvider(value="allDseProtocolVersions", location={DseTestDataProviders.class})
    public void should_complete_multi_page_result(DseProtocolVersion version) {
        RequestHandlerTestHarness.Builder builder = this.continuousHarnessBuilder().withProtocolVersion((ProtocolVersion)version);
        PoolBehavior node1Behavior = builder.customBehavior((Node)this.node1);
        try (RequestHandlerTestHarness harness = builder.build();){
            ContinuousCqlRequestHandler handler = new ContinuousCqlRequestHandler((Statement)UNDEFINED_IDEMPOTENCE_STATEMENT, harness.getSession(), harness.getContext(), "test");
            CompletionStage page1Future = handler.handle();
            node1Behavior.setResponseSuccess(ContinuousCqlRequestHandlerTest.defaultFrameOf((Message)DseTestFixtures.tenDseRows(1, false)));
            com.datastax.oss.driver.Assertions.assertThatStage(page1Future).isSuccess(page1 -> {
                com.datastax.oss.driver.Assertions.assertThat((boolean)page1.hasMorePages()).isTrue();
                com.datastax.oss.driver.Assertions.assertThat((int)page1.pageNumber()).isEqualTo(1);
                Iterator rows = page1.currentPage().iterator();
                com.datastax.oss.driver.Assertions.assertThat((boolean)rows.hasNext()).isTrue();
                com.datastax.oss.driver.Assertions.assertThat(rows).toIterable().hasSize(10);
                ExecutionInfo executionInfo = page1.getExecutionInfo();
                com.datastax.oss.driver.Assertions.assertThat((Object)executionInfo.getCoordinator()).isEqualTo((Object)this.node1);
                com.datastax.oss.driver.Assertions.assertThat((List)executionInfo.getErrors()).isEmpty();
                com.datastax.oss.driver.Assertions.assertThat((Map)executionInfo.getIncomingPayload()).isEmpty();
                com.datastax.oss.driver.Assertions.assertThat((Comparable)executionInfo.getPagingState()).isNotNull();
                com.datastax.oss.driver.Assertions.assertThat((int)executionInfo.getSpeculativeExecutionCount()).isEqualTo(0);
                com.datastax.oss.driver.Assertions.assertThat((int)executionInfo.getSuccessfulExecutionIndex()).isEqualTo(0);
                com.datastax.oss.driver.Assertions.assertThat((List)executionInfo.getWarnings()).isEmpty();
            });
            ContinuousAsyncResultSet page12 = (ContinuousAsyncResultSet)CompletableFutures.getCompleted((CompletionStage)page1Future);
            com.datastax.oss.driver.Assertions.assertThat((CompletableFuture)handler.getPendingResult()).isNull();
            CompletionStage page2Future = page12.fetchNextPage();
            com.datastax.oss.driver.Assertions.assertThat((CompletableFuture)handler.getPendingResult()).isNotNull();
            node1Behavior.setResponseSuccess(ContinuousCqlRequestHandlerTest.defaultFrameOf((Message)DseTestFixtures.tenDseRows(2, true)));
            com.datastax.oss.driver.Assertions.assertThatStage(page2Future).isSuccess(page2 -> {
                com.datastax.oss.driver.Assertions.assertThat((boolean)page2.hasMorePages()).isFalse();
                com.datastax.oss.driver.Assertions.assertThat((int)page2.pageNumber()).isEqualTo(2);
                Iterator rows = page2.currentPage().iterator();
                com.datastax.oss.driver.Assertions.assertThat((boolean)rows.hasNext()).isTrue();
                com.datastax.oss.driver.Assertions.assertThat(rows).toIterable().hasSize(10);
                ExecutionInfo executionInfo = page2.getExecutionInfo();
                com.datastax.oss.driver.Assertions.assertThat((Object)executionInfo.getCoordinator()).isEqualTo((Object)this.node1);
                com.datastax.oss.driver.Assertions.assertThat((List)executionInfo.getErrors()).isEmpty();
                com.datastax.oss.driver.Assertions.assertThat((Map)executionInfo.getIncomingPayload()).isEmpty();
                com.datastax.oss.driver.Assertions.assertThat((Comparable)executionInfo.getPagingState()).isNull();
                com.datastax.oss.driver.Assertions.assertThat((int)executionInfo.getSpeculativeExecutionCount()).isEqualTo(0);
                com.datastax.oss.driver.Assertions.assertThat((int)executionInfo.getSuccessfulExecutionIndex()).isEqualTo(0);
                com.datastax.oss.driver.Assertions.assertThat((List)executionInfo.getWarnings()).isEmpty();
            });
        }
    }

    @Test
    @UseDataProvider(value="allDseProtocolVersions", location={DseTestDataProviders.class})
    public void should_fail_if_no_node_available(DseProtocolVersion version) {
        try (RequestHandlerTestHarness harness = this.continuousHarnessBuilder().withProtocolVersion((ProtocolVersion)version).build();){
            CompletionStage resultSetFuture = new ContinuousCqlRequestHandler((Statement)UNDEFINED_IDEMPOTENCE_STATEMENT, harness.getSession(), harness.getContext(), "test").handle();
            com.datastax.oss.driver.Assertions.assertThatStage(resultSetFuture).isFailed(error -> {
                AbstractThrowableAssert cfr_ignored_0 = (AbstractThrowableAssert)com.datastax.oss.driver.Assertions.assertThat((Throwable)error).isInstanceOf(NoNodeAvailableException.class);
            });
        }
    }

    @Test
    @UseDataProvider(value="allOssProtocolVersions", location={DseTestDataProviders.class})
    public void should_throw_if_protocol_version_does_not_support_continuous_paging(ProtocolVersion version) {
        try (RequestHandlerTestHarness harness = this.continuousHarnessBuilder().withProtocolVersion(version).build();){
            Mockito.when((Object)harness.getContext().getProtocolVersionRegistry().supports((ProtocolVersion)ArgumentMatchers.any(DefaultProtocolVersion.class), (ProtocolFeature)ArgumentMatchers.any(ProtocolFeature.class))).thenReturn((Object)false);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new ContinuousCqlRequestHandler((Statement)UNDEFINED_IDEMPOTENCE_STATEMENT, harness.getSession(), harness.getContext(), "test").handle()).isInstanceOf(IllegalStateException.class)).hasMessage("Cannot execute continuous paging requests with protocol version " + version);
        }
    }

    @Test
    @UseDataProvider(value="allDseProtocolVersions", location={DseTestDataProviders.class})
    public void should_time_out_if_first_page_takes_too_long(DseProtocolVersion version) throws Exception {
        RequestHandlerTestHarness.Builder builder = this.continuousHarnessBuilder().withProtocolVersion((ProtocolVersion)version);
        PoolBehavior node1Behavior = builder.customBehavior((Node)this.node1);
        try (RequestHandlerTestHarness harness = builder.build();){
            CompletionStage resultSetFuture = new ContinuousCqlRequestHandler((Statement)UNDEFINED_IDEMPOTENCE_STATEMENT, harness.getSession(), harness.getContext(), "test").handle();
            node1Behavior.setWriteSuccess();
            CapturingTimer.CapturedTimeout page1Timeout = harness.nextScheduledTimeout();
            com.datastax.oss.driver.Assertions.assertThat((long)page1Timeout.getDelay(TimeUnit.NANOSECONDS)).isEqualTo(TIMEOUT_FIRST_PAGE.toNanos());
            page1Timeout.task().run((Timeout)page1Timeout);
            com.datastax.oss.driver.Assertions.assertThatStage(resultSetFuture).isFailed(t -> ((AbstractThrowableAssert)com.datastax.oss.driver.Assertions.assertThat((Throwable)t).isInstanceOf(DriverTimeoutException.class)).hasMessageContaining("Timed out waiting for page 1"));
        }
    }

    @Test
    @UseDataProvider(value="allDseProtocolVersions", location={DseTestDataProviders.class})
    public void should_time_out_if_other_page_takes_too_long(DseProtocolVersion version) throws Exception {
        RequestHandlerTestHarness.Builder builder = this.continuousHarnessBuilder().withProtocolVersion((ProtocolVersion)version);
        PoolBehavior node1Behavior = builder.customBehavior((Node)this.node1);
        try (RequestHandlerTestHarness harness = builder.build();){
            CompletionStage page1Future = new ContinuousCqlRequestHandler((Statement)UNDEFINED_IDEMPOTENCE_STATEMENT, harness.getSession(), harness.getContext(), "test").handle();
            node1Behavior.setWriteSuccess();
            CapturingTimer.CapturedTimeout page1Timeout = harness.nextScheduledTimeout();
            com.datastax.oss.driver.Assertions.assertThat((long)page1Timeout.getDelay(TimeUnit.NANOSECONDS)).isEqualTo(TIMEOUT_FIRST_PAGE.toNanos());
            node1Behavior.setResponseSuccess(ContinuousCqlRequestHandlerTest.defaultFrameOf((Message)DseTestFixtures.tenDseRows(1, false)));
            com.datastax.oss.driver.Assertions.assertThat((boolean)page1Timeout.isCancelled()).isTrue();
            ContinuousAsyncResultSet page1 = (ContinuousAsyncResultSet)CompletableFutures.getUninterruptibly((CompletionStage)page1Future);
            CompletionStage page2Future = page1.fetchNextPage();
            CapturingTimer.CapturedTimeout page2Timeout = harness.nextScheduledTimeout();
            com.datastax.oss.driver.Assertions.assertThat((long)page2Timeout.getDelay(TimeUnit.NANOSECONDS)).isEqualTo(TIMEOUT_OTHER_PAGES.toNanos());
            page2Timeout.task().run((Timeout)page2Timeout);
            com.datastax.oss.driver.Assertions.assertThatStage(page2Future).isFailed(t -> ((AbstractThrowableAssert)com.datastax.oss.driver.Assertions.assertThat((Throwable)t).isInstanceOf(DriverTimeoutException.class)).hasMessageContaining("Timed out waiting for page 2"));
        }
    }

    @Test
    @UseDataProvider(value="allDseProtocolVersions", location={DseTestDataProviders.class})
    public void should_cancel_future_if_session_cancelled(DseProtocolVersion version) {
        RequestHandlerTestHarness.Builder builder = this.continuousHarnessBuilder().withProtocolVersion((ProtocolVersion)version);
        PoolBehavior node1Behavior = builder.customBehavior((Node)this.node1);
        try (RequestHandlerTestHarness harness = builder.build();){
            ContinuousCqlRequestHandler handler = new ContinuousCqlRequestHandler((Statement)UNDEFINED_IDEMPOTENCE_STATEMENT, harness.getSession(), harness.getContext(), "test");
            CompletionStage page1Future = handler.handle();
            node1Behavior.setResponseSuccess(ContinuousCqlRequestHandlerTest.defaultFrameOf((Message)DseTestFixtures.tenDseRows(1, false)));
            node1Behavior.setResponseSuccess(ContinuousCqlRequestHandlerTest.defaultFrameOf((Message)DseTestFixtures.tenDseRows(2, false)));
            ContinuousAsyncResultSet page1 = (ContinuousAsyncResultSet)CompletableFutures.getUninterruptibly((CompletionStage)page1Future);
            page1.cancel();
            com.datastax.oss.driver.Assertions.assertThat((int)handler.getState()).isEqualTo(-2);
            com.datastax.oss.driver.Assertions.assertThat((CompletionStage)page1.fetchNextPage()).isCancelled();
        }
    }

    @Test
    @UseDataProvider(value="allDseProtocolVersions", location={DseTestDataProviders.class})
    public void should_cancel_session_if_future_cancelled(DseProtocolVersion version) {
        RequestHandlerTestHarness.Builder builder = this.continuousHarnessBuilder().withProtocolVersion((ProtocolVersion)version);
        PoolBehavior node1Behavior = builder.customBehavior((Node)this.node1);
        try (RequestHandlerTestHarness harness = builder.build();){
            ContinuousCqlRequestHandler handler = new ContinuousCqlRequestHandler((Statement)UNDEFINED_IDEMPOTENCE_STATEMENT, harness.getSession(), harness.getContext(), "test");
            CompletionStage page1Future = handler.handle();
            page1Future.toCompletableFuture().cancel(true);
            node1Behavior.setResponseSuccess(ContinuousCqlRequestHandlerTest.defaultFrameOf((Message)DseTestFixtures.tenDseRows(1, false)));
            com.datastax.oss.driver.Assertions.assertThat((int)handler.getState()).isEqualTo(-2);
        }
    }

    @Test
    @UseDataProvider(value="allDseProtocolVersions", location={DseTestDataProviders.class})
    public void should_not_cancel_session_if_future_cancelled_but_already_done(DseProtocolVersion version) {
        RequestHandlerTestHarness.Builder builder = this.continuousHarnessBuilder().withProtocolVersion((ProtocolVersion)version);
        PoolBehavior node1Behavior = builder.customBehavior((Node)this.node1);
        try (RequestHandlerTestHarness harness = builder.build();){
            ContinuousCqlRequestHandler handler = new ContinuousCqlRequestHandler((Statement)UNDEFINED_IDEMPOTENCE_STATEMENT, harness.getSession(), harness.getContext(), "test");
            CompletionStage page1Future = handler.handle();
            node1Behavior.setResponseSuccess(ContinuousCqlRequestHandlerTest.defaultFrameOf((Message)DseTestFixtures.tenDseRows(1, true)));
            page1Future.toCompletableFuture().cancel(true);
            com.datastax.oss.driver.Assertions.assertThat((int)handler.getState()).isEqualTo(-1);
        }
    }

    @Test
    public void should_send_cancel_request_if_dse_v2() {
        RequestHandlerTestHarness.Builder builder = this.continuousHarnessBuilder().withProtocolVersion((ProtocolVersion)DseProtocolVersion.DSE_V2);
        PoolBehavior node1Behavior = builder.customBehavior((Node)this.node1);
        try (RequestHandlerTestHarness harness = builder.build();){
            ContinuousCqlRequestHandler handler = new ContinuousCqlRequestHandler((Statement)UNDEFINED_IDEMPOTENCE_STATEMENT, harness.getSession(), harness.getContext(), "test");
            CompletionStage page1Future = handler.handle();
            page1Future.toCompletableFuture().cancel(true);
            com.datastax.oss.driver.Assertions.assertThat((int)handler.getState()).isEqualTo(-2);
            ((DriverChannel)Mockito.verify((Object)node1Behavior.getChannel())).write((Message)ArgumentMatchers.argThat(this::isCancelRequest), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyMap(), (ResponseCallback)ArgumentMatchers.any());
        }
    }

    @Test
    public void should_toggle_channel_autoread_if_dse_v1() {
        RequestHandlerTestHarness.Builder builder = this.continuousHarnessBuilder().withProtocolVersion((ProtocolVersion)DseProtocolVersion.DSE_V1);
        PoolBehavior node1Behavior = builder.customBehavior((Node)this.node1);
        try (RequestHandlerTestHarness harness = builder.build();){
            CompletionStage page1Future = new ContinuousCqlRequestHandler((Statement)UNDEFINED_IDEMPOTENCE_STATEMENT, harness.getSession(), harness.getContext(), "test").handle();
            node1Behavior.setResponseSuccess(ContinuousCqlRequestHandlerTest.defaultFrameOf((Message)DseTestFixtures.tenDseRows(1, false)));
            node1Behavior.setResponseSuccess(ContinuousCqlRequestHandlerTest.defaultFrameOf((Message)DseTestFixtures.tenDseRows(2, false)));
            node1Behavior.setResponseSuccess(ContinuousCqlRequestHandlerTest.defaultFrameOf((Message)DseTestFixtures.tenDseRows(3, false)));
            node1Behavior.setResponseSuccess(ContinuousCqlRequestHandlerTest.defaultFrameOf((Message)DseTestFixtures.tenDseRows(4, false)));
            node1Behavior.setResponseSuccess(ContinuousCqlRequestHandlerTest.defaultFrameOf((Message)DseTestFixtures.tenDseRows(5, false)));
            ((ChannelConfig)Mockito.verify((Object)node1Behavior.getChannel().config())).setAutoRead(false);
            ContinuousAsyncResultSet page1 = (ContinuousAsyncResultSet)CompletableFutures.getCompleted((CompletionStage)page1Future);
            CompletableFutures.getCompleted((CompletionStage)page1.fetchNextPage());
            ((ChannelConfig)Mockito.verify((Object)node1Behavior.getChannel().config())).setAutoRead(true);
            ((DriverChannel)Mockito.verify((Object)node1Behavior.getChannel(), (VerificationMode)Mockito.never())).write((Message)ArgumentMatchers.any(Revise.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyMap(), (ResponseCallback)ArgumentMatchers.any());
        }
    }

    @Test
    public void should_send_backpressure_request_if_dse_v2() {
        RequestHandlerTestHarness.Builder builder = this.continuousHarnessBuilder().withProtocolVersion((ProtocolVersion)DseProtocolVersion.DSE_V2);
        PoolBehavior node1Behavior = builder.customBehavior((Node)this.node1);
        try (RequestHandlerTestHarness harness = builder.build();){
            CompletionStage page1Future = new ContinuousCqlRequestHandler((Statement)UNDEFINED_IDEMPOTENCE_STATEMENT, harness.getSession(), harness.getContext(), "test").handle();
            node1Behavior.setResponseSuccess(ContinuousCqlRequestHandlerTest.defaultFrameOf((Message)DseTestFixtures.tenDseRows(1, false)));
            node1Behavior.setResponseSuccess(ContinuousCqlRequestHandlerTest.defaultFrameOf((Message)DseTestFixtures.tenDseRows(2, false)));
            node1Behavior.setResponseSuccess(ContinuousCqlRequestHandlerTest.defaultFrameOf((Message)DseTestFixtures.tenDseRows(3, false)));
            node1Behavior.setResponseSuccess(ContinuousCqlRequestHandlerTest.defaultFrameOf((Message)DseTestFixtures.tenDseRows(4, false)));
            ContinuousAsyncResultSet page1 = (ContinuousAsyncResultSet)CompletableFutures.getCompleted((CompletionStage)page1Future);
            CompletableFutures.getCompleted((CompletionStage)page1.fetchNextPage());
            ((DriverChannel)Mockito.verify((Object)node1Behavior.getChannel())).write((Message)ArgumentMatchers.argThat(this::isBackpressureRequest), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyMap(), (ResponseCallback)ArgumentMatchers.any());
            ((ChannelConfig)Mockito.verify((Object)node1Behavior.getChannel().config(), (VerificationMode)Mockito.never())).setAutoRead(ArgumentMatchers.anyBoolean());
        }
    }

    @Test
    @UseDataProvider(value="allDseProtocolVersions", location={DseTestDataProviders.class})
    public void should_invoke_request_tracker(DseProtocolVersion version) {
        try (RequestHandlerTestHarness harness = this.continuousHarnessBuilder().withProtocolVersion((ProtocolVersion)version).withResponse((Node)this.node1, ContinuousCqlRequestHandlerTest.defaultFrameOf((Message)new Error(4098, "mock message"))).withResponse((Node)this.node2, ContinuousCqlRequestHandlerTest.defaultFrameOf((Message)DseTestFixtures.singleDseRow())).build();){
            RequestTracker requestTracker = (RequestTracker)Mockito.mock(RequestTracker.class);
            Mockito.when((Object)harness.getContext().getRequestTracker()).thenReturn((Object)requestTracker);
            CompletionStage resultSetFuture = new ContinuousCqlRequestHandler((Statement)UNDEFINED_IDEMPOTENCE_STATEMENT, harness.getSession(), harness.getContext(), "test").handle();
            com.datastax.oss.driver.Assertions.assertThatStage(resultSetFuture).isSuccess(resultSet -> {
                Iterator rows = resultSet.currentPage().iterator();
                com.datastax.oss.driver.Assertions.assertThat((boolean)rows.hasNext()).isTrue();
                com.datastax.oss.driver.Assertions.assertThat((String)((Row)rows.next()).getString("message")).isEqualTo("hello, world");
                ExecutionInfo executionInfo = resultSet.getExecutionInfo();
                com.datastax.oss.driver.Assertions.assertThat((Object)executionInfo.getCoordinator()).isEqualTo((Object)this.node2);
                com.datastax.oss.driver.Assertions.assertThat((List)executionInfo.getErrors()).isNotEmpty();
                com.datastax.oss.driver.Assertions.assertThat((Map)executionInfo.getIncomingPayload()).isEmpty();
                com.datastax.oss.driver.Assertions.assertThat((Comparable)executionInfo.getPagingState()).isNull();
                com.datastax.oss.driver.Assertions.assertThat((int)executionInfo.getSpeculativeExecutionCount()).isEqualTo(0);
                com.datastax.oss.driver.Assertions.assertThat((int)executionInfo.getSuccessfulExecutionIndex()).isEqualTo(0);
                com.datastax.oss.driver.Assertions.assertThat((List)executionInfo.getWarnings()).isEmpty();
                ((RequestTracker)Mockito.verify((Object)requestTracker)).onNodeError((Request)ArgumentMatchers.eq((Object)UNDEFINED_IDEMPOTENCE_STATEMENT), (Throwable)ArgumentMatchers.any(BootstrappingException.class), ArgumentMatchers.anyLong(), (DriverExecutionProfile)ArgumentMatchers.any(DriverExecutionProfile.class), (Node)ArgumentMatchers.eq((Object)this.node1), ArgumentMatchers.matches((Pattern)LOG_PREFIX_PER_REQUEST));
                ((RequestTracker)Mockito.verify((Object)requestTracker)).onNodeSuccess((Request)ArgumentMatchers.eq((Object)UNDEFINED_IDEMPOTENCE_STATEMENT), ArgumentMatchers.anyLong(), (DriverExecutionProfile)ArgumentMatchers.any(DriverExecutionProfile.class), (Node)ArgumentMatchers.eq((Object)this.node2), ArgumentMatchers.matches((Pattern)LOG_PREFIX_PER_REQUEST));
                ((RequestTracker)Mockito.verify((Object)requestTracker)).onSuccess((Request)ArgumentMatchers.eq((Object)UNDEFINED_IDEMPOTENCE_STATEMENT), ArgumentMatchers.anyLong(), (DriverExecutionProfile)ArgumentMatchers.any(DriverExecutionProfile.class), (Node)ArgumentMatchers.eq((Object)this.node2), ArgumentMatchers.matches((Pattern)LOG_PREFIX_PER_REQUEST));
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{requestTracker});
            });
        }
    }

    private boolean isBackpressureRequest(Message argument) {
        return argument instanceof Revise && ((Revise)argument).revisionType == 2;
    }

    private boolean isCancelRequest(Message argument) {
        return argument instanceof Revise && ((Revise)argument).revisionType == 1;
    }
}

