/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.cql.continuous;

import com.datastax.dse.driver.DseTestDataProviders;
import com.datastax.dse.driver.DseTestFixtures;
import com.datastax.dse.driver.api.core.DseProtocolVersion;
import com.datastax.dse.driver.api.core.cql.continuous.ContinuousAsyncResultSet;
import com.datastax.dse.driver.internal.core.cql.continuous.ContinuousCqlRequestHandler;
import com.datastax.dse.driver.internal.core.cql.continuous.ContinuousCqlRequestHandlerTestBase;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.servererrors.SyntaxError;
import com.datastax.oss.driver.internal.core.adminrequest.AdminRequestHandler;
import com.datastax.oss.driver.internal.core.adminrequest.UnexpectedResponseException;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.channel.ResponseCallback;
import com.datastax.oss.driver.internal.core.cql.RequestHandlerTestHarness;
import com.datastax.oss.driver.internal.core.session.RepreparePayload;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.protocol.internal.Frame;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.request.Prepare;
import com.datastax.oss.protocol.internal.request.Query;
import com.datastax.oss.protocol.internal.response.Error;
import com.datastax.oss.protocol.internal.response.error.Unprepared;
import com.datastax.oss.protocol.internal.response.result.Prepared;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import io.netty.util.concurrent.Future;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ContinuousCqlRequestHandlerReprepareTest
extends ContinuousCqlRequestHandlerTestBase {
    private final byte[] preparedId = new byte[]{1, 2, 3};
    private final ByteBuffer preparedIdBuf = ByteBuffer.wrap(this.preparedId);
    private final RepreparePayload repreparePayload = new RepreparePayload(this.preparedIdBuf, "irrelevant", CqlIdentifier.fromCql((String)"ks"), Frame.NO_PAYLOAD);
    private final ConcurrentMap<ByteBuffer, RepreparePayload> repreparePayloads = new ConcurrentHashMap<ByteBuffer, RepreparePayload>((Map<ByteBuffer, RepreparePayload>)ImmutableMap.of((Object)this.preparedIdBuf, (Object)this.repreparePayload));
    private final Unprepared unprepared = new Unprepared("test", this.preparedId);
    private final Prepared prepared = new Prepared(this.preparedId, null, null, null);
    private final Error unrecoverable = new Error(8192, "bad query");
    private final Error recoverable = new Error(0, "sorry");
    @Mock
    private Future<Void> future;

    @Override
    public void setup() {
        super.setup();
        Mockito.when((Object)this.future.isSuccess()).thenReturn((Object)true);
    }

    @Test
    @UseDataProvider(value="allDseProtocolVersions", location={DseTestDataProviders.class})
    public void should_prepare_and_retry_on_same_node(DseProtocolVersion version) {
        try (RequestHandlerTestHarness harness = this.continuousHarnessBuilder().withResponse((Node)this.node1, ContinuousCqlRequestHandlerReprepareTest.defaultFrameOf((Message)this.unprepared)).withProtocolVersion((ProtocolVersion)version).build();){
            Mockito.when((Object)harness.getSession().getRepreparePayloads()).thenReturn(this.repreparePayloads);
            Mockito.when((Object)harness.getChannel((Node)this.node1).write((Message)ArgumentMatchers.any(Prepare.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyMap(), (ResponseCallback)ArgumentMatchers.any())).then(invocation -> {
                AdminRequestHandler admin = (AdminRequestHandler)invocation.getArgument(3);
                admin.onResponse(ContinuousCqlRequestHandlerReprepareTest.defaultFrameOf((Message)this.prepared));
                return this.future;
            });
            new ContinuousCqlRequestHandler((Statement)UNDEFINED_IDEMPOTENCE_STATEMENT, harness.getSession(), harness.getContext(), "test").handle();
            ((DriverChannel)Mockito.verify((Object)harness.getChannel((Node)this.node1))).write((Message)ArgumentMatchers.any(Prepare.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyMap(), (ResponseCallback)ArgumentMatchers.any());
            ((DriverChannel)Mockito.verify((Object)harness.getChannel((Node)this.node1), (VerificationMode)Mockito.times((int)2))).write((Message)ArgumentMatchers.any(Query.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyMap(), (ResponseCallback)ArgumentMatchers.any());
        }
    }

    @Test
    @UseDataProvider(value="allDseProtocolVersions", location={DseTestDataProviders.class})
    public void should_abort_when_prepare_fails_with_unrecoverable_error(DseProtocolVersion version) {
        try (RequestHandlerTestHarness harness = this.continuousHarnessBuilder().withResponse((Node)this.node1, ContinuousCqlRequestHandlerReprepareTest.defaultFrameOf((Message)this.unprepared)).withProtocolVersion((ProtocolVersion)version).build();){
            Mockito.when((Object)harness.getSession().getRepreparePayloads()).thenReturn(this.repreparePayloads);
            Mockito.when((Object)harness.getChannel((Node)this.node1).write((Message)ArgumentMatchers.any(Prepare.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyMap(), (ResponseCallback)ArgumentMatchers.any())).then(invocation -> {
                AdminRequestHandler admin = (AdminRequestHandler)invocation.getArgument(3);
                admin.onResponse(ContinuousCqlRequestHandlerReprepareTest.defaultFrameOf((Message)this.unrecoverable));
                return this.future;
            });
            ContinuousCqlRequestHandler handler = new ContinuousCqlRequestHandler((Statement)UNDEFINED_IDEMPOTENCE_STATEMENT, harness.getSession(), harness.getContext(), "test");
            CompletionStage page1Future = handler.handle();
            ((DriverChannel)Mockito.verify((Object)harness.getChannel((Node)this.node1))).write((Message)ArgumentMatchers.any(Query.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyMap(), (ResponseCallback)ArgumentMatchers.any());
            ((DriverChannel)Mockito.verify((Object)harness.getChannel((Node)this.node1))).write((Message)ArgumentMatchers.any(Prepare.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyMap(), (ResponseCallback)ArgumentMatchers.any());
            com.datastax.oss.driver.Assertions.assertThat((int)handler.getState()).isEqualTo(-2);
            com.datastax.oss.driver.Assertions.assertThat((CompletionStage)page1Future).isCompletedExceptionally();
            Throwable t = Assertions.catchThrowable(() -> {
                ContinuousAsyncResultSet cfr_ignored_0 = (ContinuousAsyncResultSet)page1Future.toCompletableFuture().get();
            });
            com.datastax.oss.driver.Assertions.assertThat((Throwable)t).hasRootCauseInstanceOf(SyntaxError.class).hasMessageContaining("bad query");
        }
    }

    @Test
    @UseDataProvider(value="allDseProtocolVersions", location={DseTestDataProviders.class})
    public void should_try_next_node_when_prepare_fails_with_recoverable_error(DseProtocolVersion version) {
        try (RequestHandlerTestHarness harness = this.continuousHarnessBuilder().withResponse((Node)this.node1, ContinuousCqlRequestHandlerReprepareTest.defaultFrameOf((Message)this.unprepared)).withResponse((Node)this.node2, ContinuousCqlRequestHandlerReprepareTest.defaultFrameOf((Message)DseTestFixtures.singleDseRow())).withProtocolVersion((ProtocolVersion)version).build();){
            Mockito.when((Object)harness.getSession().getRepreparePayloads()).thenReturn(this.repreparePayloads);
            Mockito.when((Object)harness.getChannel((Node)this.node1).write((Message)ArgumentMatchers.any(Prepare.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyMap(), (ResponseCallback)ArgumentMatchers.any())).then(invocation -> {
                AdminRequestHandler admin = (AdminRequestHandler)invocation.getArgument(3);
                admin.onResponse(ContinuousCqlRequestHandlerReprepareTest.defaultFrameOf((Message)this.recoverable));
                return this.future;
            });
            ContinuousCqlRequestHandler handler = new ContinuousCqlRequestHandler((Statement)UNDEFINED_IDEMPOTENCE_STATEMENT, harness.getSession(), harness.getContext(), "test");
            CompletionStage page1Future = handler.handle();
            ((DriverChannel)Mockito.verify((Object)harness.getChannel((Node)this.node1))).write((Message)ArgumentMatchers.any(Query.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyMap(), (ResponseCallback)ArgumentMatchers.any());
            ((DriverChannel)Mockito.verify((Object)harness.getChannel((Node)this.node1))).write((Message)ArgumentMatchers.any(Prepare.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyMap(), (ResponseCallback)ArgumentMatchers.any());
            ((DriverChannel)Mockito.verify((Object)harness.getChannel((Node)this.node2))).write((Message)ArgumentMatchers.any(Query.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyMap(), (ResponseCallback)ArgumentMatchers.any());
            com.datastax.oss.driver.Assertions.assertThat((int)handler.getState()).isEqualTo(-1);
            com.datastax.oss.driver.Assertions.assertThatStage(page1Future).isSuccess(rs -> {
                com.datastax.oss.driver.Assertions.assertThat((Iterable)rs.currentPage()).hasSize(1);
                com.datastax.oss.driver.Assertions.assertThat((boolean)rs.hasMorePages()).isFalse();
                com.datastax.oss.driver.Assertions.assertThat((Object)rs.getExecutionInfo().getCoordinator()).isEqualTo((Object)this.node2);
                ((ListAssert)com.datastax.oss.driver.Assertions.assertThat((List)rs.getExecutionInfo().getErrors()).hasSize(1)).allSatisfy(entry -> {
                    com.datastax.oss.driver.Assertions.assertThat((Object)((Node)entry.getKey())).isEqualTo((Object)this.node1);
                    ((AbstractThrowableAssert)com.datastax.oss.driver.Assertions.assertThat((Throwable)((Throwable)entry.getValue())).isInstanceOf(UnexpectedResponseException.class)).hasMessageContaining(this.recoverable.toString());
                });
            });
        }
    }
}

