/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.cql.continuous;

import com.datastax.dse.driver.DseTestDataProviders;
import com.datastax.dse.driver.DseTestFixtures;
import com.datastax.dse.driver.api.core.DseProtocolVersion;
import com.datastax.dse.driver.internal.core.cql.continuous.ContinuousCqlRequestHandler;
import com.datastax.dse.driver.internal.core.cql.continuous.ContinuousCqlRequestHandlerTestBase;
import com.datastax.oss.driver.api.core.AllNodesFailedException;
import com.datastax.oss.driver.api.core.NodeUnavailableException;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.internal.core.cql.RequestHandlerTestHarness;
import com.datastax.oss.driver.internal.core.metadata.LoadBalancingPolicyWrapper;
import com.datastax.oss.protocol.internal.Message;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class ContinuousCqlRequestHandlerNodeTargetingTest
extends ContinuousCqlRequestHandlerTestBase {
    @Test
    @UseDataProvider(value="allDseProtocolVersions", location={DseTestDataProviders.class})
    public void should_fail_if_targeted_node_not_available(DseProtocolVersion version) {
        try (RequestHandlerTestHarness harness = this.continuousHarnessBuilder().withResponse((Node)this.node1, ContinuousCqlRequestHandlerNodeTargetingTest.defaultFrameOf((Message)DseTestFixtures.singleDseRow())).withResponse((Node)this.node2, ContinuousCqlRequestHandlerNodeTargetingTest.defaultFrameOf((Message)DseTestFixtures.singleDseRow())).withEmptyPool((Node)this.node3).withProtocolVersion((ProtocolVersion)version).build();){
            LoadBalancingPolicyWrapper loadBalancingPolicy = harness.getContext().getLoadBalancingPolicyWrapper();
            InOrder invocations = Mockito.inOrder((Object[])new Object[]{loadBalancingPolicy});
            CompletionStage resultSetFuture = new ContinuousCqlRequestHandler(UNDEFINED_IDEMPOTENCE_STATEMENT.setNode((Node)this.node3), harness.getSession(), harness.getContext(), "target node 3, unavailable").handle();
            com.datastax.oss.driver.Assertions.assertThatStage(resultSetFuture).isFailed(error -> {
                Assertions.assertThat((Throwable)error).isInstanceOf(AllNodesFailedException.class);
                Map errors = ((AllNodesFailedException)error).getAllErrors();
                Assertions.assertThat((Map)errors).hasSize(1);
                List nodeErrors = (List)errors.values().iterator().next();
                ((ObjectAssert)Assertions.assertThat((List)nodeErrors).singleElement()).isInstanceOf(NodeUnavailableException.class);
                ((LoadBalancingPolicyWrapper)invocations.verify((Object)loadBalancingPolicy, Mockito.never())).newQueryPlan((Request)ArgumentMatchers.any(Request.class), ArgumentMatchers.anyString(), (Session)ArgumentMatchers.any(Session.class));
            });
            resultSetFuture = new ContinuousCqlRequestHandler((Statement)UNDEFINED_IDEMPOTENCE_STATEMENT, harness.getSession(), harness.getContext(), "no node targeting, should use node 1").handle();
            com.datastax.oss.driver.Assertions.assertThatStage(resultSetFuture).isSuccess(resultSet -> {
                Assertions.assertThat((Object)resultSet.getExecutionInfo().getCoordinator()).isEqualTo((Object)this.node1);
                ((LoadBalancingPolicyWrapper)invocations.verify((Object)loadBalancingPolicy)).newQueryPlan((Request)UNDEFINED_IDEMPOTENCE_STATEMENT, "default", (Session)harness.getSession());
            });
            resultSetFuture = new ContinuousCqlRequestHandler((Statement)UNDEFINED_IDEMPOTENCE_STATEMENT, harness.getSession(), harness.getContext(), "no node targeting, should use node 2").handle();
            com.datastax.oss.driver.Assertions.assertThatStage(resultSetFuture).isSuccess(resultSet -> {
                Assertions.assertThat((Object)resultSet.getExecutionInfo().getCoordinator()).isEqualTo((Object)this.node2);
                ((LoadBalancingPolicyWrapper)invocations.verify((Object)loadBalancingPolicy)).newQueryPlan((Request)UNDEFINED_IDEMPOTENCE_STATEMENT, "default", (Session)harness.getSession());
            });
        }
    }

    @Test
    @UseDataProvider(value="allDseProtocolVersions", location={DseTestDataProviders.class})
    public void should_target_node(DseProtocolVersion version) {
        try (RequestHandlerTestHarness harness = this.continuousHarnessBuilder().withResponse((Node)this.node1, ContinuousCqlRequestHandlerNodeTargetingTest.defaultFrameOf((Message)DseTestFixtures.singleDseRow())).withResponse((Node)this.node2, ContinuousCqlRequestHandlerNodeTargetingTest.defaultFrameOf((Message)DseTestFixtures.singleDseRow())).withResponse((Node)this.node3, ContinuousCqlRequestHandlerNodeTargetingTest.defaultFrameOf((Message)DseTestFixtures.singleDseRow())).withProtocolVersion((ProtocolVersion)version).build();){
            LoadBalancingPolicyWrapper loadBalancingPolicy = harness.getContext().getLoadBalancingPolicyWrapper();
            InOrder invocations = Mockito.inOrder((Object[])new Object[]{loadBalancingPolicy});
            CompletionStage resultSetFuture = new ContinuousCqlRequestHandler(UNDEFINED_IDEMPOTENCE_STATEMENT.setNode((Node)this.node3), harness.getSession(), harness.getContext(), "target node 3").handle();
            com.datastax.oss.driver.Assertions.assertThatStage(resultSetFuture).isSuccess(resultSet -> {
                Assertions.assertThat((Object)resultSet.getExecutionInfo().getCoordinator()).isEqualTo((Object)this.node3);
                ((LoadBalancingPolicyWrapper)invocations.verify((Object)loadBalancingPolicy, Mockito.never())).newQueryPlan((Request)ArgumentMatchers.any(Request.class), ArgumentMatchers.anyString(), (Session)ArgumentMatchers.any(Session.class));
            });
            resultSetFuture = new ContinuousCqlRequestHandler((Statement)UNDEFINED_IDEMPOTENCE_STATEMENT, harness.getSession(), harness.getContext(), "no node targeting").handle();
            com.datastax.oss.driver.Assertions.assertThatStage(resultSetFuture).isSuccess(resultSet -> {
                Assertions.assertThat((Object)resultSet.getExecutionInfo().getCoordinator()).isEqualTo((Object)this.node1);
                ((LoadBalancingPolicyWrapper)invocations.verify((Object)loadBalancingPolicy)).newQueryPlan((Request)UNDEFINED_IDEMPOTENCE_STATEMENT, "default", (Session)harness.getSession());
            });
        }
    }
}

