/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.context;

import com.datastax.dse.driver.api.core.config.DseDriverOption;
import com.datastax.oss.driver.api.core.Version;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.session.ProgrammaticArguments;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.api.core.uuid.Uuids;
import com.datastax.oss.driver.internal.core.context.DefaultDriverContext;
import com.datastax.oss.protocol.internal.request.Startup;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import java.util.Map;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=DataProviderRunner.class)
public class DseStartupOptionsBuilderTest {
    private DefaultDriverContext driverContext;
    @Mock
    private DriverConfigLoader configLoader;
    @Mock
    private DriverConfig driverConfig;
    @Mock
    private DriverExecutionProfile defaultProfile;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.configLoader.getInitialConfig()).thenReturn((Object)this.driverConfig);
        Mockito.when((Object)this.driverConfig.getDefaultProfile()).thenReturn((Object)this.defaultProfile);
        Mockito.when((Object)this.defaultProfile.isDefined((DriverOption)DseDriverOption.CONTINUOUS_PAGING_PAGE_SIZE)).thenReturn((Object)true);
    }

    private void buildContext(UUID clientId, String applicationName, String applicationVersion) {
        this.driverContext = new DefaultDriverContext(this.configLoader, ProgrammaticArguments.builder().withStartupClientId(clientId).withStartupApplicationName(applicationName).withStartupApplicationVersion(applicationVersion).build());
    }

    private void assertDefaultStartupOptions(Startup startup) {
        Assertions.assertThat((Map)startup.options).containsEntry((Object)"CQL_VERSION", (Object)"3.0.0");
        Assertions.assertThat((Map)startup.options).containsEntry((Object)"DRIVER_NAME", (Object)Session.OSS_DRIVER_COORDINATES.getName());
        Assertions.assertThat((Map)startup.options).containsKey((Object)"DRIVER_VERSION");
        Version version = Version.parse((String)((String)startup.options.get("DRIVER_VERSION")));
        Assertions.assertThat((Comparable)version).isEqualTo((Object)Session.OSS_DRIVER_COORDINATES.getVersion());
        Assertions.assertThat((Map)startup.options).containsKey((Object)"CLIENT_ID");
    }

    @Test
    public void should_build_startup_options_with_no_compression_if_undefined() {
        Mockito.when((Object)this.defaultProfile.getString((DriverOption)DefaultDriverOption.PROTOCOL_COMPRESSION, "none")).thenReturn((Object)"none");
        this.buildContext(null, null, null);
        Startup startup = new Startup(this.driverContext.getStartupOptions());
        Assertions.assertThat((Map)startup.options).doesNotContainKey((Object)"COMPRESSION");
        this.assertDefaultStartupOptions(startup);
    }

    @Test
    @DataProvider(value={"lz4", "snappy"})
    public void should_build_startup_options_with_compression(String compression) {
        Mockito.when((Object)this.defaultProfile.getString((DriverOption)DefaultDriverOption.PROTOCOL_COMPRESSION, "none")).thenReturn((Object)compression);
        this.buildContext(null, null, null);
        Startup startup = new Startup(this.driverContext.getStartupOptions());
        Assertions.assertThat((Map)startup.options).containsEntry((Object)"COMPRESSION", (Object)compression);
        Assertions.assertThat((Map)startup.options).doesNotContainKey((Object)"APPLICATION_NAME");
        Assertions.assertThat((Map)startup.options).doesNotContainKey((Object)"APPLICATION_VERSION");
        this.assertDefaultStartupOptions(startup);
    }

    @Test
    public void should_fail_to_build_startup_options_with_invalid_compression() {
        Mockito.when((Object)this.defaultProfile.getString((DriverOption)DefaultDriverOption.PROTOCOL_COMPRESSION, "none")).thenReturn((Object)"foobar");
        this.buildContext(null, null, null);
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new Startup(this.driverContext.getStartupOptions()));
    }

    @Test
    public void should_build_startup_options_with_client_id() {
        Mockito.when((Object)this.defaultProfile.getString((DriverOption)DefaultDriverOption.PROTOCOL_COMPRESSION, "none")).thenReturn((Object)"none");
        UUID customClientId = Uuids.random();
        this.buildContext(customClientId, null, null);
        Startup startup = new Startup(this.driverContext.getStartupOptions());
        Assertions.assertThat((Map)startup.options).containsEntry((Object)"CLIENT_ID", (Object)customClientId.toString());
        Assertions.assertThat((Map)startup.options).doesNotContainKey((Object)"COMPRESSION");
        Assertions.assertThat((Map)startup.options).doesNotContainKey((Object)"APPLICATION_NAME");
        Assertions.assertThat((Map)startup.options).doesNotContainKey((Object)"APPLICATION_VERSION");
        this.assertDefaultStartupOptions(startup);
    }

    @Test
    public void should_build_startup_options_with_application_version_and_name() {
        Mockito.when((Object)this.defaultProfile.getString((DriverOption)DefaultDriverOption.PROTOCOL_COMPRESSION, "none")).thenReturn((Object)"none");
        this.buildContext(null, "Custom_App_Name", "Custom_App_Version");
        Startup startup = new Startup(this.driverContext.getStartupOptions());
        Assertions.assertThat((Map)startup.options).containsEntry((Object)"APPLICATION_NAME", (Object)"Custom_App_Name");
        Assertions.assertThat((Map)startup.options).containsEntry((Object)"APPLICATION_VERSION", (Object)"Custom_App_Version");
        Assertions.assertThat((Map)startup.options).doesNotContainKey((Object)"COMPRESSION");
        this.assertDefaultStartupOptions(startup);
    }

    @Test
    public void should_build_startup_options_with_all_options() {
        Mockito.when((Object)this.defaultProfile.getString((DriverOption)DefaultDriverOption.PROTOCOL_COMPRESSION, "none")).thenReturn((Object)"snappy");
        UUID customClientId = Uuids.random();
        this.buildContext(customClientId, "Custom_App_Name", "Custom_App_Version");
        Startup startup = new Startup(this.driverContext.getStartupOptions());
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)startup.options).containsEntry((Object)"CLIENT_ID", (Object)customClientId.toString())).containsEntry((Object)"APPLICATION_NAME", (Object)"Custom_App_Name")).containsEntry((Object)"APPLICATION_VERSION", (Object)"Custom_App_Version");
        Assertions.assertThat((Map)startup.options).containsEntry((Object)"COMPRESSION", (Object)"snappy");
        this.assertDefaultStartupOptions(startup);
    }

    @Test
    public void should_use_configuration_when_no_programmatic_values_provided() {
        Mockito.when((Object)this.defaultProfile.getString((DriverOption)DseDriverOption.APPLICATION_NAME, null)).thenReturn((Object)"Config_App_Name");
        Mockito.when((Object)this.defaultProfile.getString((DriverOption)DseDriverOption.APPLICATION_VERSION, null)).thenReturn((Object)"Config_App_Version");
        Mockito.when((Object)this.defaultProfile.getString((DriverOption)DefaultDriverOption.PROTOCOL_COMPRESSION, "none")).thenReturn((Object)"none");
        this.buildContext(null, null, null);
        Startup startup = new Startup(this.driverContext.getStartupOptions());
        ((MapAssert)Assertions.assertThat((Map)startup.options).containsEntry((Object)"APPLICATION_NAME", (Object)"Config_App_Name")).containsEntry((Object)"APPLICATION_VERSION", (Object)"Config_App_Version");
    }

    @Test
    public void should_ignore_configuration_when_programmatic_values_provided() {
        Mockito.when((Object)this.defaultProfile.getString((DriverOption)DefaultDriverOption.PROTOCOL_COMPRESSION, "none")).thenReturn((Object)"none");
        this.buildContext(null, "Custom_App_Name", "Custom_App_Version");
        Startup startup = new Startup(this.driverContext.getStartupOptions());
        ((MapAssert)Assertions.assertThat((Map)startup.options).containsEntry((Object)"APPLICATION_NAME", (Object)"Custom_App_Name")).containsEntry((Object)"APPLICATION_VERSION", (Object)"Custom_App_Version");
    }
}

