/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Properties;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public abstract class DependencyCheckTestBase {
    private String baseResourcePath;

    protected DependencyCheckTestBase() {
        Properties projectProperties = new Properties();
        try (InputStream is = this.getClass().getResourceAsStream("/project.properties");){
            projectProperties.load(is);
            this.baseResourcePath = projectProperties.getProperty("project.basedir");
        }
        catch (IOException ioe) {
            throw new AssertionError("Error retrieving \"project.basedir\" value from \"/project.properties\". Please check test resources in this project.", ioe);
        }
        assert (this.baseResourcePath != null);
    }

    @Test
    public void should_generate_deps_txt() {
        Assertions.assertThat((Path)this.getDepsTxtPath()).exists();
    }

    protected final String getBaseResourcePathString() {
        return this.baseResourcePath;
    }

    protected abstract Path getDepsTxtPath();
}

