/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.api.core.graph.predicates;

import com.datastax.dse.driver.api.core.data.geometry.LineString;
import com.datastax.dse.driver.api.core.data.geometry.Point;
import com.datastax.dse.driver.api.core.data.geometry.Polygon;
import com.datastax.dse.driver.api.core.graph.predicates.Geo;
import java.util.List;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Test;

public class GeoTest {
    @Test
    public void should_convert_units_to_degrees() {
        Assertions.assertThat((double)Geo.Unit.DEGREES.toDegrees(100.0)).isEqualTo(100.0);
        Assertions.assertThat((double)Geo.Unit.MILES.toDegrees(68.9722)).isEqualTo(0.9982455747535043);
        Assertions.assertThat((double)Geo.Unit.KILOMETERS.toDegrees(111.0)).isEqualTo(0.9982456082154465);
        Assertions.assertThat((double)Geo.Unit.METERS.toDegrees(111000.0)).isEqualTo(0.9982456082154464);
    }

    @Test
    public void should_test_if_point_is_inside_circle_with_cartesian_coordinates() {
        P inside = Geo.inside((Point)Point.fromCoordinates((double)30.0, (double)30.0), (double)14.142135623730951);
        Assertions.assertThat((boolean)inside.test((Object)Point.fromCoordinates((double)40.0, (double)40.0))).isTrue();
        Assertions.assertThat((boolean)inside.test((Object)Point.fromCoordinates((double)40.1, (double)40.0))).isFalse();
    }

    @Test
    public void should_test_if_point_is_inside_circle_with_geo_coordinates() {
        P inside = Geo.inside((Point)Point.fromCoordinates((double)30.0, (double)30.0), (double)12.908258700131379, (Geo.Unit)Geo.Unit.DEGREES);
        Assertions.assertThat((boolean)inside.test((Object)Point.fromCoordinates((double)40.0, (double)40.0))).isTrue();
        Assertions.assertThat((boolean)inside.test((Object)Point.fromCoordinates((double)40.1, (double)40.0))).isFalse();
    }

    @Test
    public void should_test_if_point_is_inside_polygon() {
        P inside = Geo.inside((Polygon)Polygon.builder().addRing(Point.fromCoordinates((double)30.0, (double)30.0), Point.fromCoordinates((double)40.0, (double)40.0), Point.fromCoordinates((double)40.0, (double)30.0), new Point[0]).build());
        Assertions.assertThat((boolean)inside.test((Object)Point.fromCoordinates((double)35.0, (double)32.0))).isTrue();
        Assertions.assertThat((boolean)inside.test((Object)Point.fromCoordinates((double)33.0, (double)37.0))).isFalse();
    }

    @Test
    public void should_build_line_string_from_coordinates() {
        LineString lineString = Geo.lineString((double[])new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0});
        ((ListAssert)Assertions.assertThat((List)lineString.getPoints()).hasSize(3)).contains((Object[])new Point[]{Point.fromCoordinates((double)1.0, (double)2.0)}).contains((Object[])new Point[]{Point.fromCoordinates((double)3.0, (double)4.0)}).contains((Object[])new Point[]{Point.fromCoordinates((double)5.0, (double)6.0)});
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_build_line_string_if_not_enough_coordinates() {
        Geo.lineString((double[])new double[]{1.0, 2.0});
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_build_line_string_if_uneven_number_of_coordinates() {
        Geo.lineString((double[])new double[]{1.0, 2.0, 3.0, 4.0, 5.0});
    }

    @Test
    public void should_build_polygon_from_coordinates() {
        Polygon polygon = Geo.polygon((double[])new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0});
        ((ListAssert)Assertions.assertThat((List)polygon.getExteriorRing()).hasSize(4)).contains((Object[])new Point[]{Point.fromCoordinates((double)1.0, (double)2.0)}).contains((Object[])new Point[]{Point.fromCoordinates((double)3.0, (double)4.0)}).contains((Object[])new Point[]{Point.fromCoordinates((double)5.0, (double)6.0)}).contains((Object[])new Point[]{Point.fromCoordinates((double)7.0, (double)8.0)});
        Assertions.assertThat((List)polygon.getInteriorRings()).isEmpty();
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_build_polygon_if_not_enough_coordinates() {
        Geo.polygon((double[])new double[]{1.0, 2.0, 3.0, 4.0});
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_build_polygon_if_uneven_number_of_coordinates() {
        Geo.polygon((double[])new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0});
    }
}

