/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.api.core.data.time;

import com.datastax.dse.driver.api.core.data.time.DateRange;
import com.datastax.oss.driver.internal.SerializationHelper;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import java.text.ParseException;
import java.time.temporal.ChronoField;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DataProviderRunner.class)
public class DateRangeTest {
    @Test
    @UseDataProvider(value="rangeStrings")
    public void should_parse_and_format(String source) throws Exception {
        DateRange parsed = DateRange.parse((String)source);
        Assertions.assertThat((String)parsed.toString()).isEqualTo(source);
    }

    @DataProvider
    public static Object[][] rangeStrings() {
        return new Object[][]{{"[2011-01 TO 2015]"}, {"[2010-01-02 TO 2015-05-05T13]"}, {"[1973-06-30T13:57:28.123Z TO 1999-05-05T14:14:59]"}, {"[2010-01-01T15 TO 2016-02]"}, {"[1500 TO 1501]"}, {"[0001 TO 0001-01-02]"}, {"[0000 TO 0000-01-02]"}, {"[-0001 TO -0001-01-02]"}, {"[* TO 2014-12-01]"}, {"[1999 TO *]"}, {"[* TO *]"}, {"0001-01-01"}, {"-0001-01-01"}, {"-0009"}, {"2000-11"}, {"*"}};
    }

    @Test
    public void should_use_proleptic_parser() throws Exception {
        DateRange parsed = DateRange.parse((String)"[0000 TO 0000-01-02]");
        Assertions.assertThat((int)parsed.getLowerBound().getTimestamp().get(ChronoField.YEAR)).isEqualTo(0);
    }

    @Test
    public void should_fail_to_parse_invalid_strings() {
        Assertions.assertThatThrownBy(() -> DateRange.parse((String)"foo")).matches(DateRangeTest.hasOffset(0));
        Assertions.assertThatThrownBy(() -> DateRange.parse((String)"[foo TO *]")).matches(DateRangeTest.hasOffset(1));
        Assertions.assertThatThrownBy(() -> DateRange.parse((String)"[* TO foo]")).matches(DateRangeTest.hasOffset(6));
    }

    private static Predicate<Throwable> hasOffset(int offset) {
        return e -> ((ParseException)e).getErrorOffset() == offset;
    }

    @Test
    public void should_fail_to_parse_inverted_range() {
        Assertions.assertThatThrownBy(() -> DateRange.parse((String)"[2001-01 TO 2000]")).hasMessage("Lower bound of a date range should be before upper bound, got: [2001-01 TO 2000]");
    }

    @Test
    public void should_not_equate_single_date_open_to_both_open_range() throws Exception {
        Assertions.assertThat((Object)DateRange.parse((String)"*")).isNotEqualTo((Object)DateRange.parse((String)"[* TO *]"));
    }

    @Test
    public void should_not_equate_same_ranges_with_different_precisions() throws ParseException {
        Assertions.assertThat((Object)DateRange.parse((String)"[2001 TO 2002]")).isNotEqualTo((Object)DateRange.parse((String)"[2001-01 TO 2002-12]"));
    }

    @Test
    public void should_give_same_hashcode_to_equal_objects() throws ParseException {
        Assertions.assertThat((int)DateRange.parse((String)"[2001 TO 2002]").hashCode()).isEqualTo(DateRange.parse((String)"[2001 TO 2002]").hashCode());
    }

    @Test
    public void should_serialize_and_deserialize() throws Exception {
        DateRange initial = DateRange.parse((String)"[1973-06-30T13:57:28.123Z TO 1999-05-05T14:14:59]");
        DateRange deserialized = SerializationHelper.serializeAndDeserialize(initial);
        Assertions.assertThat((Object)deserialized).isEqualTo((Object)initial);
    }
}

