/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.api.core.data.time;

import com.datastax.dse.driver.api.core.data.time.DateRangePrecision;
import java.time.ZonedDateTime;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class DateRangePrecisionTest {
    @Test
    public void should_round_up() {
        ZonedDateTime timestamp = ZonedDateTime.parse("2011-02-03T04:05:16.789Z");
        Assertions.assertThat((ZonedDateTime)DateRangePrecision.MILLISECOND.roundUp(timestamp)).isEqualTo("2011-02-03T04:05:16.789Z");
        Assertions.assertThat((ZonedDateTime)DateRangePrecision.SECOND.roundUp(timestamp)).isEqualTo("2011-02-03T04:05:16.999Z");
        Assertions.assertThat((ZonedDateTime)DateRangePrecision.MINUTE.roundUp(timestamp)).isEqualTo("2011-02-03T04:05:59.999Z");
        Assertions.assertThat((ZonedDateTime)DateRangePrecision.HOUR.roundUp(timestamp)).isEqualTo("2011-02-03T04:59:59.999Z");
        Assertions.assertThat((ZonedDateTime)DateRangePrecision.DAY.roundUp(timestamp)).isEqualTo("2011-02-03T23:59:59.999Z");
        Assertions.assertThat((ZonedDateTime)DateRangePrecision.MONTH.roundUp(timestamp)).isEqualTo("2011-02-28T23:59:59.999Z");
        Assertions.assertThat((ZonedDateTime)DateRangePrecision.YEAR.roundUp(timestamp)).isEqualTo("2011-12-31T23:59:59.999Z");
    }

    @Test
    public void should_round_down() {
        ZonedDateTime timestamp = ZonedDateTime.parse("2011-02-03T04:05:16.789Z");
        Assertions.assertThat((ZonedDateTime)DateRangePrecision.MILLISECOND.roundDown(timestamp)).isEqualTo("2011-02-03T04:05:16.789Z");
        Assertions.assertThat((ZonedDateTime)DateRangePrecision.SECOND.roundDown(timestamp)).isEqualTo("2011-02-03T04:05:16.000Z");
        Assertions.assertThat((ZonedDateTime)DateRangePrecision.MINUTE.roundDown(timestamp)).isEqualTo("2011-02-03T04:05:00.000Z");
        Assertions.assertThat((ZonedDateTime)DateRangePrecision.HOUR.roundDown(timestamp)).isEqualTo("2011-02-03T04:00:00.000Z");
        Assertions.assertThat((ZonedDateTime)DateRangePrecision.DAY.roundDown(timestamp)).isEqualTo("2011-02-03T00:00:00.000Z");
        Assertions.assertThat((ZonedDateTime)DateRangePrecision.MONTH.roundDown(timestamp)).isEqualTo("2011-02-01T00:00:00.000Z");
        Assertions.assertThat((ZonedDateTime)DateRangePrecision.YEAR.roundDown(timestamp)).isEqualTo("2011-01-01T00:00:00.000Z");
    }
}

