/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.session;

import com.datastax.dse.driver.internal.core.cql.continuous.ContinuousCqlRequestAsyncProcessor;
import com.datastax.dse.driver.internal.core.cql.continuous.ContinuousCqlRequestSyncProcessor;
import com.datastax.dse.driver.internal.core.cql.continuous.reactive.ContinuousCqlRequestReactiveProcessor;
import com.datastax.dse.driver.internal.core.cql.reactive.CqlRequestReactiveProcessor;
import com.datastax.dse.driver.internal.core.graph.GraphRequestAsyncProcessor;
import com.datastax.dse.driver.internal.core.graph.GraphRequestSyncProcessor;
import com.datastax.dse.driver.internal.core.graph.GraphSupportChecker;
import com.datastax.dse.driver.internal.core.graph.reactive.ReactiveGraphRequestProcessor;
import com.datastax.oss.driver.internal.core.context.DefaultDriverContext;
import com.datastax.oss.driver.internal.core.cql.CqlPrepareAsyncProcessor;
import com.datastax.oss.driver.internal.core.cql.CqlPrepareSyncProcessor;
import com.datastax.oss.driver.internal.core.cql.CqlRequestAsyncProcessor;
import com.datastax.oss.driver.internal.core.cql.CqlRequestSyncProcessor;
import com.datastax.oss.driver.internal.core.session.RequestProcessor;
import com.datastax.oss.driver.internal.core.util.DefaultDependencyChecker;
import com.datastax.oss.driver.internal.core.util.Dependency;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuiltInRequestProcessors {
    private static final Logger LOG = LoggerFactory.getLogger(BuiltInRequestProcessors.class);

    public static List<RequestProcessor<?, ?>> createDefaultProcessors(DefaultDriverContext context) {
        ArrayList processors = new ArrayList();
        BuiltInRequestProcessors.addBasicProcessors(processors, context);
        if (DefaultDependencyChecker.isPresent(Dependency.TINKERPOP)) {
            BuiltInRequestProcessors.addGraphProcessors(context, processors);
        } else {
            LOG.debug("Tinkerpop was not found on the classpath: graph extensions will not be available");
        }
        if (DefaultDependencyChecker.isPresent(Dependency.REACTIVE_STREAMS)) {
            BuiltInRequestProcessors.addReactiveProcessors(processors);
        } else {
            LOG.debug("Reactive Streams was not found on the classpath: reactive extensions will not be available");
        }
        if (DefaultDependencyChecker.isPresent(Dependency.REACTIVE_STREAMS) && DefaultDependencyChecker.isPresent(Dependency.TINKERPOP)) {
            BuiltInRequestProcessors.addGraphReactiveProcessors(context, processors);
        }
        return processors;
    }

    public static void addBasicProcessors(List<RequestProcessor<?, ?>> processors, DefaultDriverContext context) {
        CqlRequestAsyncProcessor cqlRequestAsyncProcessor = new CqlRequestAsyncProcessor();
        CqlRequestSyncProcessor cqlRequestSyncProcessor = new CqlRequestSyncProcessor(cqlRequestAsyncProcessor);
        processors.add(cqlRequestAsyncProcessor);
        processors.add(cqlRequestSyncProcessor);
        CqlPrepareAsyncProcessor cqlPrepareAsyncProcessor = new CqlPrepareAsyncProcessor(Optional.of(context));
        CqlPrepareSyncProcessor cqlPrepareSyncProcessor = new CqlPrepareSyncProcessor(cqlPrepareAsyncProcessor);
        processors.add(cqlPrepareAsyncProcessor);
        processors.add(cqlPrepareSyncProcessor);
        ContinuousCqlRequestAsyncProcessor continuousCqlRequestAsyncProcessor = new ContinuousCqlRequestAsyncProcessor();
        ContinuousCqlRequestSyncProcessor continuousCqlRequestSyncProcessor = new ContinuousCqlRequestSyncProcessor(continuousCqlRequestAsyncProcessor);
        processors.add(continuousCqlRequestAsyncProcessor);
        processors.add(continuousCqlRequestSyncProcessor);
    }

    public static void addGraphProcessors(DefaultDriverContext context, List<RequestProcessor<?, ?>> processors) {
        GraphRequestAsyncProcessor graphRequestAsyncProcessor = new GraphRequestAsyncProcessor(context, new GraphSupportChecker());
        GraphRequestSyncProcessor graphRequestSyncProcessor = new GraphRequestSyncProcessor(graphRequestAsyncProcessor);
        processors.add(graphRequestAsyncProcessor);
        processors.add(graphRequestSyncProcessor);
    }

    public static void addReactiveProcessors(List<RequestProcessor<?, ?>> processors) {
        CqlRequestReactiveProcessor cqlRequestReactiveProcessor = new CqlRequestReactiveProcessor(new CqlRequestAsyncProcessor());
        ContinuousCqlRequestReactiveProcessor continuousCqlRequestReactiveProcessor = new ContinuousCqlRequestReactiveProcessor(new ContinuousCqlRequestAsyncProcessor());
        processors.add(cqlRequestReactiveProcessor);
        processors.add(continuousCqlRequestReactiveProcessor);
    }

    public static void addGraphReactiveProcessors(DefaultDriverContext context, List<RequestProcessor<?, ?>> processors) {
        ReactiveGraphRequestProcessor reactiveGraphRequestProcessor = new ReactiveGraphRequestProcessor(new GraphRequestAsyncProcessor(context, new GraphSupportChecker()));
        processors.add(reactiveGraphRequestProcessor);
    }
}

