/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.cql;

import com.datastax.oss.driver.api.core.cql.PrepareRequest;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.internal.core.cql.DefaultPrepareRequest;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;
import java.util.Objects;

public interface SyncCqlSession
extends Session {
    @NonNull
    default public ResultSet execute(@NonNull Statement<?> statement) {
        return Objects.requireNonNull(this.execute(statement, Statement.SYNC), "The CQL processor should never return a null result");
    }

    @NonNull
    default public ResultSet execute(@NonNull String query) {
        return this.execute(SimpleStatement.newInstance(query));
    }

    @NonNull
    default public ResultSet execute(@NonNull String query, Object ... values) {
        return this.execute(SimpleStatement.newInstance(query, values));
    }

    @NonNull
    default public ResultSet execute(@NonNull String query, @NonNull Map<String, Object> values) {
        return this.execute(SimpleStatement.newInstance(query, values));
    }

    @NonNull
    default public PreparedStatement prepare(@NonNull SimpleStatement statement) {
        return Objects.requireNonNull(this.execute(new DefaultPrepareRequest(statement), PrepareRequest.SYNC), "The CQL prepare processor should never return a null result");
    }

    @NonNull
    default public PreparedStatement prepare(@NonNull String query) {
        return Objects.requireNonNull(this.execute(new DefaultPrepareRequest(query), PrepareRequest.SYNC), "The CQL prepare processor should never return a null result");
    }

    @NonNull
    default public PreparedStatement prepare(@NonNull PrepareRequest request) {
        return Objects.requireNonNull(this.execute(request, PrepareRequest.SYNC), "The CQL prepare processor should never return a null result");
    }
}

