/*
 * Decompiled with CFR 0.152.
 */
package org.github.jamm;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.Callable;

public class MemoryMeter {
    private static Instrumentation instrumentation;
    private final Callable<Set<Object>> trackerProvider;
    private final boolean includeBufferSize;

    public static void premain(String options, Instrumentation inst) {
        instrumentation = inst;
    }

    public static boolean isInitialized() {
        return instrumentation != null;
    }

    public MemoryMeter() {
        this(new Callable<Set<Object>>(){

            @Override
            public Set<Object> call() throws Exception {
                return Collections.newSetFromMap(new IdentityHashMap());
            }
        }, true);
    }

    private MemoryMeter(Callable<Set<Object>> trackerProvider, boolean includeBufferSize) {
        this.trackerProvider = trackerProvider;
        this.includeBufferSize = includeBufferSize;
    }

    public MemoryMeter withTrackerProvider(Callable<Set<Object>> trackerProvider) {
        return new MemoryMeter(trackerProvider, this.includeBufferSize);
    }

    public MemoryMeter omitSharedBufferOverhead() {
        return new MemoryMeter(this.trackerProvider, false);
    }

    public long measure(Object object) {
        if (instrumentation == null) {
            throw new IllegalStateException("Instrumentation is not set; Jamm must be set as -javaagent");
        }
        return instrumentation.getObjectSize(object);
    }

    public long measureDeep(Object object) {
        Set<Object> tracker;
        if (object == null) {
            throw new NullPointerException();
        }
        try {
            tracker = this.trackerProvider.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        tracker.add(object);
        Stack<Object> stack = new Stack<Object>();
        stack.push(object);
        long total = 0L;
        while (!stack.isEmpty()) {
            Object current = stack.pop();
            assert (current != null);
            total += this.measure(current);
            if (current instanceof Object[]) {
                this.addArrayChildren((Object[])current, stack, tracker);
                continue;
            }
            if (current instanceof ByteBuffer && !this.includeBufferSize) continue;
            this.addFieldChildren(current, stack, tracker);
        }
        return total;
    }

    public long countChildren(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Set<Object> tracker = Collections.newSetFromMap(new IdentityHashMap());
        tracker.add(object);
        Stack<Object> stack = new Stack<Object>();
        stack.push(object);
        long total = 0L;
        while (!stack.isEmpty()) {
            Object current = stack.pop();
            assert (current != null);
            ++total;
            if (current instanceof Object[]) {
                this.addArrayChildren((Object[])current, stack, tracker);
                continue;
            }
            this.addFieldChildren(current, stack, tracker);
        }
        return total;
    }

    private void addFieldChildren(Object current, Stack<Object> stack, Set<Object> tracker) {
        for (Class<?> cls = current.getClass(); cls != null; cls = cls.getSuperclass()) {
            for (Field field : cls.getDeclaredFields()) {
                Object child;
                if (field.getType().isPrimitive() || Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                try {
                    child = field.get(current);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                if (child == null || tracker.contains(child)) continue;
                stack.push(child);
                tracker.add(child);
            }
        }
    }

    private void addArrayChildren(Object[] current, Stack<Object> stack, Set<Object> tracker) {
        for (Object child : current) {
            if (child == null || tracker.contains(child)) continue;
            stack.push(child);
            tracker.add(child);
        }
    }
}

