/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.http.websocket;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.jboss.netty.handler.codec.http.websocket.DefaultWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocket.WebSocketFrame;
import org.jboss.netty.handler.codec.replay.ReplayingDecoder;
import org.jboss.netty.handler.codec.replay.VoidEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class WebSocketFrameDecoder
extends ReplayingDecoder<VoidEnum> {
    public static final int DEFAULT_MAX_FRAME_SIZE = 16384;
    private final int maxFrameSize;
    private boolean receivedClosingHandshake;

    public WebSocketFrameDecoder() {
        this(16384);
    }

    public WebSocketFrameDecoder(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, VoidEnum state) throws Exception {
        if (this.receivedClosingHandshake) {
            buffer.skipBytes(this.actualReadableBytes());
            return null;
        }
        byte type = buffer.readByte();
        if ((type & 0x80) == 128) {
            return this.decodeBinaryFrame(type, buffer);
        }
        return this.decodeTextFrame(type, buffer);
    }

    private WebSocketFrame decodeBinaryFrame(int type, ChannelBuffer buffer) throws TooLongFrameException {
        byte b;
        long frameSize = 0L;
        int lengthFieldSize = 0;
        do {
            b = buffer.readByte();
            frameSize <<= 7;
            if ((frameSize |= (long)(b & 0x7F)) > (long)this.maxFrameSize) {
                throw new TooLongFrameException();
            }
            if (++lengthFieldSize <= 8) continue;
            throw new TooLongFrameException();
        } while ((b & 0x80) == 128);
        if (type == 255 && frameSize == 0L) {
            this.receivedClosingHandshake = true;
        }
        return new DefaultWebSocketFrame(type, buffer.readBytes((int)frameSize));
    }

    private WebSocketFrame decodeTextFrame(int type, ChannelBuffer buffer) throws TooLongFrameException {
        int rbytes;
        int ridx = buffer.readerIndex();
        int delimPos = buffer.indexOf(ridx, ridx + (rbytes = this.actualReadableBytes()), (byte)-1);
        if (delimPos == -1) {
            if (rbytes > this.maxFrameSize) {
                throw new TooLongFrameException();
            }
            return null;
        }
        int frameSize = delimPos - ridx;
        if (frameSize > this.maxFrameSize) {
            throw new TooLongFrameException();
        }
        ChannelBuffer binaryData = buffer.readBytes(frameSize);
        buffer.skipBytes(1);
        return new DefaultWebSocketFrame(type, binaryData);
    }
}

