/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.thrift.util;

import com.thinkaurelius.thrift.util.mem.TMemoryInputTransport;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransport;

public class TBinaryProtocol
extends org.apache.thrift.protocol.TBinaryProtocol {
    private final TMemoryInputTransport inMemoryTransport;

    public TBinaryProtocol(TMemoryInputTransport trans, int readLength) {
        this(trans, false, true);
        if (readLength > 0) {
            this.setReadLength(readLength);
        }
    }

    public TBinaryProtocol(TMemoryInputTransport trans, boolean strictRead, boolean strictWrite) {
        super((TTransport)trans, strictRead, strictWrite);
        this.inMemoryTransport = trans;
    }

    public byte readByte() throws TException {
        return this.inMemoryTransport.readByte();
    }

    public short readI16() throws TException {
        return this.inMemoryTransport.readShort();
    }

    public int readI32() throws TException {
        return this.inMemoryTransport.readInt();
    }

    public long readI64() throws TException {
        return this.inMemoryTransport.readLong();
    }

    public double readDouble() throws TException {
        return this.inMemoryTransport.readDouble();
    }

    public String readString() throws TException {
        return this.readStringBody(this.readI32());
    }

    public String readStringBody(int size) throws TException {
        this.checkReadLength(size);
        byte[] str = new byte[size];
        this.inMemoryTransport.readFully(str);
        try {
            return new String(str, "UTF-8");
        }
        catch (UnsupportedEncodingException uex) {
            throw new TException("JVM DOES NOT SUPPORT UTF-8");
        }
    }

    public ByteBuffer readBinary() throws TException {
        int size = this.readI32();
        this.checkReadLength(size);
        return this.inMemoryTransport.readBytes(size);
    }

    private static class ExtendedTBinaryProtocol
    extends org.apache.thrift.protocol.TBinaryProtocol {
        public ExtendedTBinaryProtocol(TTransport trans) {
            super(trans);
        }

        public void writeBinary(ByteBuffer buffer) throws TException {
            this.writeI32(buffer.remaining());
            if (buffer.hasArray()) {
                this.trans_.write(buffer.array(), buffer.position() + buffer.arrayOffset(), buffer.remaining());
            } else {
                byte[] bytes = new byte[buffer.remaining()];
                int j = 0;
                for (int i = buffer.position(); i < buffer.limit(); ++i) {
                    bytes[j++] = buffer.get(i);
                }
                this.trans_.write(bytes);
            }
        }
    }

    public static class Factory
    extends TBinaryProtocol.Factory {
        public Factory() {
            super(false, true);
        }

        public Factory(boolean strictRead, boolean strictWrite) {
            super(strictRead, strictWrite, 0);
        }

        public Factory(boolean strictRead, boolean strictWrite, int readLength) {
            super(strictRead, strictWrite, readLength);
        }

        public TProtocol getProtocol(TTransport transport) {
            return transport instanceof TMemoryInputTransport ? new TBinaryProtocol((TMemoryInputTransport)transport, this.strictRead_, this.strictWrite_) : new ExtendedTBinaryProtocol(transport);
        }
    }
}

