#!/usr/bin/python
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from distutils.core import setup
from os.path import abspath, join, dirname

setup(
    name="cql",
    version="1.4.0",
    description="Cassandra Query Language driver",
    long_description=open(abspath(join(dirname(__file__), 'README'))).read(),
    maintainer='Cassandra DBAPI-2 Driver Team',
    maintainer_email='client-dev@cassandra.apache.org',
    url="http://code.google.com/a/apache-extras.org/p/cassandra-dbapi2",
    packages=["cql", "cql.cassandra"],
    install_requires=["thrift"],
    provides=["cql"],
    classifiers=[
        "Development Status :: 4 - Beta",
        "License :: OSI Approved :: Apache Software License",
        "Operating System :: OS Independent",
        "Programming Language :: Python",
        "Topic :: Database :: Front-Ends",
    ],
)
