/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.operations;

import com.yammer.metrics.core.TimerContext;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.stress.Session;
import org.apache.cassandra.stress.operations.CQLOperation;
import org.apache.cassandra.stress.util.Operation;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.CqlRow;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.ByteBufferUtil;

public class CqlIndexedRangeSlicer
extends CQLOperation {
    private static List<ByteBuffer> values = null;
    private static String cqlQuery = null;
    private int lastQueryResultSize;
    private int lastMaxKey;

    public CqlIndexedRangeSlicer(Session client, int idx) {
        super(client, idx);
    }

    @Override
    protected void run(Operation.CQLQueryExecutor executor) throws IOException {
        if (this.session.getColumnFamilyType() == ColumnFamilyType.Super) {
            throw new RuntimeException("Super columns are not implemented for CQL");
        }
        if (values == null) {
            values = this.generateValues();
        }
        if (cqlQuery == null) {
            StringBuilder query = new StringBuilder("SELECT ");
            if (this.session.cqlVersion.startsWith("2")) {
                query.append(this.session.getColumnsPerKey()).append(" ''..''");
            } else {
                query.append("*");
            }
            query.append(" FROM Standard1");
            if (this.session.cqlVersion.startsWith("2")) {
                query.append(" USING CONSISTENCY ").append(this.session.getConsistencyLevel());
            }
            query.append(" WHERE C1=").append(this.getUnQuotedCqlBlob(values.get(1).array(), this.session.cqlVersion.startsWith("3"))).append(" AND KEY > ? LIMIT ").append(this.session.getKeysPerCall());
            cqlQuery = query.toString();
        }
        String format = "%0" + this.session.getTotalKeysLength() + "d";
        String startOffset = String.format(format, 0);
        int expectedPerValue = this.session.getNumKeys() / values.size();
        for (int received = 0; received < expectedPerValue; received += this.lastQueryResultSize) {
            TimerContext context = this.session.latency.time();
            boolean success = false;
            String exceptionMessage = null;
            Object formattedQuery = null;
            List<String> queryParms = Collections.singletonList(this.getUnQuotedCqlBlob(startOffset, this.session.cqlVersion.startsWith("3")));
            for (int t = 0; t < this.session.getRetryTimes() && !success; ++t) {
                try {
                    success = executor.execute(cqlQuery, queryParms);
                    continue;
                }
                catch (Exception e) {
                    exceptionMessage = this.getExceptionMessage(e);
                    success = false;
                }
            }
            if (!success) {
                this.error(String.format("Operation [%d] retried %d times - error executing indexed range query with offset %s %s%n", this.index, this.session.getRetryTimes(), startOffset, exceptionMessage == null ? "" : "(" + exceptionMessage + ")"));
            }
            startOffset = String.format(format, 1 + this.lastMaxKey);
            this.session.operations.getAndIncrement();
            this.session.keys.getAndAdd(this.lastQueryResultSize);
            context.stop();
        }
    }

    private int getMaxKey(List<CqlRow> rows) {
        int maxKey = ByteBufferUtil.toInt((ByteBuffer)rows.get((int)0).key);
        for (CqlRow row : rows) {
            int currentKey = ByteBufferUtil.toInt((ByteBuffer)row.key);
            if (currentKey <= maxKey) continue;
            maxKey = currentKey;
        }
        return maxKey;
    }

    private int getMaxKey(ResultSet rs) {
        int maxKey = ByteBufferUtil.toInt((ByteBuffer)((ByteBuffer)((List)rs.rows.get(0)).get(0)));
        for (List row : rs.rows) {
            int currentKey = ByteBufferUtil.toInt((ByteBuffer)((ByteBuffer)row.get(0)));
            if (currentKey <= maxKey) continue;
            maxKey = currentKey;
        }
        return maxKey;
    }

    @Override
    protected boolean validateThriftResult(CqlResult result) {
        this.lastQueryResultSize = result.rows.size();
        this.lastMaxKey = this.getMaxKey(result.rows);
        return this.lastQueryResultSize != 0;
    }

    @Override
    protected boolean validateNativeResult(ResultMessage result) {
        assert (result instanceof ResultMessage.Rows);
        this.lastQueryResultSize = ((ResultMessage.Rows)result).result.size();
        this.lastMaxKey = this.getMaxKey(((ResultMessage.Rows)result).result);
        return this.lastQueryResultSize != 0;
    }
}

