/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import org.apache.cassandra.stress.server.StressThread;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class StressServer {
    private static final Options availableOptions = new Options();

    public static void main(String[] args) throws Exception {
        ServerSocket serverSocket = null;
        PosixParser parser = new PosixParser();
        InetAddress address = InetAddress.getByName("127.0.0.1");
        try {
            CommandLine cmd = parser.parse(availableOptions, args);
            if (cmd.hasOption("h")) {
                address = InetAddress.getByName(cmd.getOptionValue("h"));
            }
        }
        catch (ParseException e) {
            System.err.printf("Usage: ./bin/stressd start|stop|status [-h <host>]", new Object[0]);
            System.exit(1);
        }
        try {
            serverSocket = new ServerSocket(2159, 0, address);
        }
        catch (IOException e) {
            System.err.printf("Could not listen on port: %s:2159.%n", address.getHostAddress());
            System.exit(1);
        }
        while (true) {
            new StressThread(serverSocket.accept()).start();
        }
    }

    static {
        availableOptions.addOption("h", "host", true, "Host to listen for connections.");
    }
}

