/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress;

import com.google.common.util.concurrent.RateLimiter;
import com.google.common.util.concurrent.Uninterruptibles;
import com.yammer.metrics.stats.Snapshot;
import java.io.PrintStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.stress.Session;
import org.apache.cassandra.stress.Stress;
import org.apache.cassandra.stress.StressStatistics;
import org.apache.cassandra.stress.operations.CounterAdder;
import org.apache.cassandra.stress.operations.CounterGetter;
import org.apache.cassandra.stress.operations.CqlCounterAdder;
import org.apache.cassandra.stress.operations.CqlCounterGetter;
import org.apache.cassandra.stress.operations.CqlIndexedRangeSlicer;
import org.apache.cassandra.stress.operations.CqlInserter;
import org.apache.cassandra.stress.operations.CqlMultiGetter;
import org.apache.cassandra.stress.operations.CqlRangeSlicer;
import org.apache.cassandra.stress.operations.CqlReader;
import org.apache.cassandra.stress.operations.IndexedRangeSlicer;
import org.apache.cassandra.stress.operations.Inserter;
import org.apache.cassandra.stress.operations.MultiGetter;
import org.apache.cassandra.stress.operations.RangeSlicer;
import org.apache.cassandra.stress.operations.Reader;
import org.apache.cassandra.stress.util.CassandraClient;
import org.apache.cassandra.stress.util.Operation;
import org.apache.cassandra.transport.SimpleClient;

public class StressAction
extends Thread {
    private final BlockingQueue<Operation> operations = new SynchronousQueue<Operation>(true);
    private final Session client;
    private final PrintStream output;
    private volatile boolean stop = false;
    public static final int SUCCESS = 0;
    public static final int FAILURE = 1;
    private volatile int returnCode = -1;

    public StressAction(Session session, PrintStream out) {
        this.client = session;
        this.output = out;
    }

    @Override
    public void run() {
        if (this.client.getOperation() == Stress.Operations.INSERT || this.client.getOperation() == Stress.Operations.COUNTER_ADD) {
            this.client.createKeySpaces();
        }
        int threadCount = this.client.getThreads();
        Consumer[] consumers = new Consumer[threadCount];
        this.output.println("total,interval_op_rate,interval_key_rate,latency,95th,99th,elapsed_time");
        int itemsPerThread = this.client.getKeysPerThread();
        int modulo = this.client.getNumKeys() % threadCount;
        RateLimiter rateLimiter = RateLimiter.create((double)this.client.getMaxOpsPerSecond());
        for (int i = 0; i < threadCount; ++i) {
            if (i == threadCount - 1) {
                itemsPerThread += modulo;
            }
            consumers[i] = new Consumer(itemsPerThread, rateLimiter);
        }
        Producer producer = new Producer();
        producer.start();
        for (int i = 0; i < threadCount; ++i) {
            consumers[i].start();
        }
        boolean terminate = false;
        int keyCount = 0;
        int total = 0;
        int epoch = 0;
        int interval = this.client.getProgressInterval();
        int epochIntervals = this.client.getProgressInterval() * 10;
        long testStartTime = System.nanoTime();
        StressStatistics stats = new StressStatistics(this.client, this.output);
        while (!terminate) {
            if (this.stop) {
                producer.stopProducer();
                for (Consumer consumer : consumers) {
                    consumer.stopConsume();
                }
                break;
            }
            Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
            int alive = 0;
            for (Consumer thread : consumers) {
                if (!thread.isAlive()) continue;
                ++alive;
            }
            if (alive == 0) {
                terminate = true;
            }
            if (!terminate && ++epoch <= epochIntervals) continue;
            epoch = 0;
            int oldTotal = total;
            int oldKeyCount = keyCount;
            total = this.client.operations.get();
            keyCount = this.client.keys.get();
            Snapshot latency = this.client.latency.getSnapshot();
            int opDelta = total - oldTotal;
            int keyDelta = keyCount - oldKeyCount;
            long currentTimeInSeconds = TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - testStartTime);
            this.output.println(String.format("%d,%d,%d,%.1f,%.1f,%.1f,%d", total, opDelta / interval, keyDelta / interval, latency.getMedian(), latency.get95thPercentile(), latency.get999thPercentile(), currentTimeInSeconds));
            if (!this.client.outputStatistics()) continue;
            stats.addIntervalStats(total, opDelta / interval, keyDelta / interval, latency, currentTimeInSeconds);
        }
        this.returnCode = 0;
        if (producer.isAlive()) {
            producer.interrupt();
            this.returnCode = 1;
        }
        for (Consumer consumer : consumers) {
            if (consumer.getReturnCode() != 1) continue;
            this.returnCode = 1;
        }
        if (this.returnCode == 0) {
            if (this.client.outputStatistics()) {
                stats.printStats();
            }
            this.output.println("END");
        } else {
            this.output.println("FAILURE");
        }
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    private Operation createOperation(int index) {
        switch (this.client.getOperation()) {
            case READ: {
                return this.client.isCQL() ? new CqlReader(this.client, index) : new Reader(this.client, index);
            }
            case COUNTER_GET: {
                return this.client.isCQL() ? new CqlCounterGetter(this.client, index) : new CounterGetter(this.client, index);
            }
            case INSERT: {
                return this.client.isCQL() ? new CqlInserter(this.client, index) : new Inserter(this.client, index);
            }
            case COUNTER_ADD: {
                return this.client.isCQL() ? new CqlCounterAdder(this.client, index) : new CounterAdder(this.client, index);
            }
            case RANGE_SLICE: {
                return this.client.isCQL() ? new CqlRangeSlicer(this.client, index) : new RangeSlicer(this.client, index);
            }
            case INDEXED_RANGE_SLICE: {
                return this.client.isCQL() ? new CqlIndexedRangeSlicer(this.client, index) : new IndexedRangeSlicer(this.client, index);
            }
            case MULTI_GET: {
                return this.client.isCQL() ? new CqlMultiGetter(this.client, index) : new MultiGetter(this.client, index);
            }
        }
        throw new UnsupportedOperationException();
    }

    public void stopAction() {
        this.stop = true;
    }

    private class Consumer
    extends Thread {
        private final int items;
        private final RateLimiter rateLimiter;
        private volatile boolean stop = false;
        private volatile int returnCode = 0;

        public Consumer(int toConsume, RateLimiter rateLimiter) {
            this.items = toConsume;
            this.rateLimiter = rateLimiter;
        }

        @Override
        public void run() {
            if (((StressAction)StressAction.this).client.use_native_protocol) {
                SimpleClient connection = StressAction.this.client.getNativeClient();
                for (int i = 0; i < this.items && !this.stop; ++i) {
                    try {
                        this.rateLimiter.acquire();
                        ((Operation)StressAction.this.operations.take()).run(connection);
                        continue;
                    }
                    catch (Exception e) {
                        if (StressAction.this.output == null) {
                            System.err.println(e.getMessage());
                            this.returnCode = 1;
                            System.exit(-1);
                        }
                        StressAction.this.output.println(e.getMessage());
                        this.returnCode = 1;
                        break;
                    }
                }
            } else {
                CassandraClient connection = StressAction.this.client.getClient();
                for (int i = 0; i < this.items && !this.stop; ++i) {
                    try {
                        this.rateLimiter.acquire();
                        ((Operation)StressAction.this.operations.take()).run(connection);
                        continue;
                    }
                    catch (Exception e) {
                        if (StressAction.this.output == null) {
                            System.err.println(e.getMessage());
                            this.returnCode = 1;
                            System.exit(-1);
                        }
                        StressAction.this.output.println(e.getMessage());
                        this.returnCode = 1;
                        break;
                    }
                }
            }
        }

        public void stopConsume() {
            this.stop = true;
        }

        public int getReturnCode() {
            return this.returnCode;
        }
    }

    private class Producer
    extends Thread {
        private volatile boolean stop = false;

        private Producer() {
        }

        @Override
        public void run() {
            for (int i = 0; i < StressAction.this.client.getNumKeys() && !this.stop; ++i) {
                try {
                    StressAction.this.operations.put(StressAction.this.createOperation(i % StressAction.this.client.getNumDifferentKeys()));
                    continue;
                }
                catch (InterruptedException e) {
                    if (e.getMessage() != null) {
                        System.err.println("Producer error - " + e.getMessage());
                    }
                    return;
                }
            }
        }

        public void stopProducer() {
            this.stop = true;
        }
    }
}

