/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.thrift;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.service.CassandraDaemon;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.CassandraServer;
import org.apache.cassandra.thrift.TServerCustomFactory;
import org.apache.cassandra.thrift.TServerFactory;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.server.TServer;
import org.apache.thrift.transport.TFramedTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftServer
implements CassandraDaemon.Server {
    private static Logger logger = LoggerFactory.getLogger(ThriftServer.class);
    static final String SYNC = "sync";
    static final String ASYNC = "async";
    static final String HSHA = "hsha";
    private final InetAddress address;
    private final int port;
    private volatile ThriftServerThread server;

    public ThriftServer(InetAddress address, int port) {
        this.address = address;
        this.port = port;
    }

    @Override
    public void start() {
        if (this.server == null) {
            this.server = new ThriftServerThread(this.address, this.port);
            this.server.start();
        }
    }

    @Override
    public void stop() {
        if (this.server != null) {
            this.server.stopServer();
            try {
                this.server.join();
            }
            catch (InterruptedException e) {
                logger.error("Interrupted while waiting thrift server to stop", (Throwable)e);
            }
            this.server = null;
        }
    }

    @Override
    public boolean isRunning() {
        return this.server != null;
    }

    private static class ThriftServerThread
    extends Thread {
        private TServer serverEngine;

        public ThriftServerThread(InetAddress listenAddr, int listenPort) {
            logger.info(String.format("Binding thrift service to %s:%s", listenAddr, listenPort));
            TServerFactory.Args args = new TServerFactory.Args();
            args.tProtocolFactory = new TBinaryProtocol.Factory(true, true);
            args.addr = new InetSocketAddress(listenAddr, listenPort);
            args.cassandraServer = new CassandraServer();
            args.processor = new Cassandra.Processor((Cassandra.Iface)args.cassandraServer);
            args.keepAlive = DatabaseDescriptor.getRpcKeepAlive();
            args.sendBufferSize = DatabaseDescriptor.getRpcSendBufferSize();
            args.recvBufferSize = DatabaseDescriptor.getRpcRecvBufferSize();
            int tFramedTransportSize = DatabaseDescriptor.getThriftFramedTransportSize();
            logger.info("Using TFramedTransport with a max frame size of {} bytes.", (Object)tFramedTransportSize);
            args.inTransportFactory = new TFramedTransport.Factory(tFramedTransportSize);
            args.outTransportFactory = new TFramedTransport.Factory(tFramedTransportSize);
            this.serverEngine = new TServerCustomFactory(DatabaseDescriptor.getRpcServerType()).buildTServer(args);
        }

        @Override
        public void run() {
            logger.info("Listening for thrift clients...");
            this.serverEngine.serve();
        }

        public void stopServer() {
            logger.info("Stop listening to thrift clients");
            this.serverEngine.stop();
        }
    }
}

