/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hadoop.pig;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.marshal.AbstractCompositeType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.hadoop.pig.AbstractCassandraStorage;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.ColumnDef;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.Deletion;
import org.apache.cassandra.thrift.IndexClause;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.cassandra.thrift.IndexOperator;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.thrift.SchemaDisagreementException;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;
import org.apache.cassandra.thrift.SuperColumn;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Hex;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.pig.Expression;
import org.apache.pig.ResourceSchema;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.data.DataType;
import org.apache.pig.data.DefaultDataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.util.UDFContext;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraStorage
extends AbstractCassandraStorage {
    public static final String PIG_ALLOW_DELETES = "PIG_ALLOW_DELETES";
    public static final String PIG_WIDEROW_INPUT = "PIG_WIDEROW_INPUT";
    public static final String PIG_USE_SECONDARY = "PIG_USE_SECONDARY";
    private static final ByteBuffer BOUND = ByteBufferUtil.EMPTY_BYTE_BUFFER;
    private static final Logger logger = LoggerFactory.getLogger(CassandraStorage.class);
    private ByteBuffer slice_start = BOUND;
    private ByteBuffer slice_end = BOUND;
    private boolean slice_reverse = false;
    private boolean allow_deletes = false;
    private RecordReader<ByteBuffer, Map<ByteBuffer, Column>> reader;
    private RecordWriter<ByteBuffer, List<Mutation>> writer;
    private boolean widerows = false;
    private int limit;
    private ByteBuffer lastKey;
    private Map<ByteBuffer, Column> lastRow;
    private boolean hasNext = true;

    public CassandraStorage() {
        this(1024);
    }

    public CassandraStorage(int limit) {
        this.limit = limit;
        this.DEFAULT_INPUT_FORMAT = "org.apache.cassandra.hadoop.ColumnFamilyInputFormat";
        this.DEFAULT_OUTPUT_FORMAT = "org.apache.cassandra.hadoop.ColumnFamilyOutputFormat";
    }

    public int getLimit() {
        return this.limit;
    }

    public void prepareToRead(RecordReader reader, PigSplit split) {
        this.reader = reader;
    }

    public Tuple getNextWide() throws IOException {
        CfDef cfDef = this.getCfDef(this.loadSignature);
        ByteBuffer key = null;
        Tuple tuple = null;
        DefaultDataBag bag = new DefaultDataBag();
        try {
            block2: while (true) {
                this.hasNext = this.reader.nextKeyValue();
                if (!this.hasNext) {
                    if (tuple == null) {
                        tuple = TupleFactory.getInstance().newTuple();
                    }
                    if (this.lastRow != null) {
                        if (tuple.size() == 0) {
                            key = (ByteBuffer)this.reader.getCurrentKey();
                            tuple = this.keyToTuple(key, cfDef, this.parseType(cfDef.getKey_validation_class()));
                        }
                        for (Map.Entry<ByteBuffer, Column> entry : this.lastRow.entrySet()) {
                            bag.add(this.columnToTuple(entry.getValue(), cfDef, this.parseType(cfDef.getComparator_type())));
                        }
                        this.lastKey = null;
                        this.lastRow = null;
                        tuple.append((Object)bag);
                        return tuple;
                    }
                    if (tuple.size() == 1) {
                        tuple.append((Object)bag);
                        return tuple;
                    }
                    return null;
                }
                if (key != null && !((ByteBuffer)this.reader.getCurrentKey()).equals(key)) {
                    this.lastKey = (ByteBuffer)this.reader.getCurrentKey();
                    this.lastRow = (SortedMap)this.reader.getCurrentValue();
                    tuple.append((Object)bag);
                    return tuple;
                }
                if (key == null) {
                    key = (ByteBuffer)this.reader.getCurrentKey();
                    if (this.lastKey != null && !key.equals(this.lastKey)) {
                        if (tuple == null) {
                            tuple = this.keyToTuple(this.lastKey, cfDef, this.parseType(cfDef.getKey_validation_class()));
                        } else {
                            this.addKeyToTuple(tuple, this.lastKey, cfDef, this.parseType(cfDef.getKey_validation_class()));
                        }
                        for (Map.Entry<ByteBuffer, Column> entry : this.lastRow.entrySet()) {
                            bag.add(this.columnToTuple(entry.getValue(), cfDef, this.parseType(cfDef.getComparator_type())));
                        }
                        tuple.append((Object)bag);
                        this.lastKey = key;
                        this.lastRow = (SortedMap)this.reader.getCurrentValue();
                        return tuple;
                    }
                    if (tuple == null) {
                        tuple = this.keyToTuple(key, cfDef, this.parseType(cfDef.getKey_validation_class()));
                    } else {
                        this.addKeyToTuple(tuple, this.lastKey, cfDef, this.parseType(cfDef.getKey_validation_class()));
                    }
                }
                SortedMap row = (SortedMap)this.reader.getCurrentValue();
                if (this.lastRow != null) {
                    for (Map.Entry<Object, Object> entry : this.lastRow.entrySet()) {
                        bag.add(this.columnToTuple((Column)entry.getValue(), cfDef, this.parseType(cfDef.getComparator_type())));
                    }
                    this.lastKey = null;
                    this.lastRow = null;
                }
                Iterator<Map.Entry<Object, Object>> i$ = row.entrySet().iterator();
                while (true) {
                    if (!i$.hasNext()) continue block2;
                    Map.Entry<Object, Object> entry = i$.next();
                    bag.add(this.columnToTuple((Column)entry.getValue(), cfDef, this.parseType(cfDef.getComparator_type())));
                }
                break;
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e.getMessage());
        }
    }

    public Tuple getNext() throws IOException {
        if (this.widerows) {
            return this.getNextWide();
        }
        try {
            if (!this.reader.nextKeyValue()) {
                return null;
            }
            CfDef cfDef = this.getCfDef(this.loadSignature);
            ByteBuffer key = (ByteBuffer)this.reader.getCurrentKey();
            Map cf = (Map)this.reader.getCurrentValue();
            assert (key != null && cf != null);
            Tuple tuple = this.keyToTuple(key, cfDef, this.parseType(cfDef.getKey_validation_class()));
            DefaultDataBag bag = new DefaultDataBag();
            HashMap<ByteBuffer, Boolean> added = new HashMap<ByteBuffer, Boolean>();
            for (ColumnDef columnDef : cfDef.column_metadata) {
                if (cf.containsKey(columnDef.name)) {
                    tuple.append((Object)this.columnToTuple((Column)cf.get(columnDef.name), cfDef, this.parseType(cfDef.getComparator_type())));
                } else {
                    tuple.append((Object)TupleFactory.getInstance().newTuple());
                }
                added.put(columnDef.name, true);
            }
            for (Map.Entry entry : cf.entrySet()) {
                if (added.containsKey(entry.getKey())) continue;
                bag.add(this.columnToTuple((Column)entry.getValue(), cfDef, this.parseType(cfDef.getComparator_type())));
            }
            tuple.append((Object)bag);
            if (this.usePartitionFilter) {
                for (ColumnDef columnDef : this.getIndexes()) {
                    Tuple throwaway = this.columnToTuple((Column)cf.get(columnDef.name), cfDef, this.parseType(cfDef.getComparator_type()));
                    tuple.append(throwaway.get(1));
                }
            }
            return tuple;
        }
        catch (InterruptedException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    protected void setConnectionInformation() throws IOException {
        super.setConnectionInformation();
        if (System.getenv(PIG_ALLOW_DELETES) != null) {
            this.allow_deletes = Boolean.parseBoolean(System.getenv(PIG_ALLOW_DELETES));
        }
    }

    public void setLocation(String location, Job job) throws IOException {
        this.conf = job.getConfiguration();
        this.setLocationFromUri(location);
        if (ConfigHelper.getInputSlicePredicate(this.conf) == null) {
            SliceRange range = new SliceRange(this.slice_start, this.slice_end, this.slice_reverse, this.limit);
            SlicePredicate predicate = new SlicePredicate().setSlice_range(range);
            ConfigHelper.setInputSlicePredicate(this.conf, predicate);
        }
        if (System.getenv(PIG_WIDEROW_INPUT) != null) {
            this.widerows = Boolean.parseBoolean(System.getenv(PIG_WIDEROW_INPUT));
        }
        if (System.getenv(PIG_USE_SECONDARY) != null) {
            this.usePartitionFilter = Boolean.parseBoolean(System.getenv(PIG_USE_SECONDARY));
        }
        if (System.getenv("PIG_INPUT_SPLIT_SIZE") != null) {
            try {
                ConfigHelper.setInputSplitSize(this.conf, Integer.parseInt(System.getenv("PIG_INPUT_SPLIT_SIZE")));
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("PIG_INPUT_SPLIT_SIZE is not a number", e);
            }
        }
        if (this.usePartitionFilter && this.getIndexExpressions() != null) {
            ConfigHelper.setInputRange(this.conf, this.getIndexExpressions());
        }
        if (this.username != null && this.password != null) {
            ConfigHelper.setInputKeyspaceUserNameAndPassword(this.conf, this.username, this.password);
        }
        if (this.splitSize > 0) {
            ConfigHelper.setInputSplitSize(this.conf, this.splitSize);
        }
        if (this.partitionerClass != null) {
            ConfigHelper.setInputPartitioner(this.conf, this.partitionerClass);
        }
        ConfigHelper.setInputColumnFamily(this.conf, this.keyspace, this.column_family, this.widerows);
        this.setConnectionInformation();
        if (ConfigHelper.getInputRpcPort(this.conf) == 0) {
            throw new IOException("PIG_INPUT_RPC_PORT or PIG_RPC_PORT environment variable not set");
        }
        if (ConfigHelper.getInputInitialAddress(this.conf) == null) {
            throw new IOException("PIG_INPUT_INITIAL_ADDRESS or PIG_INITIAL_ADDRESS environment variable not set");
        }
        if (ConfigHelper.getInputPartitioner(this.conf) == null) {
            throw new IOException("PIG_INPUT_PARTITIONER or PIG_PARTITIONER environment variable not set");
        }
        if (this.loadSignature == null) {
            this.loadSignature = location;
        }
        this.initSchema(this.loadSignature);
    }

    public void setStoreLocation(String location, Job job) throws IOException {
        this.conf = job.getConfiguration();
        this.conf.setBoolean("pig.noSplitCombination", true);
        this.setLocationFromUri(location);
        if (this.username != null && this.password != null) {
            ConfigHelper.setOutputKeyspaceUserNameAndPassword(this.conf, this.username, this.password);
        }
        if (this.splitSize > 0) {
            ConfigHelper.setInputSplitSize(this.conf, this.splitSize);
        }
        if (this.partitionerClass != null) {
            ConfigHelper.setOutputPartitioner(this.conf, this.partitionerClass);
        }
        ConfigHelper.setOutputColumnFamily(this.conf, this.keyspace, this.column_family);
        this.setConnectionInformation();
        if (ConfigHelper.getOutputRpcPort(this.conf) == 0) {
            throw new IOException("PIG_OUTPUT_RPC_PORT or PIG_RPC_PORT environment variable not set");
        }
        if (ConfigHelper.getOutputInitialAddress(this.conf) == null) {
            throw new IOException("PIG_OUTPUT_INITIAL_ADDRESS or PIG_INITIAL_ADDRESS environment variable not set");
        }
        if (ConfigHelper.getOutputPartitioner(this.conf) == null) {
            throw new IOException("PIG_OUTPUT_PARTITIONER or PIG_PARTITIONER environment variable not set");
        }
        if (System.getenv(PIG_USE_SECONDARY) != null) {
            this.usePartitionFilter = Boolean.parseBoolean(System.getenv(PIG_USE_SECONDARY));
        }
        this.initSchema(this.storeSignature);
    }

    public ResourceSchema getSchema(String location, Job job) throws IOException {
        this.setLocation(location, job);
        CfDef cfDef = this.getCfDef(this.loadSignature);
        if (cfDef.column_type.equals("Super")) {
            return null;
        }
        ResourceSchema schema = new ResourceSchema();
        Map<AbstractCassandraStorage.MarshallerType, AbstractType> marshallers = this.getDefaultMarshallers(cfDef);
        Map<ByteBuffer, AbstractType> validators = this.getValidatorMap(cfDef);
        ResourceSchema.ResourceFieldSchema keyFieldSchema = new ResourceSchema.ResourceFieldSchema();
        keyFieldSchema.setName("key");
        keyFieldSchema.setType(this.getPigType(marshallers.get((Object)AbstractCassandraStorage.MarshallerType.KEY_VALIDATOR)));
        ResourceSchema bagSchema = new ResourceSchema();
        ResourceSchema.ResourceFieldSchema bagField = new ResourceSchema.ResourceFieldSchema();
        bagField.setType((byte)120);
        bagField.setName("columns");
        ResourceSchema bagTupleSchema = new ResourceSchema();
        ResourceSchema.ResourceFieldSchema bagTupleField = new ResourceSchema.ResourceFieldSchema();
        bagTupleField.setType((byte)110);
        ResourceSchema.ResourceFieldSchema bagcolSchema = new ResourceSchema.ResourceFieldSchema();
        ResourceSchema.ResourceFieldSchema bagvalSchema = new ResourceSchema.ResourceFieldSchema();
        bagcolSchema.setName("name");
        bagvalSchema.setName("value");
        bagcolSchema.setType(this.getPigType(marshallers.get((Object)AbstractCassandraStorage.MarshallerType.COMPARATOR)));
        bagvalSchema.setType(this.getPigType(marshallers.get((Object)AbstractCassandraStorage.MarshallerType.DEFAULT_VALIDATOR)));
        bagTupleSchema.setFields(new ResourceSchema.ResourceFieldSchema[]{bagcolSchema, bagvalSchema});
        bagTupleField.setSchema(bagTupleSchema);
        bagSchema.setFields(new ResourceSchema.ResourceFieldSchema[]{bagTupleField});
        bagField.setSchema(bagSchema);
        ArrayList<ResourceSchema.ResourceFieldSchema> allSchemaFields = new ArrayList<ResourceSchema.ResourceFieldSchema>();
        allSchemaFields.add(keyFieldSchema);
        if (!this.widerows) {
            for (ColumnDef cdef : cfDef.column_metadata) {
                ResourceSchema innerTupleSchema = new ResourceSchema();
                ResourceSchema.ResourceFieldSchema innerTupleField = new ResourceSchema.ResourceFieldSchema();
                innerTupleField.setType((byte)110);
                innerTupleField.setSchema(innerTupleSchema);
                innerTupleField.setName(new String(cdef.getName()));
                ResourceSchema.ResourceFieldSchema idxColSchema = new ResourceSchema.ResourceFieldSchema();
                idxColSchema.setName("name");
                idxColSchema.setType(this.getPigType(marshallers.get((Object)AbstractCassandraStorage.MarshallerType.COMPARATOR)));
                ResourceSchema.ResourceFieldSchema valSchema = new ResourceSchema.ResourceFieldSchema();
                AbstractType validator = validators.get(cdef.name);
                if (validator == null) {
                    validator = marshallers.get((Object)AbstractCassandraStorage.MarshallerType.DEFAULT_VALIDATOR);
                }
                valSchema.setName("value");
                valSchema.setType(this.getPigType(validator));
                innerTupleSchema.setFields(new ResourceSchema.ResourceFieldSchema[]{idxColSchema, valSchema});
                allSchemaFields.add(innerTupleField);
            }
        }
        allSchemaFields.add(bagField);
        if (this.usePartitionFilter) {
            for (ColumnDef cdef : this.getIndexes()) {
                ResourceSchema.ResourceFieldSchema idxSchema = new ResourceSchema.ResourceFieldSchema();
                idxSchema.setName("index_" + new String(cdef.getName()));
                AbstractType validator = validators.get(cdef.name);
                if (validator == null) {
                    validator = marshallers.get((Object)AbstractCassandraStorage.MarshallerType.DEFAULT_VALIDATOR);
                }
                idxSchema.setType(this.getPigType(validator));
                allSchemaFields.add(idxSchema);
            }
        }
        schema.setFields(allSchemaFields.toArray(new ResourceSchema.ResourceFieldSchema[allSchemaFields.size()]));
        return schema;
    }

    public void setPartitionFilter(Expression partitionFilter) {
        UDFContext context = UDFContext.getUDFContext();
        Properties property = context.getUDFProperties(AbstractCassandraStorage.class);
        property.setProperty("cassandra.partition.filter", CassandraStorage.indexExpressionsToString(this.filterToIndexExpressions(partitionFilter)));
    }

    public void prepareToWrite(RecordWriter writer) {
        this.writer = writer;
    }

    public void putNext(Tuple t) throws IOException {
        if (t.size() < 1) {
            logger.warn("Empty output skipped, filter empty tuples to suppress this warning");
            return;
        }
        ByteBuffer key = this.objToBB(t.get(0));
        if (t.getType(1) == 110) {
            this.writeColumnsFromTuple(key, t, 1);
        } else if (t.getType(1) == 120) {
            if (t.size() > 2) {
                throw new IOException("No arguments allowed after bag");
            }
            this.writeColumnsFromBag(key, (DefaultDataBag)t.get(1));
        } else {
            throw new IOException("Second argument in output must be a tuple or bag");
        }
    }

    private void writeColumnsFromTuple(ByteBuffer key, Tuple t, int offset) throws IOException {
        ArrayList<Mutation> mutationList = new ArrayList<Mutation>();
        for (int i = offset; i < t.size(); ++i) {
            if (t.getType(i) == 120) {
                this.writeColumnsFromBag(key, (DefaultDataBag)t.get(i));
                continue;
            }
            if (t.getType(i) == 110) {
                Tuple inner = (Tuple)t.get(i);
                if (inner.size() <= 0) continue;
                mutationList.add(this.mutationFromTuple(inner));
                continue;
            }
            if (this.usePartitionFilter) continue;
            throw new IOException("Output type was not a bag or a tuple");
        }
        if (mutationList.size() > 0) {
            this.writeMutations(key, mutationList);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Mutation mutationFromTuple(Tuple t) throws IOException {
        Mutation mutation = new Mutation();
        if (t.get(1) == null) {
            if (!this.allow_deletes) throw new IOException("null found but deletes are disabled, set PIG_ALLOW_DELETES=true in environment or allow_deletes=true in URL to enable");
            mutation.deletion = new Deletion();
            mutation.deletion.predicate = new SlicePredicate();
            mutation.deletion.predicate.column_names = Arrays.asList(this.objToBB(t.get(0)));
            mutation.deletion.setTimestamp(FBUtilities.timestampMicros());
            return mutation;
        } else {
            org.apache.cassandra.thrift.Column column = new org.apache.cassandra.thrift.Column();
            column.setName(this.objToBB(t.get(0)));
            column.setValue(this.objToBB(t.get(1)));
            column.setTimestamp(FBUtilities.timestampMicros());
            mutation.column_or_supercolumn = new ColumnOrSuperColumn();
            mutation.column_or_supercolumn.column = column;
        }
        return mutation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeColumnsFromBag(ByteBuffer key, DefaultDataBag bag) throws IOException {
        ArrayList<Mutation> mutationList = new ArrayList<Mutation>();
        for (Tuple pair : bag) {
            Mutation mutation = new Mutation();
            if (DataType.findType((Object)pair.get(1)) == 120) {
                SuperColumn sc = new SuperColumn();
                sc.setName(this.objToBB(pair.get(0)));
                ArrayList<org.apache.cassandra.thrift.Column> columns = new ArrayList<org.apache.cassandra.thrift.Column>();
                for (Tuple subcol : (DefaultDataBag)pair.get(1)) {
                    org.apache.cassandra.thrift.Column column = new org.apache.cassandra.thrift.Column();
                    column.setName(this.objToBB(subcol.get(0)));
                    column.setValue(this.objToBB(subcol.get(1)));
                    column.setTimestamp(FBUtilities.timestampMicros());
                    columns.add(column);
                }
                if (columns.isEmpty()) {
                    if (!this.allow_deletes) throw new IOException("SuperColumn deletion attempted with empty bag, but deletes are disabled, set PIG_ALLOW_DELETES=true in environment or allow_deletes=true in URL to enable");
                    mutation.deletion = new Deletion();
                    mutation.deletion.super_column = this.objToBB(pair.get(0));
                    mutation.deletion.setTimestamp(FBUtilities.timestampMicros());
                } else {
                    sc.columns = columns;
                    mutation.column_or_supercolumn = new ColumnOrSuperColumn();
                    mutation.column_or_supercolumn.super_column = sc;
                }
            } else {
                mutation = this.mutationFromTuple(pair);
            }
            mutationList.add(mutation);
            if (mutationList.size() < 10) continue;
            this.writeMutations(key, mutationList);
            mutationList.clear();
        }
        if (mutationList.size() <= 0) return;
        this.writeMutations(key, mutationList);
    }

    private void writeMutations(ByteBuffer key, List<Mutation> mutations) throws IOException {
        try {
            this.writer.write((Object)key, mutations);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    private List<IndexExpression> filterToIndexExpressions(Expression expression) {
        ArrayList<IndexExpression> indexExpressions = new ArrayList<IndexExpression>();
        Expression.BinaryExpression be = (Expression.BinaryExpression)expression;
        ByteBuffer name = ByteBuffer.wrap(be.getLhs().toString().getBytes());
        ByteBuffer value = ByteBuffer.wrap(be.getRhs().toString().getBytes());
        switch (expression.getOpType()) {
            case OP_EQ: {
                indexExpressions.add(new IndexExpression(name, IndexOperator.EQ, value));
                break;
            }
            case OP_GE: {
                indexExpressions.add(new IndexExpression(name, IndexOperator.GTE, value));
                break;
            }
            case OP_GT: {
                indexExpressions.add(new IndexExpression(name, IndexOperator.GT, value));
                break;
            }
            case OP_LE: {
                indexExpressions.add(new IndexExpression(name, IndexOperator.LTE, value));
                break;
            }
            case OP_LT: {
                indexExpressions.add(new IndexExpression(name, IndexOperator.LT, value));
                break;
            }
            case OP_AND: {
                indexExpressions.addAll(this.filterToIndexExpressions(be.getLhs()));
                indexExpressions.addAll(this.filterToIndexExpressions(be.getRhs()));
                break;
            }
            default: {
                throw new RuntimeException("Unsupported expression type: " + expression.getOpType().name());
            }
        }
        return indexExpressions;
    }

    private static String indexExpressionsToString(List<IndexExpression> indexExpressions) {
        assert (indexExpressions != null);
        IndexClause indexClause = new IndexClause();
        indexClause.setExpressions(indexExpressions);
        indexClause.setStart_key("".getBytes());
        TSerializer serializer = new TSerializer((TProtocolFactory)new TBinaryProtocol.Factory());
        try {
            return Hex.bytesToHex(serializer.serialize((TBase)indexClause));
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<IndexExpression> indexExpressionsFromString(String ie) {
        assert (ie != null);
        TDeserializer deserializer = new TDeserializer((TProtocolFactory)new TBinaryProtocol.Factory());
        IndexClause indexClause = new IndexClause();
        try {
            deserializer.deserialize((TBase)indexClause, Hex.hexToBytes(ie));
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
        return indexClause.getExpressions();
    }

    private List<IndexExpression> getIndexExpressions() {
        UDFContext context = UDFContext.getUDFContext();
        Properties property = context.getUDFProperties(AbstractCassandraStorage.class);
        if (property.getProperty("cassandra.partition.filter") != null) {
            return CassandraStorage.indexExpressionsFromString(property.getProperty("cassandra.partition.filter"));
        }
        return null;
    }

    @Override
    protected List<ColumnDef> getColumnMetadata(Cassandra.Client client, boolean cql3Table) throws InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, TException, CharacterCodingException {
        if (cql3Table) {
            return new ArrayList<ColumnDef>();
        }
        return this.getColumnMeta(client);
    }

    private Tuple keyToTuple(ByteBuffer key, CfDef cfDef, AbstractType comparator) throws IOException {
        Tuple tuple = TupleFactory.getInstance().newTuple(1);
        this.addKeyToTuple(tuple, key, cfDef, comparator);
        return tuple;
    }

    private void addKeyToTuple(Tuple tuple, ByteBuffer key, CfDef cfDef, AbstractType comparator) throws IOException {
        if (comparator instanceof AbstractCompositeType) {
            this.setTupleValue(tuple, 0, this.composeComposite((AbstractCompositeType)comparator, key));
        } else {
            this.setTupleValue(tuple, 0, this.getDefaultMarshallers(cfDef).get((Object)AbstractCassandraStorage.MarshallerType.KEY_VALIDATOR).compose(key));
        }
    }

    private void setLocationFromUri(String location) throws IOException {
        try {
            String[] parts;
            String[] credentialsAndKeyspace;
            if (!location.startsWith("cassandra://")) {
                throw new Exception("Bad scheme." + location);
            }
            String[] urlParts = location.split("\\?");
            if (urlParts.length > 1) {
                Map<String, String> urlQuery = CassandraStorage.getQueryMap(urlParts[1]);
                AbstractType comparator = BytesType.instance;
                if (urlQuery.containsKey("comparator")) {
                    comparator = TypeParser.parse(urlQuery.get("comparator"));
                }
                if (urlQuery.containsKey("slice_start")) {
                    this.slice_start = comparator.fromString(urlQuery.get("slice_start"));
                }
                if (urlQuery.containsKey("slice_end")) {
                    this.slice_end = comparator.fromString(urlQuery.get("slice_end"));
                }
                if (urlQuery.containsKey("reversed")) {
                    this.slice_reverse = Boolean.parseBoolean(urlQuery.get("reversed"));
                }
                if (urlQuery.containsKey("limit")) {
                    this.limit = Integer.parseInt(urlQuery.get("limit"));
                }
                if (urlQuery.containsKey("allow_deletes")) {
                    this.allow_deletes = Boolean.parseBoolean(urlQuery.get("allow_deletes"));
                }
                if (urlQuery.containsKey("widerows")) {
                    this.widerows = Boolean.parseBoolean(urlQuery.get("widerows"));
                }
                if (urlQuery.containsKey("use_secondary")) {
                    this.usePartitionFilter = Boolean.parseBoolean(urlQuery.get("use_secondary"));
                }
                if (urlQuery.containsKey("split_size")) {
                    this.splitSize = Integer.parseInt(urlQuery.get("split_size"));
                }
                if (urlQuery.containsKey("partitioner")) {
                    this.partitionerClass = urlQuery.get("partitioner");
                }
            }
            if ((credentialsAndKeyspace = (parts = urlParts[0].split("/+"))[1].split("@")).length > 1) {
                String[] credentials = credentialsAndKeyspace[0].split(":");
                this.username = credentials[0];
                this.password = credentials[1];
                this.keyspace = credentialsAndKeyspace[1];
            } else {
                this.keyspace = parts[1];
            }
            this.column_family = parts[2];
        }
        catch (Exception e) {
            throw new IOException("Expected 'cassandra://[username:password@]<keyspace>/<columnfamily>[?slice_start=<start>&slice_end=<end>[&reversed=true][&limit=1][&allow_deletes=true][&widerows=true][&use_secondary=true][&comparator=<comparator>][&split_size=<size>][&partitioner=<partitioner>]]': " + e.getMessage());
        }
    }
}

