/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.SliceByNamesReadCommandSerializer;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.filter.NamesQueryFilter;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.ByteBufferUtil;

public class SliceByNamesReadCommand
extends ReadCommand {
    static final SliceByNamesReadCommandSerializer serializer = new SliceByNamesReadCommandSerializer();
    public final NamesQueryFilter filter;

    public SliceByNamesReadCommand(String keyspaceName, ByteBuffer key, String cfName, long timestamp, NamesQueryFilter filter) {
        super(keyspaceName, key, cfName, timestamp, ReadCommand.Type.GET_BY_NAMES);
        this.filter = filter;
    }

    @Override
    public ReadCommand copy() {
        SliceByNamesReadCommand readCommand = new SliceByNamesReadCommand(this.ksName, this.key, this.cfName, this.timestamp, this.filter);
        readCommand.setDigestQuery(this.isDigestQuery());
        return readCommand;
    }

    @Override
    public Row getRow(Keyspace keyspace) {
        DecoratedKey dk = StorageService.getPartitioner().decorateKey(this.key);
        return keyspace.getRow(new QueryFilter(dk, this.cfName, this.filter, this.timestamp));
    }

    public String toString() {
        return "SliceByNamesReadCommand(keyspace='" + this.ksName + '\'' + ", key=" + ByteBufferUtil.bytesToHex(this.key) + ", cfName='" + this.cfName + '\'' + ", timestamp='" + this.timestamp + '\'' + ", filter=" + this.filter + ')';
    }

    @Override
    public IDiskAtomFilter filter() {
        return this.filter;
    }
}

