/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.CqlLexer;
import org.apache.cassandra.cql3.CqlParser;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.cql3.statements.BatchStatement;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.MD5Digest;
import org.apache.cassandra.utils.SemanticVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryProcessor {
    public static final SemanticVersion CQL_VERSION = new SemanticVersion("3.1.0");
    private static final Logger logger = LoggerFactory.getLogger(QueryProcessor.class);
    public static final int MAX_CACHE_PREPARED = 100000;
    private static final Map<MD5Digest, CQLStatement> preparedStatements = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(100000L).build();
    private static final Map<Integer, CQLStatement> thriftPreparedStatements = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(100000L).build();

    public static CQLStatement getPrepared(MD5Digest id) {
        return preparedStatements.get(id);
    }

    public static CQLStatement getPrepared(Integer id) {
        return thriftPreparedStatements.get(id);
    }

    public static void validateKey(ByteBuffer key) throws InvalidRequestException {
        if (key == null || key.remaining() == 0) {
            throw new InvalidRequestException("Key may not be empty");
        }
        if (key.remaining() > 65535) {
            throw new InvalidRequestException("Key length of " + key.remaining() + " is longer than maximum of " + 65535);
        }
    }

    public static void validateColumnNames(Iterable<ByteBuffer> columns) throws InvalidRequestException {
        for (ByteBuffer name : columns) {
            if (name.remaining() > 65535) {
                throw new InvalidRequestException(String.format("column name is too long (%s > %s)", name.remaining(), 65535));
            }
            if (name.remaining() != 0) continue;
            throw new InvalidRequestException("zero-length column name");
        }
    }

    private static ResultMessage processStatement(CQLStatement statement, QueryState queryState, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        logger.trace("Process {} @CL.{}", (Object)statement, (Object)options.getConsistency());
        ClientState clientState = queryState.getClientState();
        statement.checkAccess(clientState);
        statement.validate(clientState);
        ResultMessage result = statement.execute(queryState, options);
        return result == null ? new ResultMessage.Void() : result;
    }

    public static ResultMessage process(String queryString, ConsistencyLevel cl, QueryState queryState) throws RequestExecutionException, RequestValidationException {
        return QueryProcessor.process(queryString, queryState, new QueryOptions(cl, Collections.emptyList()));
    }

    public static ResultMessage process(String queryString, QueryState queryState, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        CQLStatement prepared = QueryProcessor.getStatement((String)queryString, (ClientState)queryState.getClientState()).statement;
        if (prepared.getBoundsTerms() != options.getValues().size()) {
            throw new InvalidRequestException("Invalid amount of bind variables");
        }
        return QueryProcessor.processStatement(prepared, queryState, options);
    }

    public static CQLStatement parseStatement(String queryStr, QueryState queryState) throws RequestValidationException {
        return QueryProcessor.getStatement((String)queryStr, (ClientState)queryState.getClientState()).statement;
    }

    public static UntypedResultSet process(String query, ConsistencyLevel cl) throws RequestExecutionException {
        try {
            QueryState state = new QueryState(new ClientState(true));
            ResultMessage result = QueryProcessor.process(query, state, new QueryOptions(cl, Collections.emptyList()));
            if (result instanceof ResultMessage.Rows) {
                return new UntypedResultSet(((ResultMessage.Rows)result).result);
            }
            return null;
        }
        catch (RequestValidationException e) {
            throw new RuntimeException(e);
        }
    }

    public static UntypedResultSet processInternal(String query) {
        try {
            ClientState state = new ClientState(true);
            QueryState qState = new QueryState(state);
            state.setKeyspace("system");
            CQLStatement statement = QueryProcessor.getStatement((String)query, (ClientState)state).statement;
            statement.validate(state);
            ResultMessage result = statement.executeInternal(qState);
            if (result instanceof ResultMessage.Rows) {
                return new UntypedResultSet(((ResultMessage.Rows)result).result);
            }
            return null;
        }
        catch (RequestExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (RequestValidationException e) {
            throw new RuntimeException("Error validating " + query, e);
        }
    }

    public static UntypedResultSet resultify(String query, Row row) {
        try {
            SelectStatement ss = (SelectStatement)QueryProcessor.getStatement((String)query, null).statement;
            ResultSet cqlRows = ss.process(Collections.singletonList(row));
            return new UntypedResultSet(cqlRows);
        }
        catch (RequestValidationException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ResultMessage.Prepared prepare(String queryString, ClientState clientState, boolean forThrift) throws RequestValidationException {
        ParsedStatement.Prepared prepared = QueryProcessor.getStatement(queryString, clientState);
        ResultMessage.Prepared msg = QueryProcessor.storePreparedStatement(queryString, clientState.getRawKeyspace(), prepared, forThrift);
        assert (prepared.statement.getBoundsTerms() == prepared.boundNames.size());
        return msg;
    }

    private static ResultMessage.Prepared storePreparedStatement(String queryString, String keyspace, ParsedStatement.Prepared prepared, boolean forThrift) {
        String toHash;
        String string = toHash = keyspace == null ? queryString : keyspace + queryString;
        if (forThrift) {
            int statementId = toHash.hashCode();
            thriftPreparedStatements.put(statementId, prepared.statement);
            logger.trace(String.format("Stored prepared statement #%d with %d bind markers", statementId, prepared.statement.getBoundsTerms()));
            return ResultMessage.Prepared.forThrift(statementId, prepared.boundNames);
        }
        MD5Digest statementId = MD5Digest.compute(toHash);
        logger.trace(String.format("Stored prepared statement %s with %d bind markers", statementId, prepared.statement.getBoundsTerms()));
        preparedStatements.put(statementId, prepared.statement);
        return new ResultMessage.Prepared(statementId, prepared);
    }

    public static ResultMessage processPrepared(CQLStatement statement, QueryState queryState, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        List<ByteBuffer> variables = options.getValues();
        if (!variables.isEmpty() || statement.getBoundsTerms() != 0) {
            if (variables.size() != statement.getBoundsTerms()) {
                throw new InvalidRequestException(String.format("there were %d markers(?) in CQL but %d bound variables", statement.getBoundsTerms(), variables.size()));
            }
            if (logger.isTraceEnabled()) {
                for (int i = 0; i < variables.size(); ++i) {
                    logger.trace("[{}] '{}'", (Object)(i + 1), (Object)variables.get(i));
                }
            }
        }
        return QueryProcessor.processStatement(statement, queryState, options);
    }

    public static ResultMessage processBatch(BatchStatement batch, ConsistencyLevel cl, QueryState queryState, List<List<ByteBuffer>> variables) throws RequestExecutionException, RequestValidationException {
        ClientState clientState = queryState.getClientState();
        batch.checkAccess(clientState);
        batch.validate(clientState);
        batch.executeWithPerStatementVariables(cl, queryState, variables);
        return new ResultMessage.Void();
    }

    private static ParsedStatement.Prepared getStatement(String queryStr, ClientState clientState) throws RequestValidationException {
        Tracing.trace("Parsing {}", queryStr);
        ParsedStatement statement = QueryProcessor.parseStatement(queryStr);
        if (statement instanceof CFStatement) {
            ((CFStatement)statement).prepareKeyspace(clientState);
        }
        Tracing.trace("Peparing statement");
        return statement.prepare();
    }

    public static ParsedStatement parseStatement(String queryStr) throws SyntaxException {
        try {
            ANTLRStringStream stream = new ANTLRStringStream(queryStr);
            CqlLexer lexer = new CqlLexer((CharStream)stream);
            CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
            CqlParser parser = new CqlParser((TokenStream)tokenStream);
            ParsedStatement statement = parser.query();
            lexer.throwLastRecognitionError();
            parser.throwLastRecognitionError();
            return statement;
        }
        catch (RuntimeException re) {
            SyntaxException ire = new SyntaxException("Failed parsing statement: [" + queryStr + "] reason: " + re.getClass().getSimpleName() + " " + re.getMessage());
            throw ire;
        }
        catch (RecognitionException e) {
            SyntaxException ire = new SyntaxException("Invalid or malformed CQL query string: " + e.getMessage());
            throw ire;
        }
    }
}

