/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.lz4;

import java.util.Arrays;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4Utils;
import net.jpountz.util.Utils;

final class LZ4JavaSafeCompressor
extends LZ4Compressor {
    public static final LZ4Compressor INSTANCE = new LZ4JavaSafeCompressor();

    LZ4JavaSafeCompressor() {
    }

    private int compress64k(byte[] src, int srcOff, int srcLen, byte[] dest, int destOff, int destEnd) {
        int srcEnd = srcOff + srcLen;
        int srcLimit = srcEnd - 5;
        int mflimit = srcEnd - 12;
        int sOff = srcOff;
        int dOff = destOff;
        int anchor = sOff++;
        if (srcLen > 13) {
            short[] hashTable = new short[8192];
            block0: while (true) {
                int token;
                int ref;
                int forwardOff = sOff;
                int findMatchAttempts = (1 << LZ4Utils.SKIP_STRENGTH) + 3;
                do {
                    sOff = forwardOff;
                    if ((forwardOff += findMatchAttempts++ >>> LZ4Utils.SKIP_STRENGTH) > mflimit) break block0;
                    int h = LZ4Utils.hash64k(src, sOff);
                    ref = srcOff + (hashTable[h] & 0xFFFF);
                    hashTable[h] = (short)(sOff - srcOff);
                } while (!LZ4Utils.readIntEquals(src, ref, sOff));
                int excess = LZ4Utils.commonBytesBackward(src, ref, sOff, srcOff, anchor);
                ref -= excess;
                int runLen = (sOff -= excess) - anchor;
                int tokenOff = dOff++;
                if (dOff + runLen + 8 + (runLen >>> 8) > destEnd) {
                    throw new LZ4Exception("maxDestLen is too small");
                }
                if (runLen >= 15) {
                    token = 240;
                    dOff = LZ4Utils.writeLen(runLen - 15, dest, dOff);
                } else {
                    token = runLen << 4;
                }
                LZ4Utils.wildArraycopy(src, anchor, dest, dOff, runLen);
                dOff += runLen;
                while (true) {
                    int back = sOff - ref;
                    dest[dOff++] = (byte)back;
                    dest[dOff++] = (byte)(back >>> 8);
                    int matchLen = LZ4Utils.commonBytes(src, ref + 4, sOff += 4, srcLimit);
                    if (dOff + 6 + (matchLen >>> 8) > destEnd) {
                        throw new LZ4Exception("maxDestLen is too small");
                    }
                    sOff += matchLen;
                    if (matchLen >= 15) {
                        token |= 0xF;
                        dOff = LZ4Utils.writeLen(matchLen - 15, dest, dOff);
                    } else {
                        token |= matchLen;
                    }
                    dest[tokenOff] = (byte)token;
                    if (sOff > mflimit) {
                        anchor = sOff;
                        break block0;
                    }
                    hashTable[LZ4Utils.hash64k((byte[])src, (int)(sOff - 2))] = (short)(sOff - 2 - srcOff);
                    int h = LZ4Utils.hash64k(src, sOff);
                    ref = srcOff + (hashTable[h] & 0xFFFF);
                    hashTable[h] = (short)(sOff - srcOff);
                    if (!LZ4Utils.readIntEquals(src, sOff, ref)) break;
                    tokenOff = dOff++;
                    token = 0;
                }
                anchor = sOff++;
            }
        }
        dOff = LZ4Utils.lastLiterals(src, anchor, srcEnd - anchor, dest, dOff, destEnd);
        return dOff - destOff;
    }

    @Override
    public final int compress(byte[] src, int srcOff, int srcLen, byte[] dest, int destOff, int maxDestLen) {
        Utils.checkRange(src, srcOff, srcLen);
        Utils.checkRange(dest, destOff, maxDestLen);
        int destEnd = destOff + maxDestLen;
        if (srcLen < 65547) {
            return this.compress64k(src, srcOff, srcLen, dest, destOff, destEnd);
        }
        int srcEnd = srcOff + srcLen;
        int srcLimit = srcEnd - 5;
        int mflimit = srcEnd - 12;
        int sOff = srcOff;
        int dOff = destOff;
        int anchor = sOff++;
        int[] hashTable = new int[4096];
        Arrays.fill(hashTable, anchor);
        block0: while (true) {
            int token;
            int ref;
            int back;
            int forwardOff = sOff;
            int findMatchAttempts = (1 << LZ4Utils.SKIP_STRENGTH) + 3;
            do {
                sOff = forwardOff;
                if ((forwardOff += findMatchAttempts++ >>> LZ4Utils.SKIP_STRENGTH) > mflimit) break block0;
                int h = LZ4Utils.hash(src, sOff);
                ref = hashTable[h];
                back = sOff - ref;
                hashTable[h] = sOff;
            } while (back >= 65536 || !LZ4Utils.readIntEquals(src, ref, sOff));
            int excess = LZ4Utils.commonBytesBackward(src, ref, sOff, srcOff, anchor);
            ref -= excess;
            int runLen = (sOff -= excess) - anchor;
            int tokenOff = dOff++;
            if (dOff + runLen + 8 + (runLen >>> 8) > destEnd) {
                throw new LZ4Exception("maxDestLen is too small");
            }
            if (runLen >= 15) {
                token = 240;
                dOff = LZ4Utils.writeLen(runLen - 15, dest, dOff);
            } else {
                token = runLen << 4;
            }
            LZ4Utils.wildArraycopy(src, anchor, dest, dOff, runLen);
            dOff += runLen;
            while (true) {
                dest[dOff++] = (byte)back;
                dest[dOff++] = (byte)(back >>> 8);
                int matchLen = LZ4Utils.commonBytes(src, ref + 4, sOff += 4, srcLimit);
                if (dOff + 6 + (matchLen >>> 8) > destEnd) {
                    throw new LZ4Exception("maxDestLen is too small");
                }
                sOff += matchLen;
                if (matchLen >= 15) {
                    token |= 0xF;
                    dOff = LZ4Utils.writeLen(matchLen - 15, dest, dOff);
                } else {
                    token |= matchLen;
                }
                dest[tokenOff] = (byte)token;
                if (sOff > mflimit) {
                    anchor = sOff;
                    break block0;
                }
                hashTable[LZ4Utils.hash((byte[])src, (int)(sOff - 2))] = sOff - 2;
                int h = LZ4Utils.hash(src, sOff);
                ref = hashTable[h];
                hashTable[h] = sOff;
                back = sOff - ref;
                if (back >= 65536 || !LZ4Utils.readIntEquals(src, ref, sOff)) break;
                tokenOff = dOff++;
                token = 0;
            }
            anchor = sOff++;
        }
        dOff = LZ4Utils.lastLiterals(src, anchor, srcEnd - anchor, dest, dOff, destEnd);
        return dOff - destOff;
    }
}

