/*
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 */

package org.apache.cassandra.auth;

import java.util.List;

import org.apache.cassandra.utils.FBUtilities;

/**
 * Constants related to Cassandra's resource hierarchy.
 *
 * A resource in Cassandra is a List containing both Strings and byte[]s.
 */
public final class Resources
{
    public final static String ROOT = "cassandra";
    public final static String KEYSPACES = "keyspaces";

    public static String toString(List<Object> resource)
    {
        StringBuilder buff = new StringBuilder();
        for (Object component : resource)
        {
            buff.append("/");
            if (component instanceof byte[])
                buff.append(FBUtilities.bytesToHex((byte[])component));
            else
                buff.append(component.toString());
        }
        return buff.toString();
    }
}
