/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.concurrentlinkedhashmap;

import com.googlecode.concurrentlinkedhashmap.CapacityLimiter;
import com.googlecode.concurrentlinkedhashmap.EvictionListener;
import com.googlecode.concurrentlinkedhashmap.GuardedBy;
import com.googlecode.concurrentlinkedhashmap.ThreadSafe;
import com.googlecode.concurrentlinkedhashmap.Weigher;
import com.googlecode.concurrentlinkedhashmap.Weighers;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractQueue;
import java.util.AbstractSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@ThreadSafe
public final class ConcurrentLinkedHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
Serializable {
    static final int RECENCY_THRESHOLD = 16;
    static final int MAXIMUM_SEGMENTS = 65536;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int MAXIMUM_WEIGHT = 0x20000000;
    static final Queue<?> discardingQueue = new DiscardingQueue();
    final ConcurrentMap<K, Node> data;
    final int concurrencyLevel;
    final int segmentMask;
    final int segmentShift;
    final Lock[] segmentLock;
    @GuardedBy(value="evictionLock")
    final Node sentinel;
    @GuardedBy(value="evictionLock")
    volatile int weightedSize;
    @GuardedBy(value="evictionLock")
    volatile int maximumWeightedSize;
    final Lock evictionLock;
    volatile int globalRecencyOrder;
    final Weigher<? super V> weigher;
    final Queue<Runnable> writeQueue;
    final CapacityLimiter capacityLimiter;
    final AtomicIntegerArray recencyQueueLength;
    final Queue<RecencyReference>[] recencyQueue;
    final Queue<Node> listenerQueue;
    final EvictionListener<K, V> listener;
    transient Set<K> keySet;
    transient Collection<V> values;
    transient Set<Map.Entry<K, V>> entrySet;
    static final long serialVersionUID = 1L;

    private ConcurrentLinkedHashMap(Builder<K, V> builder) {
        int segments;
        this.concurrencyLevel = Math.min(builder.concurrencyLevel, 65536);
        int sshift = 0;
        for (segments = 1; segments < this.concurrencyLevel; segments <<= 1) {
            ++sshift;
        }
        this.segmentShift = 32 - sshift;
        this.segmentMask = segments - 1;
        this.segmentLock = new Lock[segments];
        for (int i = 0; i < segments; ++i) {
            this.segmentLock[i] = new ReentrantLock();
        }
        this.data = new ConcurrentHashMap<K, Node>(builder.initialCapacity, 0.75f, this.concurrencyLevel);
        this.maximumWeightedSize = Math.min(builder.maximumWeightedCapacity, 0x40000000);
        this.sentinel = new Node();
        this.weigher = builder.weigher;
        this.evictionLock = new ReentrantLock();
        this.globalRecencyOrder = Integer.MIN_VALUE;
        this.capacityLimiter = builder.capacityLimiter;
        this.writeQueue = new ConcurrentLinkedQueue<Runnable>();
        int numberOfQueues = segments % 2 == 0 ? segments : segments + 1;
        this.recencyQueue = new Queue[numberOfQueues];
        this.recencyQueueLength = new AtomicIntegerArray(numberOfQueues);
        for (int i = 0; i < numberOfQueues; ++i) {
            this.recencyQueue[i] = new ConcurrentLinkedQueue<RecencyReference>();
        }
        this.listener = builder.listener;
        this.listenerQueue = this.listener == DiscardingListener.INSTANCE ? discardingQueue : new ConcurrentLinkedQueue();
    }

    static void checkNotNull(Object o, String message) {
        if (o == null) {
            throw new NullPointerException(message);
        }
    }

    public int capacity() {
        return this.maximumWeightedSize;
    }

    public void setCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        this.maximumWeightedSize = Math.min(capacity, 0x40000000);
        this.evictWith(this.capacityLimiter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evictWith(CapacityLimiter capacityLimiter) {
        ConcurrentLinkedHashMap.checkNotNull(capacityLimiter, "null capacity limiter");
        this.evictionLock.lock();
        try {
            this.drainRecencyQueues();
            this.drainWriteQueue();
            this.evict(capacityLimiter);
        }
        finally {
            this.evictionLock.unlock();
        }
        this.notifyListener();
    }

    boolean hasOverflowed(CapacityLimiter capacityLimiter) {
        return capacityLimiter.hasExceededCapacity(this);
    }

    @GuardedBy(value="evictionLock")
    void evict(CapacityLimiter capacityLimiter) {
        while (this.hasOverflowed(capacityLimiter)) {
            Node node = this.sentinel.next;
            if (node == this.sentinel) {
                return;
            }
            if (this.data.remove(node.key, node)) {
                this.listenerQueue.add(node);
            }
            this.decrementWeightFor(node);
            node.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="evictionLock")
    void decrementWeightFor(Node node) {
        if (this.weigher == Weighers.singleton()) {
            --this.weightedSize;
        } else {
            Lock lock = this.segmentLock[node.segment];
            lock.lock();
            try {
                this.weightedSize -= node.weightedValue.weight;
            }
            finally {
                lock.unlock();
            }
        }
    }

    int segmentFor(Object key) {
        int hash = ConcurrentLinkedHashMap.spread(key.hashCode());
        return hash >>> this.segmentShift & this.segmentMask;
    }

    static int spread(int hashCode) {
        hashCode += hashCode << 15 ^ 0xFFFFCD7D;
        hashCode ^= hashCode >>> 10;
        hashCode += hashCode << 3;
        hashCode ^= hashCode >>> 6;
        hashCode += (hashCode << 2) + (hashCode << 14);
        return hashCode ^ hashCode >>> 16;
    }

    boolean addToRecencyQueue(Node node) {
        int index = (int)Thread.currentThread().getId() % this.recencyQueue.length;
        int recencyOrder = this.globalRecencyOrder++;
        this.recencyQueue[index].add(new RecencyReference(node, recencyOrder));
        int buffered = this.recencyQueueLength.incrementAndGet(index);
        return buffered <= 16;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tryToDrainEvictionQueues(boolean onlyIfWrites) {
        if (onlyIfWrites && this.writeQueue.isEmpty()) {
            return;
        }
        if (this.evictionLock.tryLock()) {
            try {
                this.drainRecencyQueues();
                this.drainWriteQueue();
            }
            finally {
                this.evictionLock.unlock();
            }
        }
    }

    @GuardedBy(value="evictionLock")
    void drainWriteQueue() {
        Runnable task;
        while ((task = this.writeQueue.poll()) != null) {
            task.run();
        }
    }

    @GuardedBy(value="evictionLock")
    void drainRecencyQueues() {
        ArrayDeque<List<RecencyReference>> lists = new ArrayDeque<List<RecencyReference>>(this.recencyQueue.length / 2);
        for (int i = 0; i < this.recencyQueue.length; i += 2) {
            lists.add(this.moveRecenciesIntoMergedList(i, i + 1));
        }
        while (lists.size() > 1) {
            lists.add(this.mergeRecencyLists((List)lists.poll(), (List)lists.poll()));
        }
        this.applyRecencyReorderings((List)lists.peek());
    }

    @GuardedBy(value="evictionLock")
    List<RecencyReference> moveRecenciesIntoMergedList(int index1, int index2) {
        int removedFromQueue1 = 0;
        int removedFromQueue2 = 0;
        int initialCapacity = 48;
        ArrayList<RecencyReference> result = new ArrayList<RecencyReference>(initialCapacity);
        Queue<RecencyReference> queue1 = this.recencyQueue[index1];
        Queue<RecencyReference> queue2 = this.recencyQueue[index2];
        RecencyReference recency1 = queue1.poll();
        RecencyReference recency2 = queue2.poll();
        while (true) {
            if (recency1 == null) {
                if (recency2 == null) break;
                result.add(recency2);
                removedFromQueue2 += 1 + this.moveRecenciesToList(queue2, result);
                break;
            }
            if (recency2 == null) {
                result.add(recency1);
                removedFromQueue1 += 1 + this.moveRecenciesToList(queue1, result);
                break;
            }
            if (recency1.recencyOrder < recency2.recencyOrder) {
                ++removedFromQueue1;
                result.add(recency1);
                recency1 = queue1.poll();
                continue;
            }
            ++removedFromQueue2;
            result.add(recency2);
            recency2 = queue2.poll();
        }
        this.recencyQueueLength.addAndGet(index1, -removedFromQueue1);
        this.recencyQueueLength.addAndGet(index2, -removedFromQueue2);
        return result;
    }

    @GuardedBy(value="evictionLock")
    int moveRecenciesToList(Queue<RecencyReference> queue, List<RecencyReference> output) {
        RecencyReference recency;
        int removed = 0;
        while ((recency = queue.poll()) != null) {
            output.add(recency);
            ++removed;
        }
        return removed;
    }

    @GuardedBy(value="evictionLock")
    List<RecencyReference> mergeRecencyLists(List<RecencyReference> list1, List<RecencyReference> list2) {
        if (list1.isEmpty()) {
            return list2;
        }
        if (list2.isEmpty()) {
            return list1;
        }
        ArrayList<RecencyReference> result = new ArrayList<RecencyReference>(list1.size() + list2.size());
        int index1 = 0;
        int index2 = 0;
        while (true) {
            if (index1 == list1.size()) {
                while (index2 != list2.size()) {
                    result.add(list2.get(index2));
                    ++index2;
                }
                return result;
            }
            if (index2 == list2.size()) {
                while (index1 != list1.size()) {
                    result.add(list1.get(index1));
                    ++index1;
                }
                return result;
            }
            RecencyReference recency1 = list1.get(index1);
            RecencyReference recency2 = list2.get(index2);
            if (recency1.recencyOrder < recency2.recencyOrder) {
                result.add(recency1);
                ++index1;
                continue;
            }
            result.add(recency2);
            ++index2;
        }
    }

    @GuardedBy(value="evictionLock")
    void applyRecencyReorderings(List<RecencyReference> recencies) {
        for (int i = 0; i < recencies.size(); ++i) {
            RecencyReference recency = recencies.get(i);
            Node node = (Node)recency.get();
            if (node == null || !node.isLinked()) continue;
            node.moveToTail();
        }
    }

    void processEvents(boolean onlyIfWrites) {
        this.tryToDrainEvictionQueues(onlyIfWrites);
        this.notifyListener();
    }

    void notifyListener() {
        Node node;
        while ((node = this.listenerQueue.poll()) != null) {
            this.listener.onEviction(node.key, node.weightedValue.value);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public int size() {
        return this.data.size();
    }

    public int weightedSize() {
        return this.weightedSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.evictionLock.lock();
        try {
            this.drainWriteQueue();
            Node current = this.sentinel.next;
            while (current != this.sentinel) {
                this.data.remove(current.key, current);
                this.decrementWeightFor(current);
                current = current.next;
                current.prev.prev = null;
                current.prev.next = null;
            }
            this.sentinel.next = this.sentinel;
            this.sentinel.prev = this.sentinel;
            for (int i = 0; i < this.recencyQueue.length; ++i) {
                Queue<RecencyReference> queue = this.recencyQueue[i];
                int removed = 0;
                while (queue.poll() != null) {
                    ++removed;
                }
                this.recencyQueueLength.addAndGet(i, -removed);
            }
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        ConcurrentLinkedHashMap.checkNotNull(key, "null key");
        this.processEvents(true);
        return this.data.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        ConcurrentLinkedHashMap.checkNotNull(value, "null value");
        this.processEvents(true);
        for (Node node : this.data.values()) {
            if (!node.weightedValue.value.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        ConcurrentLinkedHashMap.checkNotNull(key, "null key");
        V value = null;
        boolean delayReorder = true;
        Node node = (Node)this.data.get(key);
        if (node != null) {
            delayReorder = this.addToRecencyQueue(node);
            value = node.weightedValue.value;
        }
        this.processEvents(delayReorder);
        return value;
    }

    @Override
    public V put(K key, V value) {
        return this.put(key, value, false);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.put(key, value, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    V put(K key, V value, boolean onlyIfAbsent) {
        Node prior;
        ConcurrentLinkedHashMap.checkNotNull(key, "null key");
        ConcurrentLinkedHashMap.checkNotNull(value, "null value");
        V oldValue = null;
        int weightedDifference = 0;
        boolean delayReorder = true;
        int segment = this.segmentFor(key);
        Lock lock = this.segmentLock[segment];
        int weight = this.weigher.weightOf(value);
        WeightedValue<V> weightedValue = new WeightedValue<V>(value, weight);
        Node node = new Node(key, weightedValue, segment);
        lock.lock();
        try {
            prior = this.data.putIfAbsent(node.key, node);
            if (prior == null) {
                this.writeQueue.add(new AddTask(node, weight));
            } else if (onlyIfAbsent) {
                oldValue = prior.weightedValue.value;
            } else {
                WeightedValue oldWeightedValue = prior.weightedValue;
                weightedDifference = weight - oldWeightedValue.weight;
                prior.weightedValue = weightedValue;
                oldValue = oldWeightedValue.value;
            }
        }
        finally {
            lock.unlock();
        }
        if (prior != null) {
            if (weightedDifference != 0) {
                this.writeQueue.add(new UpdateTask(weightedDifference));
            }
            delayReorder = this.addToRecencyQueue(prior);
        }
        this.processEvents(delayReorder);
        return oldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        ConcurrentLinkedHashMap.checkNotNull(key, "null key");
        V value = null;
        int segment = this.segmentFor(key);
        Lock lock = this.segmentLock[segment];
        Node node = (Node)this.data.remove(key);
        if (node != null) {
            value = node.weightedValue.value;
            RemovalTask task = new RemovalTask(node);
            lock.lock();
            try {
                this.writeQueue.add(task);
            }
            finally {
                lock.unlock();
            }
        }
        this.processEvents(true);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        ConcurrentLinkedHashMap.checkNotNull(key, "null key");
        ConcurrentLinkedHashMap.checkNotNull(value, "null value");
        boolean removed = false;
        int segment = this.segmentFor(key);
        Lock lock = this.segmentLock[segment];
        lock.lock();
        try {
            Node node = (Node)this.data.get(key);
            if (node != null && node.weightedValue.value.equals(value)) {
                this.writeQueue.add(new RemovalTask(node));
                this.data.remove(key);
                removed = true;
            }
        }
        finally {
            lock.unlock();
        }
        this.processEvents(true);
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(K key, V value) {
        Node node;
        ConcurrentLinkedHashMap.checkNotNull(key, "null key");
        ConcurrentLinkedHashMap.checkNotNull(value, "null value");
        V prior = null;
        int weightedDifference = 0;
        boolean delayReorder = false;
        int segment = this.segmentFor(key);
        Lock lock = this.segmentLock[segment];
        int weight = this.weigher.weightOf(value);
        WeightedValue<V> weightedValue = new WeightedValue<V>(value, weight);
        lock.lock();
        try {
            node = (Node)this.data.get(key);
            if (node != null) {
                WeightedValue oldWeightedValue = node.weightedValue;
                weightedDifference = weight - oldWeightedValue.weight;
                node.weightedValue = weightedValue;
                prior = oldWeightedValue.value;
            }
        }
        finally {
            lock.unlock();
        }
        if (node != null) {
            if (weightedDifference != 0) {
                this.writeQueue.add(new UpdateTask(weightedDifference));
            }
            delayReorder = this.addToRecencyQueue(node);
        }
        this.processEvents(delayReorder);
        return prior;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        Node node;
        ConcurrentLinkedHashMap.checkNotNull(key, "null key");
        ConcurrentLinkedHashMap.checkNotNull(oldValue, "null oldValue");
        ConcurrentLinkedHashMap.checkNotNull(newValue, "null newValue");
        boolean delayReorder = false;
        int segment = this.segmentFor(key);
        Lock lock = this.segmentLock[segment];
        int weight = this.weigher.weightOf(newValue);
        WeightedValue oldWeightedValue = null;
        WeightedValue<V> newWeightedValue = new WeightedValue<V>(newValue, weight);
        lock.lock();
        try {
            node = (Node)this.data.get(key);
            if (node != null) {
                WeightedValue weightedValue = node.weightedValue;
                if (oldValue.equals(weightedValue.value)) {
                    node.weightedValue = newWeightedValue;
                    oldWeightedValue = weightedValue;
                }
            }
        }
        finally {
            lock.unlock();
        }
        if (node != null) {
            if (oldWeightedValue != null) {
                int weightedDifference = weight - oldWeightedValue.weight;
                this.writeQueue.add(new UpdateTask(weightedDifference));
            }
            delayReorder = this.addToRecencyQueue(node);
        }
        this.processEvents(delayReorder);
        return oldWeightedValue != null;
    }

    @Override
    public Set<K> keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    @Override
    public Collection<V> values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    Object writeReplace() {
        return new SerializationProxy(this);
    }

    void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    public static final class Builder<K, V> {
        static final int DEFAULT_INITIAL_CAPACITY = 16;
        static final int DEFAULT_CONCURRENCY_LEVEL = 16;
        CapacityLimiter capacityLimiter;
        EvictionListener<K, V> listener;
        Weigher<? super V> weigher = Weighers.singleton();
        int maximumWeightedCapacity = -1;
        int concurrencyLevel = 16;
        int initialCapacity = 16;

        public Builder() {
            this.capacityLimiter = WeightedCapacityLimiter.INSTANCE;
            this.listener = DiscardingListener.INSTANCE;
        }

        public Builder<K, V> initialCapacity(int initialCapacity) {
            if (initialCapacity < 0) {
                throw new IllegalArgumentException();
            }
            this.initialCapacity = initialCapacity;
            return this;
        }

        public Builder<K, V> maximumWeightedCapacity(int maximumWeightedCapacity) {
            if (maximumWeightedCapacity < 0) {
                throw new IllegalArgumentException();
            }
            this.maximumWeightedCapacity = maximumWeightedCapacity;
            return this;
        }

        public Builder<K, V> concurrencyLevel(int concurrencyLevel) {
            if (concurrencyLevel <= 0) {
                throw new IllegalArgumentException();
            }
            this.concurrencyLevel = concurrencyLevel;
            return this;
        }

        public Builder<K, V> listener(EvictionListener<K, V> listener) {
            ConcurrentLinkedHashMap.checkNotNull(listener, null);
            this.listener = listener;
            return this;
        }

        public Builder<K, V> weigher(Weigher<? super V> weigher) {
            ConcurrentLinkedHashMap.checkNotNull(weigher, null);
            this.weigher = weigher;
            return this;
        }

        public Builder<K, V> capacityLimiter(CapacityLimiter capacityLimiter) {
            ConcurrentLinkedHashMap.checkNotNull(capacityLimiter, null);
            this.capacityLimiter = capacityLimiter;
            return this;
        }

        public ConcurrentLinkedHashMap<K, V> build() {
            if (this.maximumWeightedCapacity < 0) {
                throw new IllegalStateException();
            }
            return new ConcurrentLinkedHashMap(this);
        }
    }

    static final class SerializationProxy<K, V>
    implements Serializable {
        final EvictionListener<K, V> listener;
        final CapacityLimiter capacityLimiter;
        final Weigher<? super V> weigher;
        final int concurrencyLevel;
        final Map<K, V> data;
        final int capacity;
        static final long serialVersionUID = 1L;

        SerializationProxy(ConcurrentLinkedHashMap<K, V> map) {
            this.concurrencyLevel = map.concurrencyLevel;
            this.capacityLimiter = map.capacityLimiter;
            this.capacity = map.maximumWeightedSize;
            this.data = new HashMap<K, V>(map);
            this.listener = map.listener;
            this.weigher = map.weigher;
        }

        Object readResolve() {
            ConcurrentLinkedHashMap<K, V> map = new Builder().concurrencyLevel(this.concurrencyLevel).maximumWeightedCapacity(this.capacity).capacityLimiter(this.capacityLimiter).listener(this.listener).weigher(this.weigher).build();
            map.putAll(this.data);
            return map;
        }
    }

    static enum WeightedCapacityLimiter implements CapacityLimiter
    {
        INSTANCE;


        @Override
        @GuardedBy(value="evictionLock")
        public boolean hasExceededCapacity(ConcurrentLinkedHashMap<?, ?> map) {
            return map.weightedSize() > map.capacity();
        }
    }

    static enum DiscardingListener implements EvictionListener<Object, Object>
    {
        INSTANCE;


        @Override
        public void onEviction(Object key, Object value) {
        }
    }

    static final class DiscardingQueue<E>
    extends AbstractQueue<E> {
        DiscardingQueue() {
        }

        @Override
        public boolean add(E e) {
            return true;
        }

        @Override
        public boolean offer(E e) {
            return true;
        }

        @Override
        public E poll() {
            return null;
        }

        @Override
        public E peek() {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator<E> iterator() {
            return Collections.emptyList().iterator();
        }
    }

    final class WriteThroughEntry
    extends AbstractMap.SimpleEntry<K, V> {
        static final long serialVersionUID = 1L;

        public WriteThroughEntry(Node node) {
            super(node.key, node.weightedValue.value);
        }

        @Override
        public V setValue(V value) {
            ConcurrentLinkedHashMap.this.put(this.getKey(), value);
            return super.setValue(value);
        }

        Object writeReplace() {
            return new AbstractMap.SimpleEntry(this);
        }
    }

    final class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        final Iterator<Node> iterator;
        Node current;

        public EntryIterator(Iterator<Node> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            this.current = this.iterator.next();
            return new WriteThroughEntry(this.current);
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            ConcurrentLinkedHashMap.this.remove(this.current.key, this.current.weightedValue.value);
            this.current = null;
        }
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        final ConcurrentLinkedHashMap<K, V> map;

        EntrySet() {
            this.map = ConcurrentLinkedHashMap.this;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(this.map.data.values().iterator());
        }

        @Override
        public boolean contains(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            Node node = (Node)this.map.data.get(entry.getKey());
            return node != null && node.weightedValue.value.equals(entry.getValue());
        }

        @Override
        public boolean add(Map.Entry<K, V> entry) {
            return this.map.putIfAbsent(entry.getKey(), entry.getValue()) == null;
        }

        @Override
        public boolean remove(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            return this.map.remove(entry.getKey(), entry.getValue());
        }
    }

    final class ValueIterator
    implements Iterator<V> {
        final EntryIterator iterator;

        ValueIterator() {
            this.iterator = new EntryIterator(ConcurrentLinkedHashMap.this.data.values().iterator());
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public V next() {
            return this.iterator.next().getValue();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public int size() {
            return ConcurrentLinkedHashMap.this.size();
        }

        @Override
        public void clear() {
            ConcurrentLinkedHashMap.this.clear();
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public boolean contains(Object o) {
            return ConcurrentLinkedHashMap.this.containsValue(o);
        }
    }

    final class KeyIterator
    implements Iterator<K> {
        final EntryIterator iterator;

        KeyIterator() {
            this.iterator = new EntryIterator(ConcurrentLinkedHashMap.this.data.values().iterator());
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public K next() {
            return this.iterator.next().getKey();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    final class KeySet
    extends AbstractSet<K> {
        final ConcurrentLinkedHashMap<K, V> map;

        KeySet() {
            this.map = ConcurrentLinkedHashMap.this;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public boolean contains(Object obj) {
            return ConcurrentLinkedHashMap.this.containsKey(obj);
        }

        @Override
        public boolean remove(Object obj) {
            return this.map.remove(obj) != null;
        }

        @Override
        public Object[] toArray() {
            return this.map.data.keySet().toArray();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return this.map.data.keySet().toArray(array);
        }
    }

    final class Node {
        final K key;
        @GuardedBy(value="segmentLock")
        volatile WeightedValue<V> weightedValue;
        final int segment;
        @GuardedBy(value="evictionLock")
        Node prev;
        @GuardedBy(value="evictionLock")
        Node next;

        Node() {
            this.segment = -1;
            this.key = null;
            this.prev = this;
            this.next = this;
        }

        Node(K key, WeightedValue<V> weightedValue, int segment) {
            this.weightedValue = weightedValue;
            this.segment = segment;
            this.key = key;
            this.prev = null;
            this.next = null;
        }

        @GuardedBy(value="evictionLock")
        void remove() {
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.next = null;
            this.prev = null;
        }

        @GuardedBy(value="evictionLock")
        void appendToTail() {
            this.prev = ConcurrentLinkedHashMap.this.sentinel.prev;
            this.next = ConcurrentLinkedHashMap.this.sentinel;
            ConcurrentLinkedHashMap.this.sentinel.prev.next = this;
            ConcurrentLinkedHashMap.this.sentinel.prev = this;
        }

        @GuardedBy(value="evictionLock")
        void moveToTail() {
            if (this.next != ConcurrentLinkedHashMap.this.sentinel) {
                this.prev.next = this.next;
                this.next.prev = this.prev;
                this.appendToTail();
            }
        }

        @GuardedBy(value="evictionLock")
        boolean isLinked() {
            return this.next != null;
        }
    }

    static final class WeightedValue<V> {
        final int weight;
        final V value;

        public WeightedValue(V value, int weight) {
            if (weight < 1 || weight > 0x20000000) {
                throw new IllegalArgumentException("invalid weight");
            }
            this.weight = weight;
            this.value = value;
        }
    }

    final class UpdateTask
    implements Runnable {
        final int weightDifference;

        public UpdateTask(int weightDifference) {
            this.weightDifference = weightDifference;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public void run() {
            ConcurrentLinkedHashMap.this.weightedSize += this.weightDifference;
            ConcurrentLinkedHashMap.this.evict(ConcurrentLinkedHashMap.this.capacityLimiter);
        }
    }

    final class RemovalTask
    implements Runnable {
        final Node node;

        RemovalTask(Node node) {
            this.node = node;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public void run() {
            if (this.node.isLinked()) {
                ConcurrentLinkedHashMap.this.weightedSize -= this.node.weightedValue.weight;
                this.node.remove();
            }
        }
    }

    final class AddTask
    implements Runnable {
        final Node node;
        final int weight;

        AddTask(Node node, int weight) {
            this.weight = weight;
            this.node = node;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public void run() {
            ConcurrentLinkedHashMap.this.weightedSize += this.weight;
            this.node.appendToTail();
            ConcurrentLinkedHashMap.this.evict(ConcurrentLinkedHashMap.this.capacityLimiter);
        }
    }

    final class RecencyReference
    extends WeakReference<Node> {
        final int recencyOrder;

        public RecencyReference(Node node, int recencyOrder) {
            super(node);
            this.recencyOrder = recencyOrder;
        }
    }
}

